/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.center;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenNexus
extends WorldgenObject {
    public int mHeight = this.getConfigFile().get((Object)this.mCategory, "Height", (long)(WD.waterLevel() + 4));

    @SafeVarargs
    public WorldgenNexus(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        CS.GENERATE_NEXUS = this.mEnabled;
    }

    @Override
    public boolean enabled(World aWorld, int aDimType) {
        return CS.GENERATE_NEXUS && aWorld.field_73011_w.field_76574_g == 0;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aMinX != 16 || aMinZ != -48) {
            return false;
        }
        boolean[] fWindow = new boolean[]{false, true, true, true, true, false, true, true, true, true, false, true, true, true, true, false};
        if (CS.GENERATE_STREETS) {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    int k;
                    for (k = 2; k < 64; ++k) {
                        WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                    }
                    for (k = 1; k < this.mHeight; ++k) {
                        WD.set(aChunk, i, k, j, CS.BlocksGT.Concrete, 8L);
                    }
                    WD.set(aChunk, i, this.mHeight + 1, j, CS.BlocksGT.CFoam, 8L);
                    if (i == 0 || i == 15 || j == 0 || j == 15) {
                        WD.set(aChunk, i, this.mHeight + 0, j, CS.BlocksGT.Concrete, 8L);
                        WD.set(aChunk, i, this.mHeight + 2, j, CS.BlocksGT.Concrete, 7L);
                        WD.set(aChunk, i, this.mHeight + 3, j, CS.BlocksGT.Concrete, 7L);
                        WD.set(aChunk, i, this.mHeight + 4, j, CS.BlocksGT.Concrete, 7L);
                        WD.set(aChunk, i, this.mHeight + 5, j, CS.BlocksGT.Concrete, 7L);
                        WD.set(aChunk, i, this.mHeight + 6, j, CS.BlocksGT.Concrete, 7L);
                        WD.set(aChunk, i, this.mHeight + 7, j, CS.BlocksGT.CFoam, 8L);
                        WD.set(aChunk, i, this.mHeight + 8, j, CS.BlocksGT.Concrete, 7L);
                        if (fWindow[i] || fWindow[j]) {
                            WD.set(aChunk, i, this.mHeight + 9, j, CS.BlocksGT.Glass, 12L);
                            WD.set(aChunk, i, this.mHeight + 10, j, CS.BlocksGT.Glass, 12L);
                            WD.set(aChunk, i, this.mHeight + 11, j, CS.BlocksGT.Glass, 12L);
                        } else {
                            WD.set(aChunk, i, this.mHeight + 9, j, CS.BlocksGT.Concrete, 7L);
                            WD.set(aChunk, i, this.mHeight + 10, j, CS.BlocksGT.Concrete, 7L);
                            WD.set(aChunk, i, this.mHeight + 11, j, CS.BlocksGT.Concrete, 7L);
                        }
                        WD.set(aChunk, i, this.mHeight + 12, j, CS.BlocksGT.Concrete, 7L);
                    } else {
                        WD.set(aChunk, i, this.mHeight + 0, j, Blocks.field_150343_Z, 0L);
                    }
                    WD.set(aChunk, i, this.mHeight + 13, j, CS.BlocksGT.CFoam, 8L);
                }
            }
        } else {
            int tRockType = CS.RNGSUS.nextInt(CS.BlocksGT.stones.length);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    int k;
                    for (k = 2; k < 64; ++k) {
                        WD.set(aChunk, i, this.mHeight + k, j, CS.NB, 0L);
                    }
                    for (k = 1; k < this.mHeight; ++k) {
                        WD.set(aChunk, i, k, j, CS.BlocksGT.stones[tRockType], 0L);
                    }
                    WD.set(aChunk, i, this.mHeight + 1, j, CS.BlocksGT.stones[tRockType], 10L);
                    if (i == 0 || i == 15 || j == 0 || j == 15) {
                        WD.set(aChunk, i, this.mHeight + 0, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 2, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 3, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 4, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 5, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 6, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        WD.set(aChunk, i, this.mHeight + 7, j, CS.BlocksGT.stones[tRockType], 6L);
                        WD.set(aChunk, i, this.mHeight + 8, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        if (fWindow[i] || fWindow[j]) {
                            WD.set(aChunk, i, this.mHeight + 9, j, Blocks.field_150410_aZ, 0L);
                            WD.set(aChunk, i, this.mHeight + 10, j, Blocks.field_150410_aZ, 0L);
                            WD.set(aChunk, i, this.mHeight + 11, j, Blocks.field_150410_aZ, 0L);
                        } else {
                            WD.set(aChunk, i, this.mHeight + 9, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                            WD.set(aChunk, i, this.mHeight + 10, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                            WD.set(aChunk, i, this.mHeight + 11, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                        }
                        WD.set(aChunk, i, this.mHeight + 12, j, CS.BlocksGT.stones[tRockType], 3 + CS.RNGSUS.nextInt(3));
                    } else {
                        WD.set(aChunk, i, this.mHeight + 0, j, Blocks.field_150343_Z, 0L);
                    }
                    WD.set(aChunk, i, this.mHeight + 13, j, CS.BlocksGT.stones[tRockType], 11L);
                }
            }
        }
        WD.set(aChunk, 5, this.mHeight + 2, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 2, 15, CS.NB, 0L);
        WD.set(aChunk, 7, this.mHeight + 2, 15, CS.NB, 0L);
        WD.set(aChunk, 8, this.mHeight + 2, 15, CS.NB, 0L);
        WD.set(aChunk, 9, this.mHeight + 2, 15, CS.NB, 0L);
        WD.set(aChunk, 10, this.mHeight + 2, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 5, this.mHeight + 3, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 3, 15, CS.NB, 0L);
        WD.set(aChunk, 7, this.mHeight + 3, 15, CS.NB, 0L);
        WD.set(aChunk, 8, this.mHeight + 3, 15, CS.NB, 0L);
        WD.set(aChunk, 9, this.mHeight + 3, 15, CS.NB, 0L);
        WD.set(aChunk, 10, this.mHeight + 3, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 5, this.mHeight + 4, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 4, 15, CS.NB, 0L);
        WD.set(aChunk, 7, this.mHeight + 4, 15, CS.NB, 0L);
        WD.set(aChunk, 8, this.mHeight + 4, 15, CS.NB, 0L);
        WD.set(aChunk, 9, this.mHeight + 4, 15, CS.NB, 0L);
        WD.set(aChunk, 10, this.mHeight + 4, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 5, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 7, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 8, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 9, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 10, this.mHeight + 5, 15, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 2, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 9, this.mHeight + 2, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 3, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 9, this.mHeight + 3, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 4, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 7, this.mHeight + 4, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 8, this.mHeight + 4, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 9, this.mHeight + 4, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 8L);
        WD.set(aChunk, 6, this.mHeight + 1, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 7, this.mHeight + 1, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 8, this.mHeight + 1, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 9, this.mHeight + 1, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 6, this.mHeight + 2, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 9, this.mHeight + 2, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 6, this.mHeight + 3, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 9, this.mHeight + 3, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 6, this.mHeight + 4, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 9, this.mHeight + 4, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 6, this.mHeight + 5, 1, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 7, this.mHeight + 5, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 8, this.mHeight + 5, 1, Blocks.field_150343_Z, 0L);
        WD.set(aChunk, 9, this.mHeight + 5, 1, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 1, this.mHeight + 1, 1, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 1, this.mHeight + 1, 2, Blocks.field_150378_br, 3L);
        WD.set(aChunk, 1, this.mHeight + 1, 3, Blocks.field_150378_br, 3L);
        WD.set(aChunk, 1, this.mHeight + 1, 4, Blocks.field_150378_br, 3L);
        WD.set(aChunk, 1, this.mHeight + 1, 5, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 1, Blocks.field_150378_br, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 2, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 3, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 4, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 5, Blocks.field_150378_br, 2L);
        WD.set(aChunk, 3, this.mHeight + 1, 1, Blocks.field_150378_br, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 2, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 3, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 4, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 5, Blocks.field_150378_br, 2L);
        WD.set(aChunk, 4, this.mHeight + 1, 1, Blocks.field_150378_br, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 2, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 3, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 4, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 5, Blocks.field_150378_br, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 1, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 5, this.mHeight + 1, 2, Blocks.field_150378_br, 1L);
        WD.set(aChunk, 5, this.mHeight + 1, 3, Blocks.field_150378_br, 1L);
        WD.set(aChunk, 5, this.mHeight + 1, 4, Blocks.field_150378_br, 1L);
        WD.set(aChunk, 5, this.mHeight + 1, 5, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 1, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 2, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 3, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 4, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 5, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 1, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 2, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 3, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 4, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 5, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 1, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 2, Blocks.field_150355_j, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 3, Blocks.field_150355_j, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 4, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 5, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 1, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 2, Blocks.field_150355_j, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 3, Blocks.field_150355_j, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 4, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 5, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 1, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 2, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 3, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 4, (Block)Blocks.field_150349_c, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 5, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 11, this.mHeight + 2, 1, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 11, this.mHeight + 2, 2, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 11, this.mHeight + 2, 3, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 11, this.mHeight + 2, 4, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 12, this.mHeight + 2, 1, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 12, this.mHeight + 2, 4, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 13, this.mHeight + 2, 1, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 13, this.mHeight + 2, 4, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 14, this.mHeight + 2, 1, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 14, this.mHeight + 2, 2, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 14, this.mHeight + 2, 3, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 14, this.mHeight + 2, 4, (Block)Blocks.field_150327_N, 0L);
        WD.set(aChunk, 1, this.mHeight + 0, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 0, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 0, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 0, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 0, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 0, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 0, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 0, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 0, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 0, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 0, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 0, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 0, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 0, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 0, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 0, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 0, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 0, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 0, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 0, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 0, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 0, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 0, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 0, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 0, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 1, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 1, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 1, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 1, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 1, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 1, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 2, this.mHeight + 1, 11, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 12, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 13, CS.NB, 0L);
        WD.set(aChunk, 2, this.mHeight + 1, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 1, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 3, this.mHeight + 1, 11, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 12, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 13, CS.NB, 0L);
        WD.set(aChunk, 3, this.mHeight + 1, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 1, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 4, this.mHeight + 1, 11, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 12, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 13, CS.NB, 0L);
        WD.set(aChunk, 4, this.mHeight + 1, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 11, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 12, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 13, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 1, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 2, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 2, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 2, 10, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 5, this.mHeight + 2, 14, Blocks.field_150322_A, 2L);
        WD.set(aChunk, 1, this.mHeight + 3, 10, Blocks.field_150322_A, 1L);
        WD.set(aChunk, 1, this.mHeight + 3, 14, Blocks.field_150322_A, 1L);
        WD.set(aChunk, 5, this.mHeight + 3, 10, Blocks.field_150322_A, 1L);
        WD.set(aChunk, 5, this.mHeight + 3, 14, Blocks.field_150322_A, 1L);
        WD.set(aChunk, 1, this.mHeight + 4, 10, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 1, this.mHeight + 4, 14, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 5, this.mHeight + 4, 10, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 5, this.mHeight + 4, 14, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 10, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 11, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 12, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 13, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 10, this.mHeight + 1, 14, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 14, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 14, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 13, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 12, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 11, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 14, this.mHeight + 1, 10, Blocks.field_150426_aN, 0L);
        WD.set(aChunk, 13, this.mHeight + 1, 10, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 12, this.mHeight + 1, 10, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        WD.set(aChunk, 11, this.mHeight + 1, 10, CS.GENERATE_STREETS ? CS.BlocksGT.CFoam : Blocks.field_150406_ce, 0L);
        aWorld.func_72950_A(0, this.mHeight + 5, 0);
        return true;
    }
}

