/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenGlowtus
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenGlowtus(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_JUNGLE.contains(tName) && !"Fire Swamp".equalsIgnoreCase(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        return WD.anywater((IBlockAccess)aWorld, aX, aY, aZ, aContact) && WD.air(aWorld, aX, aY + 1, aZ) && WD.set(aWorld, aX, aY + 1, aZ, (Block)CS.BlocksGT.Glowtus, (long)aRandom.nextInt(16), 2L);
    }
}

