/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.GT_API_Proxy;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.configurations.IOreDictConfigurationComponent;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityServerTickPost;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityTemperature;
import gregapi.tileentity.data.ITileEntityWeight;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityCrucible;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;

public class MultiTileEntitySmeltery
extends TileEntityBase07Paintable
implements ITileEntityCrucible,
ITileEntityEnergy,
ITileEntityGibbl,
ITileEntityWeight,
ITileEntityTemperature,
ITileEntityMold,
ITileEntityServerTickPost,
IMultiTileEntity.IMTE_RemovedByPlayer,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced {
    public static int GAS_RANGE = 3;
    public static int FLAME_RANGE = 3;
    public static long MAX_AMOUNT = 10378368000L;
    public static long KG_PER_ENERGY = 100L;
    public static double HEAT_RESISTANCE_BONUS = 1.25;
    protected boolean mAcidProof = false;
    protected boolean mMeltDown = false;
    protected byte mDisplayedHeight = 0;
    protected byte oDisplayedHeight = 0;
    protected byte mCooldown = (byte)100;
    protected short mDisplayedFluid = (short)-1;
    protected short oDisplayedFluid = (short)-1;
    protected long mEnergy = 0L;
    protected long mTemperature = 293L;
    protected long oTemperature = 0L;
    protected List<OreDictMaterialStack> mContent = new ArrayListNoNulls<OreDictMaterialStack>();
    private boolean mHasToAddTimer = true;
    private ITexture mTexture;
    private ITexture mTextureMolten;
    public static final List<TagData> ENERGYTYPES;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        if (aNBT.func_74764_b("gt.temperature")) {
            this.mTemperature = aNBT.func_74763_f("gt.temperature");
        }
        if (aNBT.func_74764_b("gt.temperature.old")) {
            this.oTemperature = aNBT.func_74763_f("gt.temperature.old");
        }
        this.mContent = OreDictMaterialStack.loadList("gt.materials", aNBT);
        this.mMeltDown = this.mTemperature + 100L > this.getTemperatureMax((byte)6);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setNumber(aNBT, "gt.temperature", this.mTemperature);
        UT.NBT.setNumber(aNBT, "gt.temperature.old", this.oTemperature);
        OreDictMaterialStack.saveList("gt.materials", aNBT, this.mContent);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.energy.convert.from") + " 1 " + TD.Energy.HU.getLocalisedNameShort() + " " + LH.get("gt.lang.energy.convert.to") + " +1 K " + LH.get("gt.lang.energy.convert.per") + " " + KG_PER_ENERGY + "kg (at least " + this.getEnergySizeInputMin(TD.Energy.HU, (byte)6) + " Units per Tick required!)");
        aList.add(LH.Chat.YELLOW + LH.get("gt.lang.thermal.mass") + this.mMaterial.getWeight(4540536000L) + " kg");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getTemperatureMax((byte)6) + " K)");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.crucible.1"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.fire") + " (" + (FLAME_RANGE + 1) + "m)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.thermometer.to.measure"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.shovel.to.empty"));
    }

    @Override
    public void onUnregisterPost() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_POST.remove(this);
        this.onUnregisterPost();
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_POST.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void onServerTickPost(boolean aFirst) {
        OreDictMaterialStack tMaterial;
        int i;
        ItemStack tStack;
        long tTemperature = WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        long tHash = this.mContent.hashCode();
        if (CS.SERVER_TIME % 600L == 10L && this.field_145850_b.func_72896_J() && this.getRainOffset(0, 1, 0)) {
            BiomeGenBase tBiome = this.getBiome();
            if (tBiome.field_76751_G > 0.0f && (double)tBiome.field_76750_F >= 0.2) {
                this.addMaterialStacks(Arrays.asList(OM.stack(MT.Water, 648648L * (long)Math.max(1.0f, tBiome.field_76751_G * 100.0f) * (long)(this.field_145850_b.func_72911_I() ? 2 : 1))), tTemperature);
            }
        }
        if (!this.slotHas(0)) {
            this.slot(0, WD.suck(this.field_145850_b, (float)this.field_145851_c + CS.PX_P[2], (float)this.field_145848_d + CS.PX_P[2], (float)this.field_145849_e + CS.PX_P[2], CS.PX_N[4], 1.0, CS.PX_N[4]));
        }
        if (ST.valid(tStack = this.slot(0))) {
            ArrayListNoNulls<OreDictMaterialStack> tList;
            OreDictItemData tData = OM.anydata_(tStack);
            if (tData == null) {
                this.slotTrash(0);
                UT.Sounds.send("random.fizz", this, false);
            } else if (tData.mPrefix == null) {
                tList = new ArrayListNoNulls<OreDictMaterialStack>();
                for (OreDictMaterialStack tMaterial2 : tData.getAllMaterialStacks()) {
                    if (tMaterial2.mAmount <= 0L) continue;
                    tList.add(tMaterial2.clone());
                }
                if (this.addMaterialStacks(tList, tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix == OP.oreRaw) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix == OP.blockRaw) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * 9L)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix == OP.crateGtRaw) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * 16L)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix == OP.crateGt64Raw) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * 64L)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix.contains(TD.Prefix.STANDARD_ORE)) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else if (tData.mPrefix.contains(TD.Prefix.DENSE_ORE)) {
                if (this.addMaterialStacks(Arrays.asList(OM.stack(tData.mMaterial.mMaterial.mTargetCrushing.mMaterial, tData.mMaterial.mMaterial.mTargetCrushing.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * 2L)), tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            } else {
                tList = new ArrayListNoNulls();
                for (OreDictMaterialStack tMaterial2 : tData.getAllMaterialStacks()) {
                    if (tMaterial2.mAmount <= 0L) continue;
                    tList.add(tMaterial2.clone());
                }
                if (this.addMaterialStacks(tList, tTemperature)) {
                    this.func_70298_a(0, 1);
                }
            }
        }
        HashSetNoNulls<OreDictMaterial> tAlreadyCheckedAlloys = new HashSetNoNulls<OreDictMaterial>();
        OreDictMaterial tPreferredAlloy = null;
        IOreDictConfigurationComponent tPreferredRecipe = null;
        long tMaxConversions = 0L;
        boolean tNewContent = tHash != (long)this.mContent.hashCode();
        for (OreDictMaterialStack tMaterial3 : this.mContent) {
            if (this.mTemperature < tMaterial3.mMaterial.mMeltingPoint) continue;
            for (OreDictMaterial tAlloy : tMaterial3.mMaterial.mAlloyComponentReferences) {
                if (!tAlreadyCheckedAlloys.add(tAlloy) || this.mTemperature < tAlloy.mMeltingPoint) continue;
                for (IOreDictConfigurationComponent tAlloyRecipe : tAlloy.mAlloyCreationRecipes) {
                    ArrayListNoNulls tNeededStuff = new ArrayListNoNulls();
                    for (OreDictMaterialStack tComponent : tAlloyRecipe.getUndividedComponents()) {
                        tNeededStuff.add(OM.stack(tComponent.mMaterial, Math.max(1L, tComponent.mAmount / 648648000L)));
                    }
                    if (tNeededStuff.isEmpty()) continue;
                    int tNonMolten = 0;
                    boolean tBreak = false;
                    long tConversions = Long.MAX_VALUE;
                    Iterator iterator = tNeededStuff.iterator();
                    while (iterator.hasNext()) {
                        OreDictMaterialStack tComponent = (OreDictMaterialStack)iterator.next();
                        if (this.mTemperature < tComponent.mMaterial.mMeltingPoint) {
                            ++tNonMolten;
                        }
                        tBreak = true;
                        for (OreDictMaterialStack tContent : this.mContent) {
                            if (tContent.mMaterial != tComponent.mMaterial) continue;
                            tConversions = Math.min(tConversions, tContent.mAmount / tComponent.mAmount);
                            tBreak = false;
                            break;
                        }
                        if (!tBreak) continue;
                        break;
                    }
                    if (tBreak || tNonMolten > true || tConversions <= 0L || tPreferredAlloy != null && tPreferredRecipe != null && tConversions * tAlloyRecipe.getCommonDivider() <= tMaxConversions * tPreferredRecipe.getCommonDivider()) continue;
                    tMaxConversions = tConversions;
                    tPreferredRecipe = tAlloyRecipe;
                    tPreferredAlloy = tAlloy;
                }
            }
        }
        if (tPreferredAlloy != null && tPreferredRecipe != null) {
            block12: for (OreDictMaterialStack tComponent : tPreferredRecipe.getUndividedComponents()) {
                for (OreDictMaterialStack tContent : this.mContent) {
                    if (tContent.mMaterial != tComponent.mMaterial) continue;
                    tContent.mAmount -= UT.Code.units_(tMaxConversions, 648648000L, tComponent.mAmount, true);
                    continue block12;
                }
            }
            OM.stack(tPreferredAlloy, tPreferredRecipe.getCommonDivider() * tMaxConversions).addToList(this.mContent);
        }
        ArrayListNoNulls<OreDictMaterialStack> tToBeAdded = new ArrayListNoNulls<OreDictMaterialStack>();
        for (i = 0; i < this.mContent.size(); ++i) {
            tMaterial = this.mContent.get(i);
            if (tMaterial == null || tMaterial.mMaterial == MT.NULL || tMaterial.mMaterial == MT.Air || tMaterial.mAmount <= 0L) {
                this.mContent.remove(i--);
                continue;
            }
            if (tMaterial.mMaterial.mGramPerCubicCentimeter <= 0.0012) {
                CS.GarbageGT.trash(this.mContent.remove(i--));
                UT.Sounds.send("random.fizz", this, false);
                continue;
            }
            if (this.mTemperature >= tMaterial.mMaterial.mBoilingPoint || this.mTemperature > 313L && tMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) && !tMaterial.mMaterial.containsAny(TD.Properties.UNBURNABLE, TD.Processing.MELTING)) {
                CS.GarbageGT.trash(this.mContent.remove(i--));
                UT.Sounds.send("random.fizz", this, false);
                if (tMaterial.mMaterial.mBoilingPoint >= 320L) {
                    try {
                        for (EntityLivingBase tLiving : this.field_145850_b.func_72872_a(EntityLivingBase.class, this.box(-GAS_RANGE, -1.0, -GAS_RANGE, GAS_RANGE + 1, GAS_RANGE + 1, GAS_RANGE + 1))) {
                            UT.Entities.applyTemperatureDamage((Entity)tLiving, tMaterial.mMaterial.mBoilingPoint, 2.0f);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                if (tMaterial.mMaterial.mBoilingPoint >= 2000L) {
                    int k = Math.max(1, UT.Code.bindInt(9L * tMaterial.mAmount / 648648000L));
                    for (int j = 0; j < k; ++j) {
                        WD.fire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.rng(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.rng(3) != 0);
                    }
                }
                if (!tMaterial.mMaterial.contains(TD.Properties.EXPLOSIVE)) continue;
                CS.GarbageGT.trash(this.mContent);
                CS.GarbageGT.trash(tToBeAdded);
                this.explode(UT.Code.scale(tMaterial.mAmount, MAX_AMOUNT, 6L, false));
                return;
            }
            if (!this.mAcidProof && tMaterial.mMaterial.contains(TD.Properties.ACID)) {
                CS.GarbageGT.trash(this.mContent);
                CS.GarbageGT.trash(tToBeAdded);
                UT.Sounds.send("random.fizz", this, false);
                this.setToAir();
                return;
            }
            if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint && (this.oTemperature < tMaterial.mMaterial.mMeltingPoint || tNewContent)) {
                this.mContent.remove(i--);
                OM.stack(tMaterial.mMaterial.mTargetSmelting.mMaterial, UT.Code.units_(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetSmelting.mAmount, false)).addToList(tToBeAdded);
                continue;
            }
            if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint || this.oTemperature < tMaterial.mMaterial.mMeltingPoint && !tNewContent) continue;
            this.mContent.remove(i--);
            OM.stack(tMaterial.mMaterial.mTargetSolidifying.mMaterial, UT.Code.units_(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetSolidifying.mAmount, false)).addToList(tToBeAdded);
        }
        for (i = 0; i < tToBeAdded.size(); ++i) {
            tMaterial = (OreDictMaterialStack)tToBeAdded.get(i);
            if (tMaterial == null || tMaterial.mAmount <= 0L || tMaterial.mMaterial == MT.NULL || tMaterial.mMaterial == MT.Air) continue;
            tMaterial.addToList(this.mContent);
        }
        double tWeight = this.mMaterial.getWeight(4540536000L);
        long tTotal = 0L;
        OreDictMaterialStack tLightest = null;
        for (OreDictMaterialStack tMaterial4 : this.mContent) {
            if (tLightest == null || tMaterial4.mMaterial.mGramPerCubicCentimeter < tLightest.mMaterial.mGramPerCubicCentimeter) {
                tLightest = tMaterial4;
            }
            tWeight += tMaterial4.weight();
            tTotal += tMaterial4.mAmount;
        }
        this.oTemperature = this.mTemperature;
        this.mDisplayedHeight = (byte)UT.Code.scale(tTotal, MAX_AMOUNT, 255L, false);
        this.mDisplayedFluid = (short)(tLightest == null || tLightest.mMaterial.mMeltingPoint > this.mTemperature ? -1 : (int)tLightest.mMaterial.mID);
        long tRequiredEnergy = 1L + (long)(tWeight / (double)KG_PER_ENERGY);
        long tConversions = this.mEnergy / tRequiredEnergy;
        if (this.mCooldown > 0) {
            this.mCooldown = (byte)(this.mCooldown - 1);
        }
        if (tConversions != 0L) {
            this.mEnergy -= tConversions * tRequiredEnergy;
            this.mTemperature += tConversions;
            this.mCooldown = (byte)100;
        }
        if (this.mCooldown <= 0) {
            this.mCooldown = (byte)10;
            if (this.mTemperature > tTemperature) {
                --this.mTemperature;
            }
            if (this.mTemperature < tTemperature) {
                ++this.mTemperature;
            }
        }
        this.mTemperature = Math.max(this.mTemperature, Math.min(200L, tTemperature));
        if (this.mTemperature > this.getTemperatureMax((byte)6)) {
            UT.Sounds.send("random.fizz", this, false);
            CS.GarbageGT.trash(this.mContent);
            if (this.mTemperature >= 320L) {
                try {
                    for (EntityLivingBase tLiving : this.field_145850_b.func_72872_a(EntityLivingBase.class, this.box(-GAS_RANGE, -1.0, -GAS_RANGE, GAS_RANGE + 1, GAS_RANGE + 1, GAS_RANGE + 1))) {
                        UT.Entities.applyTemperatureDamage((Entity)tLiving, this.mTemperature, 2.0f);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
            }
            int k = UT.Code.bindInt(this.mTemperature / 25L);
            for (int j = 0; j < k; ++j) {
                WD.fire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.rng(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.rng(3) != 0);
            }
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 1, 3);
            return;
        }
        if (this.mMeltDown != this.mTemperature + 100L > this.getTemperatureMax((byte)6)) {
            this.mMeltDown = !this.mMeltDown;
            this.updateClientData();
        }
    }

    public boolean addMaterialStacks(List<OreDictMaterialStack> aList, long aTemperature) {
        if (OM.total(this.mContent) + OM.total(aList) <= MAX_AMOUNT) {
            double tWeight2;
            double tWeight1 = OM.weight(this.mContent) + this.mMaterial.getWeight(4540536000L);
            if (tWeight1 + (tWeight2 = OM.weight(aList)) > 0.0) {
                this.mTemperature = aTemperature + (long)(this.mTemperature > aTemperature ? 1 : -1) * UT.Code.units(Math.abs(this.mTemperature - aTemperature), (long)(tWeight1 + tWeight2), (long)tWeight1, false);
            }
            for (OreDictMaterialStack tMaterial : aList) {
                if (this.mTemperature >= tMaterial.mMaterial.mMeltingPoint) {
                    if (aTemperature < tMaterial.mMaterial.mMeltingPoint) {
                        OM.stack(tMaterial.mMaterial.mTargetSmelting.mMaterial, UT.Code.units_(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetSmelting.mAmount, false)).addToList(this.mContent);
                        continue;
                    }
                    tMaterial.addToList(this.mContent);
                    continue;
                }
                if (aTemperature >= tMaterial.mMaterial.mMeltingPoint) {
                    OM.stack(tMaterial.mMaterial.mTargetSolidifying.mMaterial, UT.Code.units_(tMaterial.mAmount, 648648000L, tMaterial.mMaterial.mTargetSolidifying.mAmount, false)).addToList(this.mContent);
                    continue;
                }
                tMaterial.addToList(this.mContent);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getTemperatureValue(byte aSide) {
        return this.mTemperature;
    }

    @Override
    public long getTemperatureMax(byte aSide) {
        return (long)((double)this.mMaterial.mMeltingPoint * HEAT_RESISTANCE_BONUS);
    }

    @Override
    public boolean isMoldInputSide(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public long getMoldMaxTemperature() {
        return this.getTemperatureMax((byte)6);
    }

    @Override
    public long getMoldRequiredMaterialUnits() {
        return 1L;
    }

    @Override
    public long fillMold(OreDictMaterialStack aMaterial, long aTemperature, byte aSide) {
        if (this.isMoldInputSide(aSide)) {
            if (this.addMaterialStacks(Arrays.asList(aMaterial), aTemperature)) {
                return aMaterial.mAmount;
            }
            if (aMaterial.mAmount > 648648000L && this.addMaterialStacks(Arrays.asList(OM.stack(aMaterial.mMaterial, 648648000L)), aTemperature)) {
                return 648648000L;
            }
        }
        return 0L;
    }

    @Override
    public double getWeightValue(byte aSide) {
        return OM.weight(this.mContent);
    }

    @Override
    public boolean removedByPlayer(World aWorld, EntityPlayer aPlayer, boolean aWillHarvest) {
        if (this.mTemperature >= 1300L && this.isServerSide() && !UT.Entities.isCreative(aPlayer)) {
            UT.Sounds.send("random.fizz", this, false);
            CS.GarbageGT.trash(this.mContent);
            try {
                for (EntityLivingBase tLiving : this.field_145850_b.func_72872_a(EntityLivingBase.class, this.box(-GAS_RANGE, -1.0, -GAS_RANGE, GAS_RANGE + 1, GAS_RANGE + 1, GAS_RANGE + 1))) {
                    UT.Entities.applyTemperatureDamage((Entity)tLiving, this.mTemperature);
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
            int k = UT.Code.bindInt(this.mTemperature / 25L);
            for (int j = 0; j < k; ++j) {
                WD.fire(this.field_145850_b, this.field_145851_c - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.field_145848_d - 1 + this.rng(2 + FLAME_RANGE), this.field_145849_e - FLAME_RANGE + this.rng(2 * FLAME_RANGE + 1), this.rng(3) != 0);
            }
            return this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k, 1, 3);
        }
        return this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean breakBlock() {
        CS.GarbageGT.trash(this.mContent);
        return super.breakBlock();
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (CS.SIDES_TOP[aSide]) {
            if (this.isServerSide() && aPlayer != null) {
                ItemStack aStack = aPlayer.func_71045_bC();
                OreDictMaterialStack tLightest = null;
                for (OreDictMaterialStack tMaterial : this.mContent) {
                    if (tLightest != null && !(tMaterial.mMaterial.mGramPerCubicCentimeter < tLightest.mMaterial.mGramPerCubicCentimeter)) continue;
                    tLightest = tMaterial;
                }
                if (this.slotHas(0)) {
                    if (aStack == null) {
                        aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, this.slotTake(0));
                        UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f, 5.0f);
                        return true;
                    }
                } else if (tLightest != null && this.mTemperature < tLightest.mMaterial.mMeltingPoint) {
                    ItemStack tOutputStack = OP.scrapGt.mat(tLightest.mMaterial, 1L);
                    if (tOutputStack == null || tLightest.mAmount < OP.scrapGt.mAmount) {
                        tLightest.mAmount = 0L;
                        UT.Entities.exhaust(aPlayer);
                        UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f, 5.0f);
                        return true;
                    }
                    if (aStack == null) {
                        aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, tOutputStack);
                        tLightest.mAmount -= OP.scrapGt.mAmount;
                        UT.Entities.exhaust(aPlayer);
                        UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f, 5.0f);
                        return true;
                    }
                    if (ST.equal(aStack, tOutputStack) && aStack.field_77994_a < aStack.func_77976_d()) {
                        ++aStack.field_77994_a;
                        tLightest.mAmount -= OP.scrapGt.mAmount;
                        UT.Entities.exhaust(aPlayer);
                        UT.Entities.applyTemperatureDamage((Entity)aPlayer, this.mTemperature, 1.0f, 5.0f);
                        return true;
                    }
                }
                if (aStack != null) {
                    FluidStack tFluid = FL.getFluid(ST.amount(1L, aStack), true);
                    if (tFluid == null) {
                        if (tLightest != null && tLightest.mMaterial.mLiquid != null) {
                            long tTemperature = FL.temperature(tLightest.mMaterial.mLiquid);
                            if (this.mTemperature >= tLightest.mMaterial.mMeltingPoint && (tTemperature < 320L || this.mTemperature >= tTemperature) && FL.nonzero(tFluid = tLightest.mMaterial.liquid(tLightest.mAmount, false))) {
                                int tAmount = tFluid.amount;
                                ItemStack tStack = FL.fill(tFluid, ST.amount(1L, aStack), true, true, true, true);
                                if (ST.valid(tStack)) {
                                    tLightest.mAmount -= UT.Code.units(tAmount - tFluid.amount, tLightest.mMaterial.mLiquid.amount, tLightest.mMaterial.mLiquidUnit, true);
                                    --aStack.field_77994_a;
                                    ST.give((Entity)aPlayer, tStack, true);
                                    return true;
                                }
                            }
                        }
                    } else if (!FL.gas(tFluid, true) && !FL.acid(tFluid)) {
                        ItemStack tStack = ST.container(ST.amount(1L, aStack), true);
                        OreDictMaterialStack tFluidData = OreDictMaterial.FLUID_MAP.get(tFluid.getFluid().getName());
                        if (tFluidData != null) {
                            if (FL.equal(tFluidData.mMaterial.mLiquid, tFluid)) {
                                if (this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(tFluidData.mMaterial, UT.Code.units(tFluid.amount, tFluidData.mMaterial.mLiquid.amount, tFluidData.mMaterial.mLiquidUnit, false))), UT.Code.bind(FL.temperature(tFluid), tFluidData.mMaterial.mMeltingPoint + 25L, tFluidData.mMaterial.mBoilingPoint - 1L))) {
                                    --aStack.field_77994_a;
                                    ST.give((Entity)aPlayer, tStack, true);
                                    return true;
                                }
                            } else if (this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(tFluidData.mMaterial, UT.Code.units(tFluid.amount, tFluidData.mAmount, 648648000L, false))), UT.Code.bind(FL.temperature(tFluid), tFluidData.mMaterial.mMeltingPoint + 25L, tFluidData.mMaterial.mBoilingPoint - 1L))) {
                                --aStack.field_77994_a;
                                ST.give((Entity)aPlayer, tStack, true);
                                return true;
                            }
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean fillMoldAtSide(ITileEntityMold aMold, byte aSide, byte aSideOfMold) {
        for (OreDictMaterialStack tContent : this.mContent) {
            long tAmount;
            if (tContent == null || this.mTemperature < tContent.mMaterial.mMeltingPoint || tContent.mMaterial.mTargetSmelting.mMaterial != tContent.mMaterial || (tAmount = aMold.fillMold(tContent, this.mTemperature, aSideOfMold)) <= 0L) continue;
            tContent.mAmount -= tAmount;
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + (this.mTemperature >= 1300L ? "K (too hot to pick it up right now!)" : "K"));
            }
            return 10000L;
        }
        if (aTool.equals("shovel") && CS.SIDES_TOP[aSide] && aPlayer instanceof EntityPlayer) {
            OreDictMaterialStack tLightest = null;
            for (OreDictMaterialStack tMaterial : this.mContent) {
                if (tLightest != null && !(tMaterial.mMaterial.mGramPerCubicCentimeter < tLightest.mMaterial.mGramPerCubicCentimeter)) continue;
                tLightest = tMaterial;
            }
            if (tLightest != null && this.mTemperature < tLightest.mMaterial.mMeltingPoint) {
                if (tLightest.mAmount < OP.scrapGt.mAmount) {
                    tLightest.mAmount = 0L;
                    UT.Entities.exhaust(aPlayer);
                    return 500L;
                }
                ItemStack tOutputStack = OP.scrapGt.mat(tLightest.mMaterial, (long)UT.Code.bindStack(tLightest.mAmount / OP.scrapGt.mAmount));
                if (tOutputStack == null) {
                    tLightest.mAmount = 0L;
                    UT.Entities.exhaust(aPlayer);
                    return 500L;
                }
                if (ST.add(aPlayer, tOutputStack)) {
                    UT.Entities.exhaust(aPlayer, 0.1f * (float)tOutputStack.field_77994_a);
                    tLightest.mAmount -= OP.scrapGt.mAmount * (long)tOutputStack.field_77994_a;
                    return 1000 * tOutputStack.field_77994_a;
                }
                return 0L;
            }
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mTemperature = WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplayedHeight != this.oDisplayedHeight || this.mDisplayedFluid != this.oDisplayedFluid;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedFluid = this.mDisplayedFluid;
        this.oDisplayedHeight = this.mDisplayedHeight;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, this.mDisplayedHeight, UT.Code.toByteS(this.mDisplayedFluid, 0), UT.Code.toByteS(this.mDisplayedFluid, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), (byte)(this.mMeltDown ? 1 : 0));
        }
        if (this.mDisplayedFluid != this.oDisplayedFluid) {
            return this.getClientDataPacketByteArray(false, this.mDisplayedHeight, UT.Code.toByteS(this.mDisplayedFluid, 0), UT.Code.toByteS(this.mDisplayedFluid, 1));
        }
        return this.getClientDataPacketByteArray(false, this.mDisplayedHeight);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedHeight = aData[0];
        if (aData.length >= 3) {
            this.mDisplayedFluid = UT.Code.combine(aData[1], aData[2]);
        }
        if (aData.length >= 6) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4]), UT.Code.unsignB(aData[5])});
        }
        if (aData.length >= 7) {
            this.mMeltDown = aData[6] != 0;
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        short[] tRGBaArray = UT.Code.getRGBaArray(this.mRGBa);
        boolean tGlow = false;
        if (this.mMeltDown) {
            tRGBaArray[0] = UT.Code.bind8(tRGBaArray[0] * 2 + 50);
            tRGBaArray[1] = UT.Code.bind8(tRGBaArray[1] * 2 + 50);
            tRGBaArray[2] = UT.Code.bind8(tRGBaArray[2] / 2 + 50);
            tGlow = true;
        } else {
            tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
        }
        this.mTexture = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, tRGBaArray, tGlow);
        this.mTextureMolten = UT.Code.exists(this.mDisplayedFluid, OreDictMaterial.MATERIAL_ARRAY) ? OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedFluid].getTextureMolten() : BlockTextureDefault.get(MT.NULL, OP.blockRaw, CS.CA_GRAY_64, false);
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[14]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], 0.125f + (float)UT.Code.unsignB(this.mDisplayedHeight) / 292.57144f, CS.PX_N[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: 
            case 2: {
                return CS.SIDES_AXIS_Z[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 1: 
            case 3: {
                return CS.SIDES_AXIS_X[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 4: {
                return CS.SIDES_VERTICAL[aSide] ? this.mTexture : null;
            }
            case 5: {
                return this.mDisplayedHeight != 0 && CS.SIDES_TOP[aSide] ? this.mTextureMolten : null;
            }
        }
        return this.mTexture;
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (UT.Entities.applyTemperatureDamage(aEntity, this.mTemperature, 1.0f, 10.0f) && this.mTemperature > 320L && aEntity instanceof EntityLivingBase && !((EntityLivingBase)aEntity).func_70089_S()) {
            if (aEntity instanceof EntityVillager || aEntity instanceof EntityWitch) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1297296000L, MT.SoylentGreen)), 310L);
            } else if (aEntity instanceof EntitySnowman) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(2594592000L, MT.Snow)), 263L);
            } else if (aEntity instanceof EntityIronGolem) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(2594592000L, MT.Fe)), WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntitySkeleton) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, ((EntitySkeleton)aEntity).func_82202_m() == 1 ? MT.BoneWither : MT.Bone), ((EntitySkeleton)aEntity).func_82202_m() == 1 ? OM.stack(648648000L, MT.Coal) : null), WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntityZombie) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, MT.MeatRotten)), WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            } else if (aEntity instanceof EntityMooshroom || aEntity instanceof EntityCow || aEntity instanceof EntityHorse) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1945944000L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityPig || aEntity instanceof EntitySheep || aEntity instanceof EntityWolf || aEntity instanceof EntitySquid) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(1297296000L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityChicken || aEntity instanceof EntityOcelot || aEntity instanceof EntitySpider || aEntity instanceof EntitySilverfish) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, MT.MeatRaw)), 310L);
            } else if (aEntity instanceof EntityCreeper) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, MT.Gunpowder)), 293L);
            } else if (aEntity instanceof EntityEnderman) {
                this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, MT.EnderPearl)), 293L);
            } else if (aEntity instanceof EntityPlayer && "GregoriusT".equalsIgnoreCase(aEntity.func_70005_c_())) {
                for (int i = 0; i < 16; ++i) {
                    this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(648648000L, MT.Tc)), 293L);
                }
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(aAABB, aList, CS.PX_P[14], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[14], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[14], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[14]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[14], CS.PX_N[1]);
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide] && super.checkObstruction(aPlayer, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return !CS.SIDES_TOP[aSide];
    }

    @Override
    public long getGibblValue(byte aSide) {
        return UT.Code.divup(OM.total(this.mContent) * 1000L, 0x44BBB40L);
    }

    @Override
    public long getGibblMax(byte aSide) {
        return UT.Code.divup(MAX_AMOUNT * 1000L, 0x44BBB40L);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(1);
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return CS.SIDES_TOP[aSide] && !this.slotHas(0);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && ENERGYTYPES.contains(aEnergyType);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return ENERGYTYPES.contains(aEnergyType);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return ENERGYTYPES.contains(aEnergyType);
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aDoInject) {
            if (aEnergyType == TD.Energy.KU) {
                if (aSize * aAmount > 0L && WD.oxygen(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                    this.addMaterialStacks(new ArrayListNoNulls<OreDictMaterialStack>(false, OM.stack(Math.min(MAX_AMOUNT - OM.total(this.mContent), aSize * aAmount * 648648L), MT.Air)), this.mTemperature);
                }
            } else {
                this.mEnergy = aEnergyType == TD.Energy.CU ? (this.mEnergy -= Math.abs(aAmount * aSize)) : (this.mEnergy += Math.abs(aAmount * aSize));
            }
        }
        return aAmount;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return Long.MAX_VALUE - this.mEnergy;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 1L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 2048L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return ENERGYTYPES;
    }

    @Override
    public float getBlockHardness() {
        return this.mDisplayedHeight != 0 ? super.getBlockHardness() * 100.0f : super.getBlockHardness();
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.smeltery";
    }

    static {
        LH.add("gt.tooltip.crucible.1", "KU Input will turn into Air for Steelmaking");
        ENERGYTYPES = new ArrayListNoNulls<TagData>(false, TD.Energy.KU, TD.Energy.HU, TD.Energy.CU, TD.Energy.VIS_IGNIS);
    }
}

