/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.tool.BlockLongDistPipe;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class MultiTileEntityLongDistancePipelineItem
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData,
ITileEntityCanDelegate,
ITileEntityMachineBlockUpdateable,
ITileEntitySwitchableOnOff {
    protected boolean mStopped = false;
    protected MultiTileEntityLongDistancePipelineItem mTarget = null;
    protected MultiTileEntityLongDistancePipelineItem mSender = null;
    protected ChunkCoordinates mTargetPos = null;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/pipelines/item/colored/front"), new Textures.BlockIcons.CustomIcon("machines/pipelines/item/colored/back"), new Textures.BlockIcons.CustomIcon("machines/pipelines/item/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/pipelines/item/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/pipelines/item/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/pipelines/item/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(UT.Code.bindInt(aNBT.func_74763_f("gt.target.x")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.y")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.z")));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mTargetPos != null && this.mTarget != this) {
            UT.NBT.setBoolean(aNBT, "gt.target", true);
            UT.NBT.setNumber(aNBT, "gt.target.x", this.mTargetPos.field_71574_a);
            UT.NBT.setNumber(aNBT, "gt.target.y", this.mTargetPos.field_71572_b);
            UT.NBT.setNumber(aNBT, "gt.target.z", this.mTargetPos.field_71573_c);
        }
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            this.scanPipes();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
                    aChatReturn.add("Is the Target");
                    aChatReturn.add("Sender is at: X: " + this.mSender.field_145851_c + " Y: " + this.mSender.field_145848_d + " Z: " + this.mSender.field_145849_e);
                } else {
                    aChatReturn.add(this.checkTarget() ? "Has Target" : "Has no loaded Target");
                    if (this.mTargetPos != null) {
                        aChatReturn.add("Target should be around: X: " + this.mTargetPos.field_71574_a + " Y: " + this.mTargetPos.field_71572_b + " Z: " + this.mTargetPos.field_71573_c);
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    public boolean checkTarget() {
        if (this.mStopped || this.isClientSide()) {
            return false;
        }
        if (this.mTargetPos == null) {
            this.scanPipes();
        } else if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
                TileEntity tTileEntity = WD.te(this.field_145850_b, this.mTargetPos, true);
                if (tTileEntity instanceof MultiTileEntityLongDistancePipelineItem) {
                    this.mTarget = (MultiTileEntityLongDistancePipelineItem)tTileEntity;
                } else if (tTileEntity != null) {
                    this.mTargetPos = null;
                }
            }
        }
        if (this.mTarget == null || this.mTarget == this) {
            return false;
        }
        if (this.mTarget.mSender == null || this.mTarget.mSender.isDead() || this.mTarget.mSender.mTarget == null || this.mTarget.mSender.mTarget.isDead()) {
            this.mTarget.mSender = this;
        }
        return this.mTarget.mSender == this;
    }

    private void scanPipes() {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            return;
        }
        this.mIgnoreUnloadedChunks = false;
        this.mTargetPos = this.getCoords();
        this.mTarget = this;
        this.mSender = null;
        Block aBlock = this.getBlockAtSide(CS.OPOS[this.mFacing]);
        byte aMetaData = this.getMetaDataAtSide(CS.OPOS[this.mFacing]);
        if (aBlock instanceof BlockLongDistPipe) {
            if (((BlockLongDistPipe)aBlock).mTemperatures[aMetaData] >= 0L) {
                return;
            }
            HashSetNoNulls<ChunkCoordinates> tNewChecks = new HashSetNoNulls<ChunkCoordinates>();
            HashSetNoNulls<ChunkCoordinates> tOldChecks = new HashSetNoNulls<ChunkCoordinates>(false, this.getCoords());
            HashSetNoNulls<ChunkCoordinates> tToCheck = new HashSetNoNulls<ChunkCoordinates>(false, this.getOffsetN(this.mFacing, 1));
            HashSetNoNulls<ChunkCoordinates> tWires = new HashSetNoNulls<ChunkCoordinates>();
            while (!tToCheck.isEmpty()) {
                for (ChunkCoordinates aCoords : tToCheck) {
                    if (this.getBlock(aCoords) == aBlock && this.getMetaData(aCoords) == aMetaData) {
                        tWires.add(aCoords);
                        ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c);
                        if (tOldChecks.add(tCoords)) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1))) {
                            tNewChecks.add(tCoords);
                        }
                        if (!tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1))) continue;
                        tNewChecks.add(tCoords);
                        continue;
                    }
                    TileEntity tTileEntity = this.getTileEntity(aCoords);
                    if (tTileEntity == this || !(tTileEntity instanceof MultiTileEntityLongDistancePipelineItem)) continue;
                    if (tWires.contains(((MultiTileEntityLongDistancePipelineItem)tTileEntity).getOffset(((MultiTileEntityLongDistancePipelineItem)tTileEntity).mFacing, 1))) {
                        this.mTarget = (MultiTileEntityLongDistancePipelineItem)tTileEntity;
                        this.mTargetPos = this.mTarget.getCoords();
                        this.mIgnoreUnloadedChunks = true;
                        return;
                    }
                    tOldChecks.remove(aCoords);
                }
                tToCheck.clear();
                tToCheck.addAll(tNewChecks);
                tNewChecks.clear();
            }
        }
        this.mIgnoreUnloadedChunks = true;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        this.mTargetPos = null;
        this.mSender = null;
    }

    @Override
    public void onMachineBlockUpdate(ChunkCoordinates aCoords, Block aBlock, byte aMeta, boolean aRemoved) {
        if (aBlock instanceof BlockLongDistPipe) {
            this.mTargetPos = null;
            this.mSender = null;
        }
    }

    @Override
    public boolean hasMultiBlockMachineRelevantData() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isExtender(byte aSide) {
        return false;
    }

    @Override
    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70298_a(aSlot, aDecrement);
            }
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int aSlot) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70304_b(aSlot);
            }
        }
        return null;
    }

    @Override
    public ItemStack func_70301_a(int aSlot) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70301_a(aSlot);
            }
        }
        return null;
    }

    @Override
    public String func_145825_b() {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145825_b();
            }
        }
        return super.func_145825_b();
    }

    @Override
    public int func_70302_i_() {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70302_i_();
            }
        }
        return 0;
    }

    @Override
    public int func_70297_j_() {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70297_j_();
            }
        }
        return 0;
    }

    @Override
    public void func_70299_a(int aSlot, ItemStack aStack) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                ((IInventory)tTileEntity.mTileEntity).func_70299_a(aSlot, aStack);
            }
        }
    }

    @Override
    public boolean func_145818_k_() {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145818_k_();
            }
        }
        return this.getCustomName() != null;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_94128_d((int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return UT.Code.getAscendingArray(((IInventory)tTileEntity.mTileEntity).func_70302_i_());
            }
        }
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (this.checkTarget()) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPOS[this.mTarget.mFacing]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.pipelines.item";
    }
}

