/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityLocker
extends TileEntityBase09FacingSingle
implements ITileEntityRunningSuccessfully {
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lockers/normal/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/colored/top"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/colored/front"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/colored/back"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lockers/normal/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/lockers/normal/overlay/side")};

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.mInventoryChanged) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
            }
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        if (UT.Entities.isPlayer(aPlayer) && this.isServerSide()) {
            boolean temp = false;
            for (int i = 0; i < 4; ++i) {
                ItemStack tStack = this.slot(i);
                if (tStack != null && !tStack.func_77973_b().isValidArmor(tStack, 3 - i, (Entity)aPlayer) || IL.BTRS_Backpack.equal(aPlayer.field_71071_by.field_70460_b[i], true, true) || IL.BTRS_Thaumpack.equal(aPlayer.field_71071_by.field_70460_b[i], true, true)) continue;
                this.slot(i, aPlayer.field_71071_by.field_70460_b[i]);
                aPlayer.field_71071_by.field_70460_b[i] = tStack;
                temp = true;
            }
            if (temp) {
                ST.update((Entity)aPlayer);
                this.updateInventory();
                UT.Sounds.send("random.click", (Entity)aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[4];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return UT.Code.getAscendingArray(this.invsize());
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (ST.valid(aStack)) {
            try {
                return aStack.func_77973_b().isValidArmor(aStack, 3 - aSlot, null);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningPossible() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningActively() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        byte aIndex = aSide < 2 ? aSide : (aSide == this.mFacing ? (byte)2 : (aSide == CS.OPOS[this.mFacing] ? (byte)3 : 4));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.locker.normal";
    }
}

