/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.reactors;

import gregapi.GT_API_Proxy;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.fluid.FluidTankGT;
import gregapi.item.IItemReactorRod;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityServerTickPost;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase10FacingDouble;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileEntityReactorCore
extends TileEntityBase10FacingDouble
implements ITileEntityServerTickPost,
IFluidHandler,
ITileEntityTapAccessible,
ITileEntityFunnelAccessible,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    public int[] mNeutronCounts = new int[]{0, 0, 0, 0};
    public int[] oNeutronCounts = new int[]{0, 0, 0, 0};
    public long mEnergy = 0L;
    public long oEnergy = 0L;
    public byte mMode = 0;
    public boolean mRunning = false;
    public boolean mStopped = false;
    public FluidTankGT[] mTanks;
    private boolean mHasToAddTimer;
    public static final int[] S2103;
    public static final int[] S0312;
    protected byte oVisual;

    public MultiTileEntityReactorCore() {
        this.mTanks = new FluidTankGT[]{new FluidTankGT(64000L), new FluidTankGT(64000L).setCapacity(FL.Steam.mName, 64000L * (long)CS.STEAM_PER_WATER)};
        this.mHasToAddTimer = true;
        this.oVisual = 0;
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mMode = aNBT.func_74771_c("gt.mode");
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        this.mRunning = aNBT.func_74767_n("gt.active");
        this.mStopped = aNBT.func_74767_n("gt.stopped");
        this.mTanks[0].readFromNBT(aNBT, "gt.tank.0");
        this.mTanks[1].readFromNBT(aNBT, "gt.tank.1");
        for (int i = 0; i < 4; ++i) {
            this.mNeutronCounts[i] = aNBT.func_74762_e("gt.value.m." + i);
            this.oNeutronCounts[i] = aNBT.func_74762_e("gt.value.o." + i);
        }
        if (this.field_145850_b != null && this.isServerSide() && this.mHasToAddTimer) {
            GT_API_Proxy.SERVER_TICK_POST.add(this);
            GT_API_Proxy.SERVER_TICK_PO2T.add(this);
            this.mHasToAddTimer = false;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mRunning);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        this.mTanks[0].writeToNBT(aNBT, "gt.tank.0");
        this.mTanks[1].writeToNBT(aNBT, "gt.tank.1");
        for (int i = 0; i < 4; ++i) {
            UT.NBT.setNumber(aNBT, "gt.value.m." + i, this.mNeutronCounts[i]);
            UT.NBT.setNumber(aNBT, "gt.value.o." + i, this.oNeutronCounts[i]);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.reactorcore.1"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.reactorcore.2"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.reactorcore.3"));
        aList.add(LH.Chat.CYAN + LH.get("gt.tooltip.reactorcore.4"));
        aList.add(LH.Chat.GREEN + LH.get("gt.tooltip.reactorcore.5"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.pincers.to.take"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.geigercoutner.to.measure"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.thermometer.to.measure"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onUnregisterPost() {
        this.mHasToAddTimer = true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mHasToAddTimer) {
                GT_API_Proxy.SERVER_TICK_POST.add(this);
                GT_API_Proxy.SERVER_TICK_PO2T.add(this);
                this.mHasToAddTimer = false;
            }
            if (this.mTanks[0].overHalf() && this.mSecondFacing != this.mFacing) {
                FL.move(this.mTanks[0], this.getAdjacentTank(this.mSecondFacing), this.mTanks[0].amount() - this.mTanks[0].capacity() / 2L);
            }
            if (this.mTanks[1].has()) {
                FL.move(this.mTanks[1], this.getAdjacentTank(this.mFacing));
            }
            if (this.mTanks[0].check()) {
                this.updateClientData();
            }
        }
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        GT_API_Proxy.SERVER_TICK_POST.remove(this);
        GT_API_Proxy.SERVER_TICK_PO2T.remove(this);
        this.onUnregisterPost();
    }

    public boolean isReactorRodModerated(int aSlot) {
        return false;
    }

    public void updateReactorRodModeration(int aSlot) {
    }

    public int getReactorRodNeutronEmission(int aSlot) {
        return 0;
    }

    public boolean getReactorRodNeutronReaction(int aSlot) {
        return false;
    }

    public int getReactorRodNeutronReflection(int aSlot, int aNeutrons, boolean aModerated) {
        return 0;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            boolean bl = this.mStopped = !this.mStopped;
            if (aChatReturn != null) {
                aChatReturn.add(this.mStopped ? "Reactor Block is OFF" : "Reactor Block is ON");
            }
            return 10000L;
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Heat Levels: " + (this.oEnergy <= 0L ? "None" : this.oEnergy + " HU"));
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("Input: " + this.mTanks[0].content());
                aChatReturn.add("Output: " + this.mTanks[1].content());
                aChatReturn.add(this.mStopped ? "Reactor Block is OFF" : "Reactor Block is ON");
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack;
        if (this.isServerSide() && CS.SIDES_TOP[aSide] && ST.item(aStack = aPlayer.func_71045_bC()) instanceof IItemReactorRod && ((IItemReactorRod)ST.item_(aStack)).isReactorRod(aStack)) {
            int tSlot;
            int n = (double)aHitX < 0.5 ? ((double)aHitZ < 0.5 ? 0 : 1) : (tSlot = (double)aHitZ < 0.5 ? 2 : 3);
            if (!this.slotHas(tSlot) && ST.use((Entity)aPlayer, aStack)) {
                this.slot(tSlot, ST.amount(1L, aStack));
                this.mStopped = true;
                UT.Sounds.send("random.click", this, false);
                this.updateClientData();
            }
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.oVisual != this.getVisualData() || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oVisual = this.getVisualData();
    }

    @Override
    public void setVisualData(byte aData) {
        this.mStopped = (aData & 0x20) != 0;
        this.mRunning = (aData & 0x10) != 0;
        this.mMode = (byte)(aData & 0xF);
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mStopped ? (this.mRunning ? this.mMode | 0x30 : this.mMode | 0x20) : (this.mRunning ? this.mMode | 0x10 : this.mMode));
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public byte getDefaultSecondSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public void updateTanks() {
    }

    @Override
    public void updateInventory() {
        super.updateInventory();
        this.updateClientData();
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return FL.Coolant_IC2.is(aFluidToFill) || FL.distw(aFluidToFill) || FL.Thorium_Salt.is(aFluidToFill) || MT.Sn.mLiquid.isFluidEqual(aFluidToFill) || MT.Na.mLiquid.isFluidEqual(aFluidToFill) || MT.HDO.mLiquid.isFluidEqual(aFluidToFill) || MT.D2O.mLiquid.isFluidEqual(aFluidToFill) || MT.T2O.mLiquid.isFluidEqual(aFluidToFill) || MT.LiCl.mLiquid.isFluidEqual(aFluidToFill) || MT.He.mGas.isFluidEqual(aFluidToFill) || MT.CO2.mGas.isFluidEqual(aFluidToFill) ? this.mTanks[0] : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTanks[1];
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        if (!(FL.Coolant_IC2.is(aFluid) || FL.distw(aFluid) || FL.Thorium_Salt.is(aFluid) || MT.Sn.mLiquid.isFluidEqual(aFluid) || MT.Na.mLiquid.isFluidEqual(aFluid) || MT.HDO.mLiquid.isFluidEqual(aFluid) || MT.D2O.mLiquid.isFluidEqual(aFluid) || MT.T2O.mLiquid.isFluidEqual(aFluid) || MT.LiCl.mLiquid.isFluidEqual(aFluid) || MT.He.mGas.isFluidEqual(aFluid) || MT.CO2.mGas.isFluidEqual(aFluid))) {
            return 0;
        }
        return this.mTanks[0].fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        return this.mTanks[this.mTanks[1].has() ? 1 : 0].drain(aMaxDrain, aDoDrain);
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mRunning) {
            UT.Entities.applyHeatDamage(aEntity, 5.0f);
            UT.Entities.applyRadioactivity(aEntity, 3, 1);
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_VERTICAL[aSide];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mRunning;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mRunning;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mRunning;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    public byte getStateMode() {
        return this.mMode;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.generator.reactor.core";
    }

    static {
        LH.add("gt.tooltip.reactorcore.1", "Reactor Slots can be accessed from the Top and Bottom Side.");
        LH.add("gt.tooltip.reactorcore.2", "Accessing a reactor slot is only possible when the slot or the reactor is off.");
        LH.add("gt.tooltip.reactorcore.3", "Primary Facing Emits Hot Coolant.");
        LH.add("gt.tooltip.reactorcore.4", "Secondary Facing Emits Cold Coolant when over half full.");
        LH.add("gt.tooltip.reactorcore.5", "Choice of Coolant can have special Effects.");
        S2103 = new int[]{0, 0, 2, 1, 0, 3, 0};
        S0312 = new int[]{0, 0, 0, 3, 1, 2, 0};
    }
}

