/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.autotools;

import gregapi.block.IBlockToolable;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityAnvil;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.items.tools.early.GT_Tool_HardHammer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityAutoToolHammer
extends TileEntityBase09FacingSingle
implements ITileEntityEnergy {
    protected boolean mPullingBack = false;
    protected byte mQuality = (byte)2;
    protected byte mSendSound = 0;
    protected long mEnergy = 0L;
    protected long mInput = 32L;
    protected TagData mEnergyTypeAccepted = TD.Energy.KU;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/colored/front"), new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/colored/back"), new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/autotools/hammer/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.state")) {
            this.mPullingBack = aNBT.func_74767_n("gt.state");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.quality")) {
            this.mQuality = aNBT.func_74771_c("gt.quality");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.state", this.mPullingBack);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.autohammer"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.quality") + ": " + LH.Chat.WHITE + this.mQuality);
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, LH.get("gt.lang.face.back"), null);
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mPullingBack && this.mEnergy > 0L) {
                byte tMetaData;
                Block tBlock;
                DelegatorTileEntity<TileEntity> tD = this.getAdjacentTileEntity(this.mFacing);
                if (IBlockToolable.Util.onToolClick("hammer", this.mEnergy * 10L, (long)this.mQuality, null, null, null, false, null, tD.mWorld, tD.mSideOfTileEntity, tD.mX, tD.mY, tD.mZ, 0.5f, 0.5f, 0.5f) > 0L) {
                    this.mSendSound = 1;
                } else if (!(tD.mTileEntity instanceof ITileEntityAnvil && ((ITileEntityAnvil)tD.mTileEntity).isAnvil(tD.mSideOfTileEntity) || !GT_Tool_HardHammer.INSTANCE.isMinableBlock(tBlock = tD.mWorld.func_147439_a(tD.mX, tD.mY, tD.mZ), tMetaData = (byte)tD.mWorld.func_72805_g(tD.mX, tD.mY, tD.mZ)))) {
                    float tHardness;
                    this.mSendSound = (byte)2;
                    if (tBlock.getHarvestLevel((int)tMetaData) <= this.mQuality && (tHardness = tBlock.func_149712_f(tD.mWorld, tD.mX, tD.mY, tD.mZ)) >= 0.0f && tHardness * 50.0f <= (float)this.mEnergy) {
                        ArrayList tDrops = tBlock.getDrops(tD.mWorld, tD.mX, tD.mY, tD.mZ, (int)tMetaData, 0);
                        GT_Tool_HardHammer.INSTANCE.convertBlockDrops(tDrops, null, null, tBlock, Long.MAX_VALUE, tD.mX, tD.mY, tD.mZ, tMetaData, 0, false, null);
                        tD.mWorld.func_147480_a(tD.mX, tD.mY, tD.mZ, false);
                        for (ItemStack tStack : tDrops) {
                            ST.drop(tD.mWorld, (double)tD.mX + 0.5, (double)tD.mY + 0.5, (double)tD.mZ + 0.5, tStack);
                        }
                        this.mSendSound = 1;
                    }
                }
                this.mEnergy = 0L;
            }
        } else if (this.mSendSound != 0) {
            UT.Sounds.play(this.mSendSound == 1 ? "random.anvil_use" : "random.anvil_break", 20, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.mSendSound = 0;
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mSendSound != 0 || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.mSendSound = 0;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mSendSound = aData;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (aSize > 0L) {
            if (aDoInject) {
                this.mPullingBack = false;
                this.mEnergy += aSize * aAmount;
                if (aSize > this.getEnergySizeInputMax(aEnergyType, aSide)) {
                    this.explode(UT.Code.tierMax(aSize));
                }
            }
        } else if (aDoInject) {
            this.mPullingBack = true;
        }
        return aAmount;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public byte getVisualData() {
        return this.mSendSound;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == CS.OPOS[this.mFacing] && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.mInput / 8L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.autotool.hammer";
    }
}

