/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;

public class BlockOcean
extends BlockWaterlike {
    public static boolean PLACEMENT_ALLOWED = false;
    public static boolean FLOWS_OUT = true;
    public static boolean SPREAD_TO_AIR = false;
    public static boolean UPDATE_TICK = true;

    public BlockOcean(String aName, Fluid aFluid) {
        super(aName, aFluid, FLOWS_OUT, true);
        this.tickRate = 20;
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        if (PLACEMENT_ALLOWED) {
            if (UPDATE_TICK) {
                aWorld.func_147464_a(aX, aY, aZ, (Block)this, 10 + CS.RNGSUS.nextInt(90));
            }
        } else {
            aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (aBlock == Blocks.field_150346_d && aWorld.func_147439_a(aX, aY - 1, aZ) == Blocks.field_150349_c) {
            aWorld.func_147465_d(aX, aY - 1, aZ, Blocks.field_150346_d, 1, 2);
        }
        super.func_149695_a(aWorld, aX, aY, aZ, aBlock);
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        Block tBlock;
        UPDATE_TICK = true;
        PLACEMENT_ALLOWED = true;
        if (aWorld.func_72873_a(aX, aY, aZ, 33)) {
            aWorld.func_147451_t(aX, aY, aZ);
            WD.update((IBlockAccess)aWorld, aX, aY, aZ);
            if (aY > 0) {
                if (aWorld.func_147439_a(aX, aY - 1, aZ) == this) {
                    aWorld.func_147464_a(aX, aY - 1, aZ, (Block)this, this.tickRate);
                } else {
                    aWorld.func_147451_t(aX, aY - 1, aZ);
                    WD.update((IBlockAccess)aWorld, aX, aY - 1, aZ);
                }
            }
        } else {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, Math.max(600, this.tickRate));
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (aY <= 0) {
            this.updateFlow(aWorld, aX, aY, aZ, aRandom);
            PLACEMENT_ALLOWED = false;
            return;
        }
        BiomeGenBase tBiome = aWorld.func_72807_a(aX, aZ);
        boolean tHasNoOceanAround = true;
        boolean tHasOceanBiome = CS.BIOMES_OCEAN_BEACH.contains(tBiome.field_76791_y);
        int tOceanCounter = 0;
        ArrayListNoNulls<ChunkCoordinates> tList = new ArrayListNoNulls<ChunkCoordinates>();
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
            tBlock = WD.block(aWorld, aX, aY, aZ, tSide);
            if (tBlock == this) {
                tHasNoOceanAround = false;
                if (!tHasOceanBiome && WD.meta(aWorld, aX, aY, aZ, tSide) != 0) continue;
                tOceanCounter = (byte)(tOceanCounter + 1);
                continue;
            }
            if (tBlock == CS.BlocksGT.River) {
                tList.add(new ChunkCoordinates(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]));
                tOceanCounter = (byte)(tOceanCounter + 1);
                continue;
            }
            if (WD.water(tBlock)) {
                tList.add(new ChunkCoordinates(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]));
                if (!tHasOceanBiome && WD.meta(aWorld, aX, aY, aZ, tSide) != 0) continue;
                tOceanCounter = (byte)(tOceanCounter + 1);
                continue;
            }
            if (!tHasOceanBiome || !(tBlock instanceof BlockWaterlike)) continue;
            tList.add(new ChunkCoordinates(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]));
            tOceanCounter = (byte)(tOceanCounter + 1);
        }
        tBlock = WD.block((IBlockAccess)aWorld, aX, aY - 1, aZ);
        if (tBlock == this) {
            tHasNoOceanAround = false;
            if (WD.meta((IBlockAccess)aWorld, aX, aY - 1, aZ) == 0) {
                tOceanCounter = (byte)(tOceanCounter + 1);
            }
        } else if (WD.anywater(tBlock)) {
            tHasNoOceanAround = false;
            if (aWorld.func_147465_d(aX, aY - 1, aZ, (Block)this, 0, WATER_UPDATE_FLAGS)) {
                tOceanCounter = (byte)(tOceanCounter + 1);
            }
        }
        if (tHasNoOceanAround && WD.block((IBlockAccess)aWorld, aX, aY + 1, aZ) != this) {
            aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, WATER_UPDATE_FLAGS);
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) != 0 && (tOceanCounter >= 2 || SPREAD_TO_AIR && tHasOceanBiome || aWorld.func_147439_a(aX, aY + 1, aZ) == this && WD.meta((IBlockAccess)aWorld, aX, aY + 1, aZ) == 0)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)this, 0, WATER_UPDATE_FLAGS);
        }
        if (CS.BIOMES_RIVER_LAKE.contains(tBiome.field_76791_y)) {
            tOceanCounter = 0;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (i == 0 || j == 0 || aWorld.func_147439_a(aX + i, aY, aZ + j) != this || WD.meta((IBlockAccess)aWorld, aX + i, aY, aZ + j) != 0) continue;
                    tOceanCounter = (byte)(tOceanCounter + 1);
                }
            }
            if (tOceanCounter < 3) {
                this.updateFlow(aWorld, aX, aY, aZ, aRandom);
                PLACEMENT_ALLOWED = false;
                return;
            }
        }
        Object object = tList.iterator();
        while (object.hasNext()) {
            ChunkCoordinates tCoords = (ChunkCoordinates)object.next();
            if (!aWorld.func_147465_d(tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, (Block)this, 0, WATER_UPDATE_FLAGS)) continue;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    if (!aWorld.func_72899_e(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j) || (tBlock = aWorld.func_147439_a(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j)) != this) continue;
                    aWorld.func_147464_a(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j, (Block)this, this.tickRate);
                }
            }
        }
        this.updateFlow(aWorld, aX, aY, aZ, aRandom);
        PLACEMENT_ALLOWED = false;
    }

    public int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aWorld.func_72805_g(aX, aY, aZ) == 0 && WD.air(aWorld.func_147439_a(aX, aY + 1, aZ)) && WD.air(aWorld.func_147439_a(aX, aY + 2, aZ)) && aWorld.func_147439_a(aX, aY - 1, aZ).getLightOpacity(aWorld, aX, aY - 1, aZ) < 255 ? 16 : 0;
    }

    @Override
    public IIcon func_149691_a(int aSide, int aMeta) {
        return Blocks.field_150355_j.func_149691_a(aSide, aMeta);
    }

    @Override
    public int func_149741_i(int aMeta) {
        return 0xC0C0C0;
    }

    @Override
    public int func_149720_d(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return 0xC0C0C0;
    }
}

