/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.data.CS;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenOresSmall
extends WorldgenObject {
    public final short mMinY;
    public final short mMaxY;
    public final short mAmount;
    public final OreDictMaterial mMaterial;

    @SafeVarargs
    public WorldgenOresSmall(String aName, boolean aDefault, int aMinY, int aMaxY, int aAmount, OreDictMaterial aPrimary, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        this.mMinY = (short)this.getConfigFile().get((Object)this.mCategory, "MinHeight", (long)aMinY);
        this.mMaxY = (short)Math.max(this.mMinY + 1, this.getConfigFile().get((Object)this.mCategory, "MaxHeight", (long)aMaxY));
        this.mAmount = (short)Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Amount", (long)aAmount));
        this.mMaterial = this.getConfigFile().get((Object)this.mCategory, "Ore", aPrimary);
        if (this.mEnabled && this.mMaterial.mID > 0) {
            OreDictManager.INSTANCE.triggerVisibility("ore" + this.mMaterial.mNameInternal);
        }
        if (this.mMaterial.mID <= 0) {
            CS.ERR.println("The Material is not valid for Ores: " + this.mMaterial);
            this.mInvalid = true;
        }
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (CS.GENERATING_SPECIAL) {
            return false;
        }
        int j = Math.max(1, this.mAmount / 2 + aRandom.nextInt(1 + this.mAmount) / 2);
        for (int i = 0; i < j; ++i) {
            WD.setSmallOre(aWorld, aMinX + aRandom.nextInt(16), this.mMinY + aRandom.nextInt(Math.max(1, this.mMaxY - this.mMinY)), aMinZ + aRandom.nextInt(16), this.mMaterial.mID);
        }
        return true;
    }
}

