/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.machines;

import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.common.Optional;
import gregapi.GT_API;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.gui.ContainerClientBasicMachine;
import gregapi.gui.ContainerCommonBasicMachine;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityGibbl;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tiles.IHasWork", modid="BuildCraft|Core")})
public class MultiTileEntityBasicMachine
extends TileEntityBase09FacingSingle
implements IHasWork,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible,
ITileEntitySwitchableOnOff,
ITileEntityRunningSuccessfully,
ITileEntityAdjacentInventoryUpdatable,
ITileEntityEnergy,
ITileEntityProgress,
ITileEntityGibbl,
IFluidHandler {
    public boolean mSpecialIsStartEnergy = false;
    public boolean mNoConstantEnergy = false;
    public boolean mCheapOverclocking = false;
    public boolean mCouldUseRecipe = false;
    public boolean mStopped = false;
    public boolean oActive = false;
    public boolean oRunning = false;
    public boolean mStateNew = false;
    public boolean mStateOld = false;
    public boolean mDisabledItemInput = false;
    public boolean mDisabledItemOutput = false;
    public boolean mDisabledFluidInput = false;
    public boolean mDisabledFluidOutput = false;
    public boolean mRequiresIgnition = false;
    public boolean mParallelDuration = false;
    public boolean mCanUseOutputTanks = false;
    public byte mEnergyInputs = (byte)127;
    public byte mEnergyOutput = (byte)6;
    public byte mOutputBlocked = 0;
    public byte mMode = 0;
    public byte mIgnited = 0;
    public byte mItemInputs = (byte)127;
    public byte mItemOutputs = (byte)127;
    public byte mItemAutoInput = (byte)6;
    public byte mItemAutoOutput = (byte)6;
    public byte mFluidInputs = (byte)127;
    public byte mFluidOutputs = (byte)127;
    public byte mFluidAutoInput = (byte)6;
    public byte mFluidAutoOutput = (byte)6;
    public short mEfficiency = (short)10000;
    public int mParallel = 1;
    public long mEnergy = 0L;
    public long mInputMin = 16L;
    public long mInput = 32L;
    public long mInputMax = 64L;
    public long mMinEnergy = 0L;
    public long mOutputEnergy = 0L;
    public long mChargeRequirement = 0L;
    public TagData mEnergyTypeAccepted = TD.Energy.TU;
    public TagData mEnergyTypeEmitted = TD.Energy.QU;
    public TagData mEnergyTypeCharged = TD.Energy.TU;
    public Recipe mLastRecipe = null;
    public Recipe mCurrentRecipe = null;
    public FluidTankGT[] mTanksInput = CS.ZL_FT;
    public FluidTankGT[] mTanksOutput = CS.ZL_FT;
    public ItemStack[] mOutputItems = CS.ZL_IS;
    public FluidStack[] mOutputFluids = CS.ZL_FS;
    public IIconContainer[] mTexturesMaterial = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesInactive = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesActive = CS.L6_IICONCONTAINER;
    public IIconContainer[] mTexturesRunning = CS.L6_IICONCONTAINER;
    public String mGUITexture = "";
    public Recipe.RecipeMap mRecipes = RM.Furnace;
    public long mProgress = 0L;
    public long mMaxProgress = 0L;
    public boolean mSuccessful = false;
    public boolean mActive = false;
    public boolean mRunning = false;
    public int[][] ACCESSIBLE = new int[7][];
    public int[] ACCESSIBLE_SLOTS;
    public int[] ACCESSIBLE_INPUTS;
    public int[] ACCESSIBLE_OUTPUTS;
    public static final int DID_NOT_FIND_RECIPE = 0;
    public static final int FOUND_RECIPE_BUT_DID_NOT_MEET_REQUIREMENTS = 1;
    public static final int FOUND_AND_SUCCESSFULLY_USED_RECIPE = 2;
    public static final int FOUND_AND_COULD_HAVE_USED_RECIPE = 3;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        this.mGUITexture = this.mRecipes.mGUIPath;
        this.mEnergy = aNBT.func_74763_f("gt.energy");
        if (aNBT.func_74764_b("gt.active")) {
            this.mCouldUseRecipe = this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.running")) {
            this.mRunning = aNBT.func_74767_n("gt.running");
        }
        if (aNBT.func_74764_b("gt.state.new")) {
            this.mStateNew = aNBT.func_74767_n("gt.state.new");
        }
        if (aNBT.func_74764_b("gt.state.old")) {
            this.mStateOld = aNBT.func_74767_n("gt.state.old");
        }
        if (aNBT.func_74764_b("gt.needignite")) {
            this.mRequiresIgnition = aNBT.func_74767_n("gt.needignite");
        }
        if (aNBT.func_74764_b("gt.cheap.overclocking")) {
            this.mCheapOverclocking = aNBT.func_74767_n("gt.cheap.overclocking");
        }
        if (aNBT.func_74764_b("gt.no.constant.power")) {
            this.mNoConstantEnergy = aNBT.func_74767_n("gt.no.constant.power");
        }
        if (aNBT.func_74764_b("gt.special.start.energy")) {
            this.mSpecialIsStartEnergy = aNBT.func_74767_n("gt.special.start.energy");
        }
        if (aNBT.func_74764_b("gt.eff")) {
            this.mEfficiency = (short)UT.Code.bind_(0L, 10000L, aNBT.func_74765_d("gt.eff"));
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
            this.mInputMin = this.mInput / 2L;
            this.mInputMax = this.mInput * 2L;
        }
        if (aNBT.func_74764_b("gt.input.min")) {
            this.mInputMin = aNBT.func_74763_f("gt.input.min");
        }
        if (aNBT.func_74764_b("gt.input.max")) {
            this.mInputMax = aNBT.func_74763_f("gt.input.max");
        }
        if (aNBT.func_74764_b("gt.minenergy")) {
            this.mMinEnergy = aNBT.func_74763_f("gt.minenergy");
        }
        if (aNBT.func_74764_b("gt.parallel")) {
            this.mParallel = Math.max(1, aNBT.func_74762_e("gt.parallel"));
        }
        if (aNBT.func_74764_b("gt.paradura")) {
            this.mParallelDuration = aNBT.func_74767_n("gt.paradura");
        }
        if (aNBT.func_74764_b("gt.useouttank")) {
            this.mCanUseOutputTanks = aNBT.func_74767_n("gt.useouttank");
        }
        if (aNBT.func_74764_b("gt.progress")) {
            this.mProgress = aNBT.func_74763_f("gt.progress");
        }
        if (aNBT.func_74764_b("gt.maxprogress")) {
            this.mMaxProgress = aNBT.func_74763_f("gt.maxprogress");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mMode = aNBT.func_74771_c("gt.mode");
        }
        if (aNBT.func_74764_b("gt.ignite")) {
            this.mIgnited = aNBT.func_74771_c("gt.ignite");
        }
        if (aNBT.func_74764_b("gt.invsidein")) {
            this.mItemInputs = (byte)(aNBT.func_74771_c("gt.invsidein") | 0x40);
        }
        if (aNBT.func_74764_b("gt.invsideout")) {
            this.mItemOutputs = (byte)(aNBT.func_74771_c("gt.invsideout") | 0x40);
        }
        if (aNBT.func_74764_b("gt.invsideautoin")) {
            this.mItemAutoInput = aNBT.func_74771_c("gt.invsideautoin");
        }
        if (aNBT.func_74764_b("gt.invsideautoout")) {
            this.mItemAutoOutput = aNBT.func_74771_c("gt.invsideautoout");
        }
        if (aNBT.func_74764_b("gt.invdisabledin")) {
            this.mDisabledItemInput = aNBT.func_74767_n("gt.invdisabledin");
        }
        if (aNBT.func_74764_b("gt.invdisabledout")) {
            this.mDisabledItemOutput = aNBT.func_74767_n("gt.invdisabledout");
        }
        if (aNBT.func_74764_b("gt.tanksidein")) {
            this.mFluidInputs = (byte)(aNBT.func_74771_c("gt.tanksidein") | 0x40);
        }
        if (aNBT.func_74764_b("gt.tanksideout")) {
            this.mFluidOutputs = (byte)(aNBT.func_74771_c("gt.tanksideout") | 0x40);
        }
        if (aNBT.func_74764_b("gt.tanksideautoin")) {
            this.mFluidAutoInput = aNBT.func_74771_c("gt.tanksideautoin");
        }
        if (aNBT.func_74764_b("gt.tanksideautoout")) {
            this.mFluidAutoOutput = aNBT.func_74771_c("gt.tanksideautoout");
        }
        if (aNBT.func_74764_b("gt.tankdisabledin")) {
            this.mDisabledFluidInput = aNBT.func_74767_n("gt.tankdisabledin");
        }
        if (aNBT.func_74764_b("gt.tankdisabledout")) {
            this.mDisabledFluidOutput = aNBT.func_74767_n("gt.tankdisabledout");
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted.2")) {
            this.mEnergyTypeCharged = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted.2"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted.sides")) {
            this.mEnergyInputs = (byte)(aNBT.func_74771_c("gt.energy.accepted.sides") | 0x40);
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
        if (aNBT.func_74764_b("gt.energy.emitted.sides")) {
            this.mEnergyOutput = aNBT.func_74771_c("gt.energy.emitted.sides");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutputEnergy = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.input.eu")) {
            this.mChargeRequirement = aNBT.func_74763_f("gt.input.eu");
        }
        long tCapacity = 1000L;
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = UT.Code.bindInt(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanksInput = new FluidTankGT[this.mRecipes.mInputFluidCount];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i] = new FluidTankGT(tCapacity).setCapacity(this.mRecipes, (long)this.mParallel * 2L).readFromNBT(aNBT, "gt.tank.in." + i);
        }
        this.mTanksOutput = new FluidTankGT[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i] = new FluidTankGT().readFromNBT(aNBT, "gt.tank.out." + i);
        }
        this.mOutputFluids = new FluidStack[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            this.mOutputFluids[i] = FL.load(aNBT, "gt.tankout." + i);
        }
        this.mOutputItems = new ItemStack[this.mRecipes.mOutputItemsCount];
        for (i = 0; i < this.mOutputItems.length; ++i) {
            this.mOutputItems[i] = ST.load(aNBT, "gt.invout." + i);
        }
        if (CS.CODE_CLIENT) {
            if (aNBT.func_74764_b("gt.gui")) {
                this.mGUITexture = aNBT.func_74779_i("gt.gui");
                if (!this.mGUITexture.endsWith(".png")) {
                    this.mGUITexture = this.mGUITexture + ".png";
                }
            }
            if (GT_API.sBlockIcons == null && aNBT.func_74764_b("gt.texture")) {
                String tTextureName = aNBT.func_74779_i("gt.texture");
                this.mTexturesMaterial = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/colored/back")};
                this.mTexturesInactive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay/back")};
                this.mTexturesActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_active/back")};
                this.mTexturesRunning = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/bottom"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/top"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/left"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/front"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/right"), new Textures.BlockIcons.CustomIcon("machines/basicmachines/" + tTextureName + "/overlay_running/back")};
            } else {
                TileEntity tCanonicalTileEntity = MultiTileEntityRegistry.getCanonicalTileEntity(this.getMultiTileEntityRegistryID(), (int)this.getMultiTileEntityID());
                if (tCanonicalTileEntity instanceof MultiTileEntityBasicMachine) {
                    this.mTexturesMaterial = ((MultiTileEntityBasicMachine)tCanonicalTileEntity).mTexturesMaterial;
                    this.mTexturesInactive = ((MultiTileEntityBasicMachine)tCanonicalTileEntity).mTexturesInactive;
                    this.mTexturesRunning = ((MultiTileEntityBasicMachine)tCanonicalTileEntity).mTexturesRunning;
                    this.mTexturesActive = ((MultiTileEntityBasicMachine)tCanonicalTileEntity).mTexturesActive;
                } else {
                    this.mTexturesActive = CS.L6_IICONCONTAINER;
                    this.mTexturesRunning = CS.L6_IICONCONTAINER;
                    this.mTexturesInactive = this.mTexturesRunning;
                    this.mTexturesMaterial = this.mTexturesRunning;
                }
            }
        }
        this.updateAccessibleSlots();
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setNumber(aNBT, "gt.minenergy", this.mMinEnergy);
        UT.NBT.setNumber(aNBT, "gt.progress", this.mProgress);
        UT.NBT.setNumber(aNBT, "gt.maxprogress", this.mMaxProgress);
        UT.NBT.setNumber(aNBT, "gt.output", this.mOutputEnergy);
        UT.NBT.setNumber(aNBT, "gt.input.eu", this.mChargeRequirement);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.running", this.mRunning);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
        UT.NBT.setBoolean(aNBT, "gt.state.new", this.mStateNew);
        UT.NBT.setBoolean(aNBT, "gt.state.old", this.mStateOld);
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setNumber(aNBT, "gt.ignite", this.mIgnited);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledin", this.mDisabledItemInput);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledout", this.mDisabledItemOutput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledin", this.mDisabledFluidInput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledout", this.mDisabledFluidOutput);
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i].writeToNBT(aNBT, "gt.tank.in." + i);
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i].writeToNBT(aNBT, "gt.tank.out." + i);
        }
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            FL.save(aNBT, "gt.tankout." + i, this.mOutputFluids[i]);
        }
        for (i = 0; i < this.mOutputItems.length; ++i) {
            ST.save(aNBT, "gt.invout." + i, this.mOutputItems[i]);
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledin", this.mDisabledItemInput);
        UT.NBT.setBoolean(aNBT, "gt.invdisabledout", this.mDisabledItemOutput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledin", this.mDisabledFluidInput);
        UT.NBT.setBoolean(aNBT, "gt.tankdisabledout", this.mDisabledFluidOutput);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal) + (this.mParallel > 1 ? " (up to " + this.mParallel + "x processed per run)" : ""));
        if (this.mCheapOverclocking) {
            aList.add(LH.Chat.YELLOW + LH.get("gt.lang.cheap.overclocking"));
        }
        if (this.mEfficiency != 10000) {
            aList.add(LH.getToolTipEfficiency(this.mEfficiency));
        }
        this.addToolTipsSided(aList, aStack, aF3_H);
        if (this.mRequiresIgnition) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        if (CS.SIDES_VALID[this.mFluidAutoInput] || CS.SIDES_VALID[this.mItemAutoInput]) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.inputs"));
        }
        if (CS.SIDES_VALID[this.mFluidAutoOutput] || CS.SIDES_VALID[this.mItemAutoOutput]) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        if (this instanceof ITileEntityMultiBlockController) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.builder.wand.to.ease.building"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    public void addToolTipsSided(List<String> aList, ItemStack aStack, boolean aF3_H) {
        String tSideNames = "";
        if (this.mEnergyTypeAccepted != TD.Energy.TU) {
            if (this.mEnergyInputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mEnergyInputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]);
                }
            }
            LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, tSideNames, null);
            tSideNames = "";
        }
        if (this.mEnergyTypeCharged != TD.Energy.TU) {
            if (this.mEnergyInputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mEnergyInputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]);
                }
            }
            LH.addEnergyToolTips(this, aList, this.mEnergyTypeCharged, null, tSideNames, null);
            tSideNames = "";
        }
        if (this.mRecipes.mInputItemsCount > 0) {
            if (this.mItemInputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mItemInputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]) + (tSide == this.mItemAutoInput ? " (auto)" : "");
                }
                if (UT.Code.stringValid(tSideNames)) {
                    aList.add(LH.Chat.GREEN + LH.get("gt.lang.item.input") + ": " + LH.Chat.WHITE + tSideNames);
                }
                tSideNames = "";
            } else if (CS.SIDES_VALID[this.mItemAutoInput]) {
                aList.add(LH.Chat.GREEN + LH.get("gt.lang.item.input") + ": " + LH.Chat.WHITE + LH.get(LH.FACES[this.mItemAutoInput]) + " (auto, otherwise any)");
            } else {
                aList.add(LH.Chat.GREEN + LH.get("gt.lang.item.input") + ": " + LH.Chat.WHITE + LH.get("gt.lang.face.any") + " (no auto)");
            }
        }
        if (this.mRecipes.mOutputItemsCount > 0) {
            if (this.mItemOutputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mItemOutputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]) + (tSide == this.mItemAutoOutput ? " (auto)" : "");
                }
                if (UT.Code.stringValid(tSideNames)) {
                    aList.add(LH.Chat.RED + LH.get("gt.lang.item.output") + ": " + LH.Chat.WHITE + tSideNames);
                }
                tSideNames = "";
            } else if (CS.SIDES_VALID[this.mItemAutoOutput]) {
                aList.add(LH.Chat.RED + LH.get("gt.lang.item.output") + ": " + LH.Chat.WHITE + LH.get(LH.FACES[this.mItemAutoOutput]) + " (auto, otherwise any)");
            } else {
                aList.add(LH.Chat.RED + LH.get("gt.lang.item.output") + ": " + LH.Chat.WHITE + LH.get("gt.lang.face.any") + " (no auto)");
            }
        }
        if (this.mRecipes.mInputFluidCount > 0) {
            if (this.mFluidInputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mFluidInputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]) + (tSide == this.mFluidAutoInput ? " (auto)" : "");
                }
                if (UT.Code.stringValid(tSideNames)) {
                    aList.add(LH.Chat.GREEN + LH.get("gt.lang.fluid.input") + ": " + LH.Chat.WHITE + tSideNames);
                }
                tSideNames = "";
            } else if (CS.SIDES_VALID[this.mFluidAutoInput]) {
                aList.add(LH.Chat.GREEN + LH.get("gt.lang.fluid.input") + ": " + LH.Chat.WHITE + LH.get(LH.FACES[this.mFluidAutoInput]) + " (auto, otherwise any)");
            } else {
                aList.add(LH.Chat.GREEN + LH.get("gt.lang.fluid.input") + ": " + LH.Chat.WHITE + LH.get("gt.lang.face.any") + " (no auto)");
            }
        }
        if (this.mRecipes.mOutputFluidCount > 0) {
            if (this.mFluidOutputs != 127) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!CS.FACE_CONNECTED[tSide][this.mFluidOutputs]) continue;
                    tSideNames = tSideNames + (UT.Code.stringValid(tSideNames) ? ", " : "") + LH.get(LH.FACES[tSide]) + (tSide == this.mFluidAutoOutput ? " (auto)" : "");
                }
                if (UT.Code.stringValid(tSideNames)) {
                    aList.add(LH.Chat.RED + LH.get("gt.lang.fluid.output") + ": " + LH.Chat.WHITE + tSideNames);
                }
            } else if (CS.SIDES_VALID[this.mFluidAutoOutput]) {
                aList.add(LH.Chat.RED + LH.get("gt.lang.fluid.output") + ": " + LH.Chat.WHITE + LH.get(LH.FACES[this.mFluidAutoOutput]) + " (auto, otherwise any)");
            } else {
                aList.add(LH.Chat.RED + LH.get("gt.lang.fluid.output") + ": " + LH.Chat.WHITE + LH.get("gt.lang.face.any") + " (no auto)");
            }
        }
    }

    public long onToolClick3(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("screwdriver")) {
            this.mMode = (byte)((this.mMode + 1) % 4);
            aChatReturn.add("========================================");
            aChatReturn.add((this.mMode & 1) != 0 ? "Only produce when Output is completely empty" : "Produce whenever there is space");
            aChatReturn.add((this.mMode & 2) != 0 ? "Only accept Input on empty Input Slots" : "Accept Input on all Input Slots");
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("softhammer")) {
            this.mChargeRequirement = 0L;
            this.mOutputEnergy = 0L;
            this.mMaxProgress = 0L;
            this.mMinEnergy = 0L;
            this.mProgress = 0L;
            this.mOutputFluids = CS.ZL_FS;
            this.mOutputItems = CS.ZL_IS;
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("igniter")) {
            if (this.mRequiresIgnition) {
                this.mIgnited = (byte)40;
                return 10000L;
            }
            return 0L;
        }
        if (aTool.equals("plunger")) {
            long rAmount;
            this.updateInventory();
            for (FluidTankGT tTank : this.mTanksOutput) {
                rAmount = CS.GarbageGT.trash(tTank, 1000L);
                if (rAmount <= 0L) continue;
                return rAmount;
            }
            for (FluidTankGT tTank : this.mTanksInput) {
                rAmount = CS.GarbageGT.trash(tTank, 1000L);
                if (rAmount <= 0L) continue;
                return rAmount;
            }
        }
        if (aTool.equals("monkeywrench")) {
            long rOutput = 0L;
            if (CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput] == aSide) {
                this.mDisabledItemInput = !this.mDisabledItemInput;
                aChatReturn.add(this.mDisabledItemInput ? "Auto Item Input Disabled" : "Auto Item Input Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput] == aSide) {
                this.mDisabledItemOutput = !this.mDisabledItemOutput;
                aChatReturn.add(this.mDisabledItemOutput ? "Auto Item Output Disabled" : "Auto Item Output Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoInput] == aSide) {
                this.mDisabledFluidInput = !this.mDisabledFluidInput;
                aChatReturn.add(this.mDisabledFluidInput ? "Auto Fluid Input Disabled" : "Auto Fluid Input Enabled");
                rOutput += 10000L;
            }
            if (CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoOutput] == aSide) {
                this.mDisabledFluidOutput = !this.mDisabledFluidOutput;
                aChatReturn.add(this.mDisabledFluidOutput ? "Auto Fluid Output Disabled" : "Auto Fluid Output Enabled");
                rOutput += 10000L;
            }
            if (rOutput > 0L) {
                this.updateInventory();
                return rOutput;
            }
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                this.onMagnifyingGlass(aChatReturn);
            }
            return 1L;
        }
        return 0L;
    }

    public void onMagnifyingGlass(List<String> aChatReturn) {
        aChatReturn.add((this.mMode & 1) != 0 ? "Only produce when Output is completely empty" : "Produce whenever there is space");
        aChatReturn.add((this.mMode & 2) != 0 ? "Only accept Input on empty Input Slots" : "Accept Input on all Input Slots");
        if (CS.SIDES_VALID[this.mItemAutoInput]) {
            aChatReturn.add(this.mDisabledItemInput ? "Auto Item Input Disabled" : "Auto Item Input Enabled");
        }
        if (CS.SIDES_VALID[this.mItemAutoOutput]) {
            aChatReturn.add(this.mDisabledItemOutput ? "Auto Item Output Disabled" : "Auto Item Output Enabled");
        }
        if (CS.SIDES_VALID[this.mFluidAutoInput]) {
            aChatReturn.add(this.mDisabledFluidInput ? "Auto Fluid Input Disabled" : "Auto Fluid Input Enabled");
        }
        if (CS.SIDES_VALID[this.mFluidAutoOutput]) {
            aChatReturn.add(this.mDisabledFluidOutput ? "Auto Fluid Output Disabled" : "Auto Fluid Output Enabled");
        }
    }

    @Override
    public void onCoordinateChange() {
        this.updateAdjacentToggleableEnergySources();
    }

    @Override
    public void onTickFailed(long aTimer, boolean aIsServerSide) {
        super.onTickFailed(aTimer, aIsServerSide);
        this.mChargeRequirement = 0L;
        this.mOutputEnergy = 0L;
        this.mMaxProgress = 0L;
        this.mMinEnergy = 0L;
        this.mProgress = 0L;
        this.mOutputFluids = CS.ZL_FS;
        this.mOutputItems = CS.ZL_IS;
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        if (aIsServerSide && this.checkStructure(true) && !this.mActive) {
            this.checkRecipe(false, this.mRunning || this.mStopped);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            int i;
            if (this.mBlockUpdated) {
                this.updateAdjacentToggleableEnergySources();
            }
            if (!this.mStopped) {
                if (this.mEnergyTypeAccepted == TD.Energy.TU) {
                    ++this.mEnergy;
                }
                if (this.mChargeRequirement > 0L && this.mEnergyTypeCharged == TD.Energy.TU) {
                    --this.mChargeRequirement;
                }
            }
            if (!this.mDisabledFluidOutput && CS.SIDES_VALID[this.mFluidAutoOutput]) {
                this.doOutputFluids();
            }
            this.doWork(aTimer);
            if (this.mTimer % 600L == 5L && this.mRunning) {
                this.doDefaultStructuralChecks();
            }
            for (i = 0; i < this.mTanksInput.length; ++i) {
                this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + i, FL.display(this.mTanksInput[i], true, true));
            }
            for (i = 0; i < this.mTanksOutput.length; ++i) {
                this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + i + this.mTanksInput.length, FL.display(this.mTanksOutput[i], true, true));
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActive != this.oActive || this.mRunning != this.oRunning || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oRunning = this.mRunning;
        this.oActive = this.mActive;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            this.openGUI(aPlayer, aSide);
        }
        return true;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (this.mStopped) {
            return 0L;
        }
        boolean tPositive = aSize > 0L;
        if ((aSize = Math.abs(aSize)) > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (aEnergyType == this.mEnergyTypeCharged && this.mChargeRequirement > 0L) {
            if (aDoInject) {
                this.mChargeRequirement -= aSize * aAmount;
            }
            return aAmount;
        }
        if (aEnergyType == this.mEnergyTypeAccepted) {
            if (aDoInject) {
                this.mStateNew = tPositive;
            }
            long tInput = Math.min(this.mInputMax - this.mEnergy, aSize * aAmount);
            long tConsumed = Math.min(aAmount, tInput / aSize + (long)(tInput % aSize != 0L ? 1 : 0));
            if (aDoInject) {
                this.mEnergy += tConsumed * aSize;
            }
            return tConsumed;
        }
        return 0L;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting ? aEnergyType == this.mEnergyTypeEmitted : aEnergyType == this.mEnergyTypeAccepted || aEnergyType == this.mEnergyTypeCharged;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (aTheoretical || !this.mStopped) && CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mEnergyInputs] && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && this.mStopped || !CS.SIDES_INVALID[this.mEnergyOutput] && CS.FACING_ROTATIONS[this.mFacing][aSide] != this.mEnergyOutput || !super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return this.mInputMin;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mInputMax;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 1L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInputMax;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return Integer.MAX_VALUE;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        this.ACCESSIBLE_SLOTS = UT.Code.getAscendingArray(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount);
        this.ACCESSIBLE_INPUTS = UT.Code.getAscendingArray(this.mRecipes.mInputItemsCount);
        this.ACCESSIBLE_OUTPUTS = new int[this.mRecipes.mOutputItemsCount];
        for (int i = 0; i < this.ACCESSIBLE_OUTPUTS.length; ++i) {
            this.ACCESSIBLE_OUTPUTS[i] = i + this.mRecipes.mInputItemsCount;
        }
        return new ItemStack[this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1 + this.mRecipes.mInputFluidCount + this.mRecipes.mOutputFluidCount];
    }

    public void updateAccessibleSlots() {
        for (int i = 0; i < this.ACCESSIBLE.length; i = (int)((byte)(i + 1))) {
            if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][i]][this.mItemInputs]) {
                if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][i]][this.mItemOutputs]) {
                    this.ACCESSIBLE[i] = this.ACCESSIBLE_SLOTS;
                    continue;
                }
                this.ACCESSIBLE[i] = this.ACCESSIBLE_INPUTS;
                continue;
            }
            this.ACCESSIBLE[i] = CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][i]][this.mItemOutputs] ? this.ACCESSIBLE_OUTPUTS : CS.ZL_INTEGER;
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return this.ACCESSIBLE[aSide];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return aInventorySlot < this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount + 1;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot >= this.mRecipes.mInputItemsCount) {
            return false;
        }
        if ((this.mMode & 2) != 0 && this.slotHas(aSlot)) {
            return false;
        }
        for (int i = 0; i < this.mRecipes.mInputItemsCount; ++i) {
            if (!ST.equal(aStack, this.slot(i), true)) continue;
            return i == aSlot;
        }
        return this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot >= this.mRecipes.mInputItemsCount && aSlot < this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount;
    }

    @Override
    public IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        int i;
        if (!this.mDisabledFluidOutput && CS.SIDES_VALID[this.mFluidAutoOutput] && CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoOutput] == aSide) {
            return null;
        }
        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidInputs]) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!this.mTanksInput[i].contains(aFluidToFill)) continue;
            return this.mTanksInput[i];
        }
        if (!this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount))) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!this.mTanksInput[i].isEmpty()) continue;
            return this.mTanksInput[i];
        }
        return null;
    }

    @Override
    public IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
            return null;
        }
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                int j = ((int)(CS.SERVER_TIME / 20L) + i) % this.mTanksOutput.length;
                if (!this.mTanksOutput[j].has()) continue;
                return this.mTanksOutput[j];
            }
        } else {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (!this.mTanksOutput[i].contains(aFluidToDrain)) continue;
                return this.mTanksOutput[i];
            }
        }
        return null;
    }

    @Override
    public IFluidTank[] getFluidTanks2(byte aSide) {
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidInputs]) {
            if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
                int i;
                IFluidTank[] rTanks = new IFluidTank[this.mTanksInput.length + this.mTanksOutput.length];
                for (i = 0; i < this.mTanksInput.length; ++i) {
                    rTanks[i] = this.mTanksInput[i];
                }
                for (i = 0; i < this.mTanksOutput.length; ++i) {
                    rTanks[this.mTanksInput.length + i] = this.mTanksOutput[i];
                }
                return rTanks;
            }
            return this.mTanksInput;
        }
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mFluidOutputs]) {
            return this.mTanksOutput;
        }
        return CS.ZL_FT;
    }

    @Override
    public boolean breakBlock() {
        this.setStateOnOff(true);
        CS.GarbageGT.trash(this.mTanksInput);
        CS.GarbageGT.trash(this.mTanksOutput);
        CS.GarbageGT.trash(this.mOutputItems);
        CS.GarbageGT.trash(this.mOutputFluids);
        return super.breakBlock();
    }

    public void updateAdjacentToggleableEnergySources() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!this.isEnergyAcceptingFrom(this.mEnergyTypeAccepted, tSide, true)) continue;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentOnOff) || !(tDelegator.mTileEntity instanceof ITileEntityEnergy) || !((ITileEntityEnergy)tDelegator.mTileEntity).isEnergyEmittingTo(this.mEnergyTypeAccepted, tDelegator.mSideOfTileEntity, true)) continue;
            ((ITileEntityAdjacentOnOff)tDelegator.mTileEntity).setAdjacentOnOff(this.getStateOnOff());
        }
    }

    public int canOutput(Recipe aRecipe) {
        int rMaxTimes;
        this.doOutputItems();
        if (this.mParallelDuration) {
            for (rMaxTimes = this.mParallel; rMaxTimes > 1 && aRecipe.getAbsoluteTotalPower() * (long)rMaxTimes > this.mInputMax * 600L; --rMaxTimes) {
            }
        }
        int i = 0;
        int j = this.mRecipes.mInputItemsCount;
        while (i < this.mRecipes.mOutputItemsCount && i < aRecipe.mOutputs.length) {
            if (ST.valid(aRecipe.mOutputs[i])) {
                if (this.slotHas(j)) {
                    if ((this.mMode & 1) != 0 || aRecipe.mNeedsEmptyOutput) {
                        this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                        return 0;
                    }
                    if (!ST.equal(this.slot(j), aRecipe.mOutputs[i], false)) {
                        this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                        return 0;
                    }
                    if ((rMaxTimes = Math.min(rMaxTimes, (this.slot(j).func_77976_d() - this.slot((int)j).field_77994_a) / aRecipe.mOutputs[i].field_77994_a)) <= 0) {
                        this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                        return 0;
                    }
                } else {
                    rMaxTimes = Math.min(rMaxTimes, Math.max(1, 64 / aRecipe.mOutputs[i].field_77994_a));
                }
            }
            ++i;
            ++j;
        }
        if (aRecipe.mFluidOutputs.length > 0) {
            int tEmptyOutputTanks = 0;
            int tRequiredEmptyTanks = aRecipe.mFluidOutputs.length;
            for (int i2 = 0; i2 < this.mTanksOutput.length; ++i2) {
                if (this.mTanksOutput[i2].isEmpty()) {
                    ++tEmptyOutputTanks;
                    continue;
                }
                if (!aRecipe.mNeedsEmptyOutput && (this.mMode & 1) == 0) continue;
                return 0;
            }
            block3: for (int j2 = 0; j2 < aRecipe.mFluidOutputs.length; ++j2) {
                if (aRecipe.mFluidOutputs[j2] == null) {
                    --tRequiredEmptyTanks;
                    continue;
                }
                for (int i3 = 0; i3 < this.mTanksOutput.length; ++i3) {
                    if (!this.mTanksOutput[i3].contains(aRecipe.mFluidOutputs[j2])) continue;
                    if (this.mTanksOutput[i3].has(Math.max(16000, 1 + aRecipe.mFluidOutputs[j2].amount * this.mParallel)) && !CS.FluidsGT.VOID_OVERFLOW.contains(aRecipe.mFluidOutputs[j2].getFluid().getName())) {
                        return 0;
                    }
                    --tRequiredEmptyTanks;
                    continue block3;
                }
            }
            if (tRequiredEmptyTanks > tEmptyOutputTanks) {
                return 0;
            }
        }
        return rMaxTimes;
    }

    /*
     * WARNING - void declaration
     */
    public int checkRecipe(boolean aApplyRecipe, boolean aUseAutoIO) {
        void var7_11;
        FluidTankInfo[] tInfos;
        DelegatorTileEntity<IFluidHandler> delegatorTileEntity;
        this.mCouldUseRecipe = false;
        if (this.mRecipes == null) {
            return 0;
        }
        if (aUseAutoIO) {
            this.doInputItems();
        }
        int tInputItemsCount = 0;
        int tInputFluidsCount = 0;
        ItemStack[] tInputs = new ItemStack[this.mRecipes.mInputItemsCount];
        for (int i = 0; i < this.mRecipes.mInputItemsCount; ++i) {
            tInputs[i] = this.slot(i);
            if (!ST.valid(tInputs[i])) continue;
            ++tInputItemsCount;
        }
        byte tAutoInput = CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoInput];
        if (aUseAutoIO && !this.mDisabledFluidInput && CS.SIDES_VALID[tAutoInput] && (delegatorTileEntity = this.getFluidInputTarget(tAutoInput)) != null && delegatorTileEntity.mTileEntity != null && (tInfos = ((IFluidHandler)delegatorTileEntity.mTileEntity).getTankInfo(CS.FORGE_DIR[delegatorTileEntity.mSideOfTileEntity])) != null) {
            for (FluidTankInfo tInfo : tInfos) {
                if (tInfo == null || tInfo.fluid == null || tInfo.fluid.amount <= 0 || this.getFluidTankFillable((byte)6, tInfo.fluid) == null || FL.move_(delegatorTileEntity, this.delegator(tAutoInput), tInfo.fluid) <= 0L) continue;
                this.updateInventory();
            }
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.has()) continue;
            ++tInputFluidsCount;
        }
        if (tInputItemsCount < this.mRecipes.mMinimalInputItems) {
            return 0;
        }
        if (tInputFluidsCount < this.mRecipes.mMinimalInputFluids) {
            return 0;
        }
        if (tInputItemsCount + tInputFluidsCount < this.mRecipes.mMinimalInputs) {
            return 0;
        }
        Recipe recipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, this.mEnergyTypeAccepted == TD.Energy.RF ? this.mInputMax / 4L : this.mInputMax, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount), this.mTanksInput, tInputs);
        int tMaxProcessCount = 0;
        if (recipe == null) {
            if (!this.mCanUseOutputTanks) {
                return 0;
            }
            Recipe recipe2 = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, this.mEnergyTypeAccepted == TD.Energy.RF ? this.mInputMax / 4L : this.mInputMax, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount), this.mTanksOutput, tInputs);
            if (recipe2 == null) {
                return 0;
            }
            if (recipe2.mCanBeBuffered) {
                this.mLastRecipe = recipe2;
            }
            if ((tMaxProcessCount = this.canOutput(recipe2)) <= 0) {
                return 1;
            }
            if (aApplyRecipe) {
                boolean bl = aApplyRecipe = !this.mRequiresIgnition || this.mIgnited > 0 || this.mActive;
            }
            if (!recipe2.isRecipeInputEqual(aApplyRecipe, false, this.mTanksOutput, tInputs)) {
                return 1;
            }
            this.mCouldUseRecipe = true;
            if (!aApplyRecipe) {
                return 3;
            }
            if (tMaxProcessCount > 1) {
                if (!this.mParallelDuration && this.mEnergyTypeAccepted != TD.Energy.TU) {
                    tMaxProcessCount = (int)UT.Code.bind(1L, tMaxProcessCount, this.mInput / Math.max(1L, this.mEnergyTypeAccepted == TD.Energy.RF ? recipe2.mEUt * 4L : recipe2.mEUt));
                }
                tMaxProcessCount = 1 + recipe2.isRecipeInputEqual(tMaxProcessCount - 1, this.mTanksOutput, tInputs);
            }
        } else {
            if (recipe.mCanBeBuffered) {
                this.mLastRecipe = recipe;
            }
            if ((tMaxProcessCount = this.canOutput(recipe)) <= 0) {
                return 1;
            }
            if (aApplyRecipe) {
                boolean bl = aApplyRecipe = !this.mRequiresIgnition || this.mIgnited > 0 || this.mActive;
            }
            if (!recipe.isRecipeInputEqual(aApplyRecipe, false, this.mTanksInput, tInputs)) {
                return 1;
            }
            this.mCouldUseRecipe = true;
            if (!aApplyRecipe) {
                return 3;
            }
            if (tMaxProcessCount > 1) {
                if (!this.mParallelDuration && this.mEnergyTypeAccepted != TD.Energy.TU) {
                    tMaxProcessCount = (int)UT.Code.bind(1L, tMaxProcessCount, this.mInput / Math.max(1L, this.mEnergyTypeAccepted == TD.Energy.RF ? recipe.mEUt * 4L : recipe.mEUt));
                }
                tMaxProcessCount = 1 + recipe.isRecipeInputEqual(tMaxProcessCount - 1, this.mTanksInput, tInputs);
            }
        }
        for (byte tSide : CS.ALL_SIDES_VALID_FIRST[CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput]]) {
            DelegatorTileEntity<IInventory> tDelegator;
            if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][tSide]][this.mItemInputs] || (tDelegator = this.getItemInputTarget(tSide)) == null || !(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
            ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
        }
        if (this.mSpecialIsStartEnergy && (!this.mActive || this.mCurrentRecipe != null && this.mCurrentRecipe != var7_11)) {
            this.mChargeRequirement = var7_11.mSpecialValue;
        }
        this.mCurrentRecipe = var7_11;
        this.mOutputItems = var7_11.getOutputs(CS.RNGSUS, tMaxProcessCount);
        this.mOutputFluids = var7_11.getFluidOutputs(CS.RNGSUS, tMaxProcessCount);
        if (var7_11.mEUt < 0L) {
            this.mOutputEnergy = -var7_11.mEUt;
            this.mMaxProgress = var7_11.mDuration;
            this.mMinEnergy = 0L;
        } else {
            if (this.mParallelDuration) {
                this.mMinEnergy = Math.max(1L, this.mEnergyTypeAccepted == TD.Energy.RF ? var7_11.mEUt * 4L : var7_11.mEUt);
                this.mMaxProgress = Math.max(1L, UT.Code.units(this.mMinEnergy * Math.max(1L, var7_11.mDuration) * (long)tMaxProcessCount, this.mEfficiency, 10000L, true));
            } else {
                this.mMinEnergy = Math.max(1L, this.mEnergyTypeAccepted == TD.Energy.RF ? var7_11.mEUt * 4L * (long)tMaxProcessCount : (this.mEnergyTypeAccepted == TD.Energy.TU ? var7_11.mEUt : var7_11.mEUt * (long)tMaxProcessCount));
                this.mMaxProgress = Math.max(1L, UT.Code.units(this.mMinEnergy * Math.max(1L, var7_11.mDuration), this.mEfficiency, 10000L, true));
            }
            if (!this.mCheapOverclocking) {
                while (this.mMinEnergy < this.mInputMin && this.mMinEnergy * 4L <= this.mInputMax) {
                    this.mMinEnergy *= 4L;
                    this.mMaxProgress *= 2L;
                }
            }
        }
        this.removeAllDroppableNullStacks();
        return 2;
    }

    public void doWork(long aTimer) {
        if (this.mEnergy >= this.mInputMin && this.mEnergy >= this.mMinEnergy && this.checkStructure(false)) {
            this.mActive = this.doActive(aTimer, Math.min(this.mInputMax, this.mEnergy));
            this.mRunning = true;
        } else {
            if (aTimer > 40L) {
                this.mActive = this.doInactive(aTimer);
                this.mRunning = false;
            }
            this.mSuccessful = false;
        }
        this.mEnergy -= this.mInputMax;
        if (this.mEnergy < 0L) {
            this.mEnergy = 0L;
        }
        if (this.mIgnited > 0) {
            this.mIgnited = (byte)(this.mIgnited - 1);
        }
    }

    public boolean doActive(long aTimer, long aEnergy) {
        boolean rActive = false;
        if (this.mMaxProgress <= 0L) {
            if ((this.mIgnited > 0 || this.mInventoryChanged || !this.mRunning || aTimer % 1200L == 5L) && this.checkRecipe(!this.mStopped, true) == 2) {
                this.onProcessStarted();
            } else {
                this.mProgress = 0L;
            }
        }
        this.mSuccessful = false;
        if (!(this.mMaxProgress <= 0L || this.mSpecialIsStartEnergy && this.mChargeRequirement > 0L)) {
            rActive = true;
            if (this.mProgress <= this.mMaxProgress) {
                if (this.mOutputEnergy > 0L) {
                    this.doOutputEnergy();
                }
                this.mProgress += aEnergy;
            }
            if (this.mProgress >= this.mMaxProgress && (this.mStateOld && !this.mStateNew || !TD.Energy.ALL_ALTERNATING.contains(this.mEnergyTypeAccepted))) {
                int j;
                int i;
                for (i = 0; i < this.mOutputItems.length; ++i) {
                    if (this.mOutputItems[i] == null || !this.addStackToSlot(this.mRecipes.mInputItemsCount + i % this.mRecipes.mOutputItemsCount, this.mOutputItems[i])) continue;
                    this.mSuccessful = true;
                    this.mIgnited = (byte)40;
                    this.mOutputItems[i] = null;
                }
                block1: for (i = 0; i < this.mOutputFluids.length; ++i) {
                    if (this.mOutputFluids[i] == null) continue;
                    for (j = 0; j < this.mTanksOutput.length; ++j) {
                        if (!this.mTanksOutput[j].contains(this.mOutputFluids[i])) continue;
                        this.updateInventory();
                        this.mTanksOutput[j].add(this.mOutputFluids[i].amount);
                        this.mSuccessful = true;
                        this.mIgnited = (byte)40;
                        this.mOutputFluids[i] = null;
                        continue block1;
                    }
                }
                block3: for (i = 0; i < this.mOutputFluids.length; ++i) {
                    if (this.mOutputFluids[i] == null) continue;
                    for (j = 0; j < this.mTanksOutput.length; ++j) {
                        if (!this.mTanksOutput[j].isEmpty()) continue;
                        this.mTanksOutput[j].setFluid(this.mOutputFluids[i]);
                        this.mSuccessful = true;
                        this.mIgnited = (byte)40;
                        this.mOutputFluids[i] = null;
                        continue block3;
                    }
                }
                if (UT.Code.containsSomething(this.mOutputItems) || UT.Code.containsSomething(this.mOutputFluids)) {
                    this.mMinEnergy = 0L;
                    this.mOutputEnergy = 0L;
                    this.mChargeRequirement = 0L;
                    this.mProgress = this.mMaxProgress;
                } else {
                    this.mProgress -= this.mMaxProgress;
                    this.mMinEnergy = 0L;
                    this.mMaxProgress = 0L;
                    this.mOutputEnergy = 0L;
                    this.mChargeRequirement = 0L;
                    this.mOutputItems = CS.ZL_IS;
                    this.mOutputFluids = CS.ZL_FS;
                    this.mSuccessful = true;
                    this.mIgnited = (byte)40;
                    for (byte tSide : CS.ALL_SIDES_VALID_FIRST[CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput]]) {
                        DelegatorTileEntity<TileEntity> tDelegator;
                        if (!CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][tSide]][this.mItemOutputs] || (tDelegator = this.getItemOutputTarget(tSide)) == null || !(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                        ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                    }
                    this.onProcessFinished();
                }
            }
        }
        this.mStateOld = this.mStateNew;
        if (!this.mDisabledItemOutput && CS.SIDES_VALID[this.mItemAutoOutput]) {
            int i;
            boolean tOutputEmpty = true;
            int j = i + this.mRecipes.mOutputItemsCount;
            for (i = this.mRecipes.mInputItemsCount; i < j; ++i) {
                if (!this.slotHas(i)) continue;
                tOutputEmpty = false;
                break;
            }
            if (!(tOutputEmpty || this.mIgnited <= 0 && !this.mInventoryChanged && this.mRunning && this.mOutputBlocked != 1 && aTimer % 200L != 5L)) {
                boolean tInventoryChanged = this.mInventoryChanged;
                this.mInventoryChanged = false;
                this.doOutputItems();
                if (this.mInventoryChanged) {
                    this.mOutputBlocked = 0;
                } else {
                    this.mInventoryChanged |= tInventoryChanged;
                }
            }
            tOutputEmpty = true;
            j = i + this.mRecipes.mOutputItemsCount;
            for (i = this.mRecipes.mInputItemsCount; i < j; ++i) {
                if (!this.slotHas(i)) continue;
                tOutputEmpty = false;
                this.mOutputBlocked = (byte)(this.mOutputBlocked + 1);
                break;
            }
            if (tOutputEmpty) {
                this.mOutputBlocked = 0;
            }
        }
        return rActive;
    }

    public boolean doInactive(long aTimer) {
        if (this.mActive) {
            this.doSoundInterrupt();
            this.doOutputItems();
        }
        if (CS.CONSTANT_ENERGY && !this.mNoConstantEnergy) {
            this.mProgress = 0L;
        }
        if (this.mRunning || this.mIgnited > 0 || this.mInventoryChanged || aTimer % 1200L == 5L) {
            if (!this.checkStructure(false)) {
                this.checkStructure(true);
            }
            this.checkRecipe(false, true);
        }
        return false;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.contains(aFluid)) continue;
            this.updateInventory();
            return tTank.fill(aFluid, aDoFill);
        }
        if (!this.mRecipes.containsInput(aFluid, (IHasWorldAndCoords)this, this.slot(this.mRecipes.mInputItemsCount + this.mRecipes.mOutputItemsCount))) {
            return 0;
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.isEmpty()) continue;
            this.updateInventory();
            return tTank.fill(aFluid, aDoFill);
        }
        return 0;
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.has() || FL.gas(tTank)) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.has() || FL.gas(tTank)) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.has()) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.has()) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        return null;
    }

    @Override
    public FluidStack nozzleDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.has() || !FL.gas(tTank)) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.has() || !FL.gas(tTank)) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.has()) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.has()) continue;
            this.updateInventory();
            return tTank.drain(aMaxDrain, aDoDrain);
        }
        return null;
    }

    public boolean doSoundInterrupt() {
        return UT.Sounds.send(this.mRequiresIgnition ? "random.fizz" : (this.mNoConstantEnergy ? "random.break" : "random.click"), this, false);
    }

    public boolean checkStructure(boolean aForceReset) {
        return true;
    }

    public DelegatorTileEntity<IInventory> getItemInputTarget(byte aSide) {
        return this.getAdjacentInventory(aSide);
    }

    public DelegatorTileEntity<TileEntity> getItemOutputTarget(byte aSide) {
        return this.getAdjacentTileEntity(aSide);
    }

    public DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte aSide) {
        return this.getAdjacentTank(aSide);
    }

    public DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte aSide, Fluid aOutput) {
        return this.getAdjacentTank(aSide);
    }

    public void doInputItems() {
        if (this.mDisabledItemInput) {
            return;
        }
        byte tAutoInput = CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoInput];
        if (CS.SIDES_VALID[tAutoInput]) {
            ST.moveAll(this.getItemInputTarget(tAutoInput), this.delegator(tAutoInput));
        }
    }

    public void doOutputItems() {
        if (this.mDisabledItemOutput) {
            return;
        }
        byte tAutoOutput = CS.FACING_TO_SIDE[this.mFacing][this.mItemAutoOutput];
        if (CS.SIDES_VALID[tAutoOutput]) {
            ST.moveAll(this.delegator(tAutoOutput), this.getItemOutputTarget(tAutoOutput));
        }
    }

    public void doOutputFluids() {
        for (FluidTankGT tCheck : this.mTanksOutput) {
            if (!tCheck.has() || FL.move(tCheck, this.getFluidOutputTarget(CS.FACING_TO_SIDE[this.mFacing][this.mFluidAutoOutput], tCheck.fluid())) <= 0L) continue;
            this.updateInventory();
        }
    }

    public void doOutputEnergy() {
        ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyTypeEmitted, CS.FACING_TO_SIDE[this.mFacing][this.mEnergyOutput], this.mOutputEnergy, 1L, this);
    }

    public void onProcessStarted() {
    }

    public void onProcessFinished() {
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.updateAccessibleSlots();
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientBasicMachine(aPlayer.field_71071_by, this, this.mRecipes, aGUIID, this.mGUITexture);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonBasicMachine(aPlayer.field_71071_by, (ITileEntityInventoryGUI)this, this.mRecipes, aGUIID);
    }

    @Override
    public byte getVisualData() {
        return (byte)((this.mActive ? 1 : 0) | (this.mRunning ? 2 : 0));
    }

    @Override
    public void setVisualData(byte aData) {
        this.mRunning = (aData & 2) != 0;
        this.mActive = (aData & 1) != 0;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return this.mActive ? CS.SIDES_THIS[this.mFacing] : CS.SIDES_HORIZONTAL;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(this.mTexturesMaterial[CS.FACING_ROTATIONS[this.mFacing][aSide]], this.mRGBa), BlockTextureDefault.get((this.mActive || this.field_145850_b == null ? this.mTexturesActive : (this.mRunning ? this.mTexturesRunning : this.mTexturesInactive))[CS.FACING_ROTATIONS[this.mFacing][aSide]])) : null;
    }

    @Override
    public boolean canSave(int aSlot) {
        return !IL.Display_Fluid.equal(this.slot(aSlot), true, true);
    }

    public boolean hasWork() {
        return this.mMaxProgress > 0L || this.mChargeRequirement > 0L;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mSuccessful ? this.getProgressMax(aSide) : (this.mMinEnergy < 1L ? this.mProgress : UT.Code.divup(this.mProgress, this.mMinEnergy));
    }

    @Override
    public long getProgressMax(byte aSide) {
        return Math.max(1L, this.mMinEnergy < 1L ? this.mMaxProgress : UT.Code.divup(this.mMaxProgress, this.mMinEnergy));
    }

    @Override
    public long getGibblValue(byte aSide) {
        long rGibbl = 0L;
        for (int i = 0; i < this.mTanksInput.length; ++i) {
            rGibbl += this.mTanksInput[i].amount();
        }
        return rGibbl;
    }

    @Override
    public long getGibblMax(byte aSide) {
        long rGibbl = 0L;
        for (int i = 0; i < this.mTanksInput.length; ++i) {
            rGibbl += this.mTanksInput[i].capacity();
        }
        return rGibbl;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mCouldUseRecipe || this.mActive || this.mMaxProgress > 0L || this.mChargeRequirement > 0L || this.mIgnited > 0 && !this.mDisabledItemOutput && this.mOutputBlocked != 0;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mRunning;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        return this.mSuccessful;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        if (this.mStopped == aOnOff) {
            this.mStopped = !aOnOff;
            this.updateAdjacentToggleableEnergySources();
        }
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.machine.basic";
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.FACE_CONNECTED[CS.FACING_ROTATIONS[this.mFacing][aSide]][this.mItemInputs | this.mItemOutputs]) {
            this.updateInventory();
        }
    }
}

