/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.behavior;

import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.tileentity.behavior.TE_Behavior;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Capacitor;
import gregapi.tileentity.behavior.TE_Behavior_Energy_Stats;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.util.UT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TE_Behavior_Energy_Converter
extends TE_Behavior {
    public TE_Behavior_Energy_Stats mEnergyIN;
    public TE_Behavior_Energy_Stats mEnergyOUT;
    public TE_Behavior_Energy_Capacitor mStorage;
    public boolean mWasteEnergy = false;
    public boolean mLimitConsumption = false;
    public boolean mOverloaded = false;
    public boolean mEmitsEnergy = false;
    public boolean mCanEmitEnergy = false;
    public boolean mSizeIrrelevant = false;
    public boolean mFast = false;
    public long mMultiplier = 1L;
    public byte mFactor = 1;

    public TE_Behavior_Energy_Converter(TileEntity aTileEntity, NBTTagCompound aNBT, TE_Behavior_Energy_Capacitor aStorage, TE_Behavior_Energy_Stats aEnergyIN, TE_Behavior_Energy_Stats aEnergyOUT, long aMultiplier, boolean aWasteEnergy, boolean aNegativeOutput, boolean aLimitConsumption) {
        super(aTileEntity, aNBT);
        this.mStorage = aStorage;
        this.mEnergyIN = aEnergyIN;
        this.mEnergyOUT = aEnergyOUT;
        this.mMultiplier = aMultiplier;
        this.mWasteEnergy = aWasteEnergy;
        this.mSizeIrrelevant = TD.Energy.ALL_SIZE_IRRELEVANT.contains(this.mEnergyOUT.mType);
        boolean bl = this.mLimitConsumption = aLimitConsumption || TD.Energy.ALL_COMSUMPTION_LIMITED.contains(this.mEnergyIN.mType);
        if (aNegativeOutput) {
            this.mFactor = (byte)-1;
        }
    }

    @Override
    public void load(NBTTagCompound aNBT) {
        this.mEmitsEnergy = aNBT.func_74767_n("gt.active.energy");
        this.mCanEmitEnergy = aNBT.func_74767_n("gt.can.energy");
    }

    @Override
    public void save(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.active.energy", this.mEmitsEnergy);
        UT.NBT.setBoolean(aNBT, "gt.can.energy", this.mCanEmitEnergy);
    }

    public boolean doConversion(long aTimer, TileEntity aEmitter, byte aSide, byte aMode, boolean aNegative) {
        long tOutput = UT.Code.units(this.mStorage.mEnergy, this.mEnergyIN.mRec, this.mEnergyOUT.mRec, false);
        if (aMode > 0) {
            tOutput = Math.min(tOutput, UT.Code.units(this.mEnergyOUT.mMax, 16L, 16 - aMode, false));
        }
        this.mCanEmitEnergy = tOutput >= this.mEnergyOUT.mMin;
        this.mFast = tOutput > this.mEnergyOUT.mRec;
        this.mEmitsEnergy = false;
        if (this.mCanEmitEnergy) {
            if (tOutput > this.mEnergyOUT.mMax) {
                if (this.mLimitConsumption) {
                    tOutput = this.mEnergyOUT.mMax;
                } else {
                    if (aTimer > 2L) {
                        this.mOverloaded = true;
                        return true;
                    }
                    CS.DEB.println("Machine overloaded on Chunkload with: " + this.mStorage.mEnergy + " " + this.mEnergyIN.mType.getLocalisedNameLong());
                    this.mStorage.mEnergy = 0L;
                    return true;
                }
            }
            if (this.mSizeIrrelevant) {
                long tEmittedPackets;
                long l = CS.SIDES_VALID[aSide] ? ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSide, aNegative ? -1L : 1L, tOutput * this.mMultiplier, aEmitter) : (tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyOUT.mType, aNegative ? -1L : 1L, tOutput * this.mMultiplier, (ITileEntityEnergy)aEmitter));
                if (tEmittedPackets > 0L) {
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = true;
                }
            } else {
                long tEmittedPackets;
                long l = CS.SIDES_VALID[aSide] ? ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSide, aNegative ? -tOutput * (long)this.mFactor : tOutput * (long)this.mFactor, this.mMultiplier, aEmitter) : (tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mEnergyOUT.mType, aNegative ? -tOutput * (long)this.mFactor : tOutput * (long)this.mFactor, this.mMultiplier, (ITileEntityEnergy)aEmitter));
                if (tEmittedPackets > 0L) {
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = true;
                }
            }
        }
        if (this.mWasteEnergy) {
            this.mStorage.mEnergy = Math.max(0L, this.mStorage.mEnergy - UT.Code.units(this.mEnergyIN.mMax, 16L, 16 - aMode, true));
        }
        return this.mCanEmitEnergy;
    }

    public boolean doBipolar(long aTimer, TileEntity aEmitter, byte aSidePos, byte aSideNeg, byte aMode) {
        long tOutput = UT.Code.units(this.mStorage.mEnergy, this.mEnergyIN.mRec, this.mEnergyOUT.mRec, false);
        if (aMode > 0) {
            tOutput = Math.min(tOutput, UT.Code.units(this.mEnergyOUT.mMax, 16L, 16 - aMode, false));
        }
        this.mCanEmitEnergy = tOutput >= this.mEnergyOUT.mMin;
        this.mFast = tOutput > this.mEnergyOUT.mRec;
        this.mEmitsEnergy = false;
        if (this.mCanEmitEnergy) {
            if (tOutput > this.mEnergyOUT.mMax) {
                if (this.mLimitConsumption) {
                    tOutput = this.mEnergyOUT.mMax;
                } else {
                    if (aTimer > 2L) {
                        this.mOverloaded = true;
                        return true;
                    }
                    CS.DEB.println("Machine overloaded on Chunkload with: " + this.mStorage.mEnergy + " " + this.mEnergyIN.mType.getLocalisedNameLong());
                    this.mStorage.mEnergy = 0L;
                    return true;
                }
            }
            if (this.mSizeIrrelevant) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSidePos, 1L, tOutput * this.mMultiplier, aEmitter);
                if ((tEmittedPackets += ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSideNeg, 1L, -tOutput * this.mMultiplier, aEmitter)) > 0L) {
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = true;
                }
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSidePos, tOutput, this.mMultiplier, aEmitter);
                if ((tEmittedPackets += ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSideNeg, -tOutput, this.mMultiplier, aEmitter)) > 0L) {
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = true;
                }
            }
        }
        if (this.mWasteEnergy) {
            this.mStorage.mEnergy = Math.max(0L, this.mStorage.mEnergy - UT.Code.units(this.mEnergyIN.mMax, 16L, 16 - aMode, true));
        }
        return this.mCanEmitEnergy;
    }

    public boolean doTwinType(long aTimer, TileEntity aEmitter, byte aSide1, byte aSide2, byte aMode, TE_Behavior_Energy_Stats aEnergyOUT) {
        long tOutput = UT.Code.units(this.mStorage.mEnergy, this.mEnergyIN.mRec, this.mEnergyOUT.mRec, false);
        if (aMode > 0) {
            tOutput = Math.min(tOutput, UT.Code.units(this.mEnergyOUT.mMax, 16L, 16 - aMode, false));
        }
        this.mCanEmitEnergy = tOutput >= this.mEnergyOUT.mMin;
        this.mFast = tOutput > this.mEnergyOUT.mRec;
        this.mEmitsEnergy = false;
        if (this.mCanEmitEnergy) {
            if (tOutput > this.mEnergyOUT.mMax) {
                if (this.mLimitConsumption) {
                    tOutput = this.mEnergyOUT.mMax;
                } else {
                    if (aTimer > 2L) {
                        this.mOverloaded = true;
                        return true;
                    }
                    CS.DEB.println("Machine overloaded on Chunkload with: " + this.mStorage.mEnergy + " " + this.mEnergyIN.mType.getLocalisedNameLong());
                    this.mStorage.mEnergy = 0L;
                    return true;
                }
            }
            if (this.mSizeIrrelevant) {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSide1, 1L, tOutput * this.mMultiplier, aEmitter);
                if (!this.mWasteEnergy) {
                    this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L;
                if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyOUT.mType)) {
                    tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(aEnergyOUT.mType, aSide2, 1L, tOutput * this.mMultiplier, aEmitter);
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets, aEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
                } else {
                    tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(aEnergyOUT.mType, aSide2, tOutput * (long)this.mFactor, this.mMultiplier, aEmitter);
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, aEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
                }
            } else {
                long tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(this.mEnergyOUT.mType, aSide1, tOutput * (long)this.mFactor, this.mMultiplier, aEmitter);
                if (!this.mWasteEnergy) {
                    this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, this.mEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                }
                boolean bl = this.mEmitsEnergy = tEmittedPackets > 0L;
                if (TD.Energy.ALL_SIZE_IRRELEVANT.contains(aEnergyOUT.mType)) {
                    tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(aEnergyOUT.mType, aSide2, 1L, tOutput * this.mMultiplier, aEmitter);
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets, aEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
                } else {
                    tEmittedPackets = ITileEntityEnergy.Util.emitEnergyToSide(aEnergyOUT.mType, aSide2, tOutput * (long)this.mFactor, this.mMultiplier, aEmitter);
                    if (!this.mWasteEnergy) {
                        this.mStorage.mEnergy -= UT.Code.units(tEmittedPackets * tOutput, aEnergyOUT.mRec * this.mMultiplier, this.mEnergyIN.mRec, true);
                    }
                    boolean bl2 = this.mEmitsEnergy = tEmittedPackets > 0L || this.mEmitsEnergy;
                }
            }
        }
        if (this.mWasteEnergy) {
            this.mStorage.mEnergy = Math.max(0L, this.mStorage.mEnergy - UT.Code.units(this.mEnergyIN.mMax, 16L, 16 - aMode, true));
        }
        return this.mCanEmitEnergy;
    }
}

