/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.recipes.Recipe;
import gregapi.recipes.maps.RecipeMapSpecialSingleInput;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;

public class RecipeMapCrucible
extends RecipeMapSpecialSingleInput {
    public RecipeMapCrucible(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public List<Recipe> getNEIRecipes(ItemStack ... aOutputs) {
        List<Recipe> rList = super.getNEIRecipes(aOutputs);
        HashSetNoNulls<OreDictMaterial> tSet = new HashSetNoNulls<OreDictMaterial>();
        for (ItemStack aOutput : aOutputs) {
            OreDictItemData aData = OM.anydata(aOutput);
            if (aData == null || !aData.validData() || !aData.mPrefix.contains(TD.Prefix.INGOT_BASED)) continue;
            for (OreDictMaterial tMat : aData.mMaterial.mMaterial.mTargetedSmelting) {
                if (!tSet.add(tMat) || tMat.contains(TD.Properties.INVALID_MATERIAL) || tMat.mTargetSmelting.mMaterial != aData.mMaterial.mMaterial) continue;
                if (tMat != aData.mMaterial.mMaterial) {
                    rList.add(this.getRecipeFor(OP.ingot.mat(tMat, 1L)));
                    rList.add(this.getRecipeFor(OP.blockIngot.mat(tMat, 1L)));
                    rList.add(this.getRecipeFor(OP.gem.mat(tMat, 1L)));
                    rList.add(this.getRecipeFor(OP.blockGem.mat(tMat, 1L)));
                }
                rList.add(this.getRecipeFor(OP.dust.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.blockDust.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.crushed.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.crushedPurified.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.crushedCentrifuged.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.chunk.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.rubble.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.pebbles.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.cluster.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.cleanGravel.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.dirtyGravel.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.crystalline.mat(tMat, 1L)));
                rList.add(this.getRecipeFor(OP.reduced.mat(tMat, 1L)));
            }
        }
        return rList;
    }

    @Override
    public Recipe getRecipeFor(ItemStack aInput) {
        OreDictItemData aData = OM.anydata(aInput);
        if (aData == null) {
            return null;
        }
        ArrayListNoNulls<OreDictMaterialStack> tMaterialList = new ArrayListNoNulls<OreDictMaterialStack>();
        for (OreDictMaterialStack oreDictMaterialStack : aData.getAllMaterialStacks()) {
            if (oreDictMaterialStack.mMaterial.mTargetSmelting.mAmount <= 0L || !oreDictMaterialStack.mMaterial.contains(TD.Processing.MELTING)) continue;
            OM.stack(UT.Code.units(oreDictMaterialStack.mAmount, 648648000L, oreDictMaterialStack.mMaterial.mTargetSmelting.mAmount, false), oreDictMaterialStack.mMaterial.mTargetSmelting.mMaterial).addToList(tMaterialList);
        }
        if (tMaterialList.isEmpty()) {
            return null;
        }
        ArrayListNoNulls<ItemStack> tOutputList = ST.arraylist(new ItemStack[0]);
        for (OreDictMaterialStack tMaterial : tMaterialList) {
            tOutputList.add(OM.ingotOrDust(tMaterial.mMaterial, tMaterial.mAmount));
        }
        ItemStack[] itemStackArray = tOutputList.toArray(CS.ZL_IS);
        if (!ST.hasValid(itemStackArray)) {
            return null;
        }
        return new Recipe(false, false, false, ST.array(ST.amount(1L, aInput)), itemStackArray, null, null, CS.ZL_FS, CS.ZL_FS, 0L, 0L, aData.mMaterial.mMaterial.mMeltingPoint);
    }
}

