/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.gui.Slot_Base;
import gregapi.gui.Slot_Whitelist;
import gregapi.item.IItemGTHandTool;
import gregapi.oredict.OreDictManager;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.recipes.Recipe;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.computer.ITileEntityUSBPort;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapAutocrafting
extends Recipe.RecipeMap {
    public static final List<IRecipe> ALLOWED_RECIPES = new ArrayListNoNulls<IRecipe>();
    public static final List<IRecipe> RECENT_RECIPES = new ArrayListNoNulls<IRecipe>();

    public RecipeMapAutocrafting(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        void var12_19;
        void var12_17;
        int i;
        void var12_14;
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (rRecipe != null || aSpecialSlot == null || aInputs == null || aInputs.length < 1 || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        ItemStack[] tBlueprint = this.getBlueprint(aTileEntity, aSpecialSlot);
        if (tBlueprint.length <= 0) {
            return null;
        }
        for (ItemStack tPlan : tBlueprint) {
            if (tPlan == null || !(tPlan.func_77973_b() instanceof IItemGTHandTool)) continue;
            return null;
        }
        if (ALLOWED_RECIPES.isEmpty()) {
            for (Object e : CR.list()) {
                if (!(e instanceof IRecipe) || e instanceof ICraftingRecipeGT && !((ICraftingRecipeGT)e).isAutocraftableByGT()) continue;
                ALLOWED_RECIPES.add((IRecipe)e);
            }
        }
        InventoryCrafting tCraftInv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        boolean bl = false;
        while (var12_14 < 9) {
            tCraftInv.func_70299_a((int)var12_14, tBlueprint[var12_14]);
            ++var12_14;
        }
        Object var12_15 = null;
        int j = RECENT_RECIPES.size();
        for (i = 0; i < j; ++i) {
            if (!RECENT_RECIPES.get(i).func_77569_a(tCraftInv, (World)(aTileEntity == null ? CS.DW : aTileEntity.getWorld()))) continue;
            IRecipe iRecipe = RECENT_RECIPES.get(i);
            break;
        }
        if (var12_17 == null) {
            j = ALLOWED_RECIPES.size();
            for (i = 0; i < j; ++i) {
                if (!ALLOWED_RECIPES.get(i).func_77569_a(tCraftInv, (World)(aTileEntity == null ? CS.DW : aTileEntity.getWorld()))) continue;
                IRecipe iRecipe = ALLOWED_RECIPES.get(i);
                ALLOWED_RECIPES.remove(i);
                RECENT_RECIPES.add(iRecipe);
                break;
            }
        }
        if (var12_19 == null) {
            return null;
        }
        ItemStack tOutput = var12_19.func_77572_b(tCraftInv);
        if (ST.invalid(tOutput)) {
            return null;
        }
        ArrayListNoNulls<ItemStack> tInputs = ST.arraylist(new ItemStack[0]);
        ArrayListNoNulls<ItemStack> tOutputs = ST.arraylist(tOutput);
        for (ItemStack tPlan : tBlueprint) {
            if (tPlan == null) continue;
            boolean temp = true;
            for (ItemStack tInput : tInputs) {
                if (!ST.equal(tInput, tPlan, false)) continue;
                ++tInput.field_77994_a;
                tOutputs.add(ST.container(tPlan, false));
                temp = false;
            }
            if (!temp) continue;
            tInputs.add(ST.amount(1L, tPlan));
            tOutputs.add(ST.container(tPlan, false));
        }
        for (ItemStack tInput : tInputs) {
            if (!OM.is_("gt:autocrafterinfinite", tInput)) continue;
            tInput.field_77994_a = 0;
        }
        return new Recipe(true, false, true, tInputs.toArray(CS.ZL_IS), tOutputs.toArray(CS.ZL_IS), null, null, null, null, 1024L, 16L, 0L);
    }

    public ItemStack[] getBlueprint(IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        ItemStack[] rBlueprint = CS.ZL_IS;
        if (IL.Paper_Blueprint_Used.equal(aSpecialSlot, false, true)) {
            rBlueprint = UT.NBT.getBlueprintCrafting(aSpecialSlot);
        } else if (OM.is_(CS.OD_USB_STICKS[1], aSpecialSlot)) {
            if (!aSpecialSlot.func_77942_o()) {
                return rBlueprint;
            }
            NBTTagCompound tData = aSpecialSlot.func_77978_p().func_74775_l("gt.usb.data");
            if (tData == null) {
                return rBlueprint;
            }
            rBlueprint = UT.NBT.getBlueprintCrafting(tData);
        } else if (OM.is_(CS.OD_USB_CABLES[1], aSpecialSlot)) {
            if (aTileEntity == null) {
                return rBlueprint;
            }
            for (byte tSide : CS.ALL_SIDES_VALID_ONLY[aSpecialSlot.func_77942_o() && aSpecialSlot.func_77978_p().func_74764_b("gt.usb.dir") ? (int)aSpecialSlot.func_77978_p().func_74771_c("gt.usb.dir") : 6]) {
                NBTTagCompound tData;
                DelegatorTileEntity<TileEntity> tDelegator = aTileEntity.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityUSBPort) || (tData = ((ITileEntityUSBPort)tDelegator.mTileEntity).getUSBData(tDelegator.mSideOfTileEntity, 1)) == null || (rBlueprint = UT.NBT.getBlueprintCrafting(tData)).length <= 0) continue;
                return rBlueprint;
            }
        }
        return rBlueprint;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        ItemStack[] tRecipe;
        for (ItemStack tStack : tRecipe = this.getBlueprint(aTileEntity, aSpecialSlot)) {
            if (!ST.equal(tStack, aStack, false)) continue;
            return true;
        }
        return super.containsInput(aStack, aTileEntity, aSpecialSlot);
    }

    @Override
    public Slot_Base getSpecialSlot(ITileEntityInventoryGUI aInventory, int aIndex, int aX, int aY) {
        return new Slot_Whitelist(aInventory, aIndex, aX, aY, OreDictManager.getOres("gt:autocrafterblueprintitem", false).toArray(CS.ZL_IS)).setTooltip("gt.autocrafting.insert.blueprint", LH.Chat.WHITE);
    }
}

