/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.oredict.OreDictItemData;
import gregapi.recipes.Recipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public interface IRecipeMapHandler {
    public boolean addRecipesUsing(Recipe.RecipeMap var1, boolean var2, ItemStack var3, OreDictItemData var4);

    public boolean addRecipesUsing(Recipe.RecipeMap var1, boolean var2, Fluid var3);

    public boolean addRecipesProducing(Recipe.RecipeMap var1, boolean var2, ItemStack var3, OreDictItemData var4);

    public boolean addRecipesProducing(Recipe.RecipeMap var1, boolean var2, Fluid var3);

    public boolean containsInput(Recipe.RecipeMap var1, ItemStack var2, OreDictItemData var3);

    public boolean containsInput(Recipe.RecipeMap var1, Fluid var2);

    public boolean addAllRecipes(Recipe.RecipeMap var1);

    public boolean isDone();

    public boolean onAddedToMap(Recipe.RecipeMap var1);

    public static abstract class RecipeMapHandler
    implements IRecipeMapHandler {
        @Override
        public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
            return this.addRecipesUsing(aMap, aStack, aData);
        }

        @Override
        public boolean addRecipesUsing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
            return this.addRecipesUsing(aMap, aFluid);
        }

        @Override
        public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, ItemStack aStack, OreDictItemData aData) {
            return this.addRecipesProducing(aMap, aStack, aData);
        }

        @Override
        public boolean addRecipesProducing(Recipe.RecipeMap aMap, boolean aNEI, Fluid aFluid) {
            return this.addRecipesProducing(aMap, aFluid);
        }

        @Override
        public boolean containsInput(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
            return !this.isDone() && this.addRecipesUsing(aMap, false, aStack, aData);
        }

        @Override
        public boolean containsInput(Recipe.RecipeMap aMap, Fluid aFluid) {
            return !this.isDone() && this.addRecipesUsing(aMap, false, aFluid);
        }

        @Override
        public boolean addAllRecipes(Recipe.RecipeMap aMap) {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public boolean onAddedToMap(Recipe.RecipeMap aMap) {
            return true;
        }

        @Deprecated
        public boolean addRecipesUsing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
            return false;
        }

        @Deprecated
        public boolean addRecipesUsing(Recipe.RecipeMap aMap, Fluid aFluid) {
            return false;
        }

        @Deprecated
        public boolean addRecipesProducing(Recipe.RecipeMap aMap, ItemStack aStack, OreDictItemData aData) {
            return false;
        }

        @Deprecated
        public boolean addRecipesProducing(Recipe.RecipeMap aMap, Fluid aFluid) {
            return false;
        }
    }
}

