/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network.packets.covervisuals;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import gregapi.block.IBlockSyncData;
import gregapi.cover.CoverData;
import gregapi.network.INetworkHandler;
import gregapi.network.packets.PacketCoordinates;
import gregapi.network.packets.data.PacketSyncDataByteArray;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;

public class PacketSyncDataByteArrayAndCoverVisuals
extends PacketSyncDataByteArray {
    public short[] mCoverVisuals;
    public boolean[] mVisualsToSync;

    public PacketSyncDataByteArrayAndCoverVisuals(int aDecoderType) {
        super(aDecoderType);
    }

    public PacketSyncDataByteArrayAndCoverVisuals(int aX, int aY, int aZ, byte[] aData, CoverData aCoverData) {
        super(aX, aY, aZ, aData);
        this.mVisualsToSync = aCoverData.mVisualsToSync;
        this.mCoverVisuals = aCoverData.mVisuals;
    }

    public PacketSyncDataByteArrayAndCoverVisuals(ChunkCoordinates aCoords, byte[] aData, CoverData aCoverData) {
        super(aCoords, aData);
        this.mVisualsToSync = aCoverData.mVisualsToSync;
        this.mCoverVisuals = aCoverData.mVisuals;
    }

    private PacketSyncDataByteArrayAndCoverVisuals(int aX, int aY, int aZ, byte[] aData, ByteArrayDataInput aCovers) {
        super(aX, aY, aZ, aData);
        this.mCoverVisuals = new short[]{0, 0, 0, 0, 0, 0};
        this.mVisualsToSync = new boolean[]{false, false, false, false, false, false};
        byte j = aCovers.readByte();
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((j & 1 << i) == 0) continue;
            this.mVisualsToSync[i] = true;
            this.mCoverVisuals[i] = aCovers.readShort();
        }
    }

    @Override
    public byte getPacketIDOffset() {
        return 56;
    }

    @Override
    public ByteArrayDataOutput encode2(ByteArrayDataOutput aData) {
        int i;
        aData = super.encode2(aData);
        int tCoverBits = 0;
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (!this.mVisualsToSync[i]) continue;
            tCoverBits = (byte)(tCoverBits | 1 << i);
        }
        aData.writeByte(tCoverBits);
        for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if (!this.mVisualsToSync[i]) continue;
            aData.writeShort((int)this.mCoverVisuals[i]);
        }
        return aData;
    }

    @Override
    public PacketCoordinates decode2(int aX, int aY, int aZ, ByteArrayDataInput aData) {
        byte[] tData = new byte[UT.Code.unsignB(aData.readByte())];
        aData.readFully(tData);
        return new PacketSyncDataByteArrayAndCoverVisuals(aX, aY, aZ, tData, aData);
    }

    @Override
    public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
        Block tBlock;
        if (aWorld != null && (tBlock = aWorld.func_147439_a(this.mX, this.mY, this.mZ)) instanceof IBlockSyncData.IBlockSyncDataAndCoversAndIDs) {
            ((IBlockSyncData.IBlockSyncDataAndCoversAndIDs)tBlock).receiveDataByteArray(aWorld, this.mX, this.mY, this.mZ, this.mData, aNetworkHandler, this.mCoverVisuals, this.mVisualsToSync);
        }
    }
}

