/*
 * Decompiled with CFR 0.152.
 */
package gregapi.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gregapi.network.INetworkHandler;
import net.minecraft.world.IBlockAccess;

public interface IPacket {
    public byte getPacketID();

    public ByteArrayDataOutput encode();

    public IPacket decode(ByteArrayDataInput var1);

    public void process(IBlockAccess var1, INetworkHandler var2);

    public static final class BasicPacket
    implements IPacket {
        public String mTransmittedData = "TEST";

        @Override
        public byte getPacketID() {
            return 0;
        }

        @Override
        public ByteArrayDataOutput encode() {
            ByteArrayDataOutput tOut = ByteStreams.newDataOutput((int)4);
            tOut.writeUTF(this.mTransmittedData);
            return tOut;
        }

        @Override
        public IPacket decode(ByteArrayDataInput aData) {
            BasicPacket rPacket = new BasicPacket();
            rPacket.mTransmittedData = aData.readUTF();
            return rPacket;
        }

        @Override
        public void process(IBlockAccess aWorld, INetworkHandler aNetworkHandler) {
            System.out.println("We have received: " + this.mTransmittedData);
        }
    }
}

