/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.AbstractCoverDefault;
import gregapi.data.CS;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class CoverTextureSimple
extends AbstractCoverDefault {
    public final ITexture mTexture;
    public final String mSound;

    public CoverTextureSimple(ITexture aTexture) {
        this(aTexture, null);
    }

    public CoverTextureSimple(ITexture aTexture, String aSound) {
        this.mTexture = aTexture;
        this.mSound = aSound;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return this.mTexture;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aPlayer != null) {
            UT.Sounds.send(this.mSound == null ? CS.SFX.GT_SCREWDRIVER : this.mSound, aData.mTileEntity);
        }
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send(this.mSound == null ? "random.break" : this.mSound, 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public boolean isDecorative(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return false;
    }
}

