/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.AbstractCoverDefault;
import gregapi.data.LH;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class CoverTextureCanvas
extends AbstractCoverDefault {
    public final ITexture mTexture;
    public static final ITexture sCanvas = BlockTextureDefault.get("machines/covers/canvas");

    public CoverTextureCanvas(ITexture aTexture) {
        this.mTexture = aTexture;
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aCover != null && aCover.func_77942_o()) {
            aData.visual(aSide, (short)(aCover.func_77978_p().func_74762_e("gt.canvas.block") << 4 | aCover.func_77978_p().func_74762_e("gt.canvas.meta") & 0xF));
        }
        if (aPlayer != null) {
            UT.Sounds.send("dig.cloth", 1.0f, -1.0f, aData.mTileEntity);
        }
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send("dig.cloth", 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (aStack != null && aStack.func_77942_o() && aStack.func_77978_p().func_74764_b("gt.canvas.block")) {
            aList.add(LH.Chat.CYAN + "Block Image: " + ST.names(ST.make(Block.func_149729_e((int)aStack.func_77978_p().func_74762_e("gt.canvas.block")), 1L, (long)(aStack.func_77978_p().func_74762_e("gt.canvas.meta") & 0xF))));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return aData.mVisuals[aSide] == 0 ? null : BlockTextureCopied.get(Block.func_149729_e((int)(aData.mVisuals[aSide] >>> 4 & 0xFFF)), 6, aData.mVisuals[aSide] & 0xF);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? this.mTexture : BlockTextureMulti.get(this.mTexture, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return this.mTexture;
    }

    @Override
    public boolean isSealable(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isDecorative(byte aCoverSide, CoverData aData) {
        return true;
    }
}

