/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentSelector;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class CoverSelectorTag
extends AbstractCoverAttachmentSelector {
    public final byte mMode;
    public static final ITexture[] sTextures = new ITexture[]{BlockTextureDefault.get("machines/covers/selectortag/0", true), BlockTextureDefault.get("machines/covers/selectortag/1", true), BlockTextureDefault.get("machines/covers/selectortag/2", true), BlockTextureDefault.get("machines/covers/selectortag/3", true), BlockTextureDefault.get("machines/covers/selectortag/4", true), BlockTextureDefault.get("machines/covers/selectortag/5", true), BlockTextureDefault.get("machines/covers/selectortag/6", true), BlockTextureDefault.get("machines/covers/selectortag/7", true), BlockTextureDefault.get("machines/covers/selectortag/8", true), BlockTextureDefault.get("machines/covers/selectortag/9", true), BlockTextureDefault.get("machines/covers/selectortag/10", true), BlockTextureDefault.get("machines/covers/selectortag/11", true), BlockTextureDefault.get("machines/covers/selectortag/12", true), BlockTextureDefault.get("machines/covers/selectortag/13", true), BlockTextureDefault.get("machines/covers/selectortag/14", true), BlockTextureDefault.get("machines/covers/selectortag/15", true)};
    public static final ITexture sTexturesBase = BlockTextureDefault.get("machines/covers/selectortag/underlay");

    public CoverSelectorTag(byte aMode) {
        this.mMode = UT.Code.bind4(aMode);
    }

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof ITileEntitySwitchableMode);
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        super.onCoverPlaced(aSide, aData, aPlayer, aCover);
        if (aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            ((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode(this.mMode);
        }
    }

    @Override
    public void onCoverLoaded(byte aSide, CoverData aData) {
        super.onCoverLoaded(aSide, aData);
        if (aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            ((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode(this.mMode);
        }
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            ((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode(this.mMode);
        }
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return BlockTextureMulti.get(sTexturesBase, sTextures[this.mMode]);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }
}

