/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentSelector;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverSelectorButtonPanel
extends AbstractCoverAttachmentSelector {
    public static final ITexture[] sTextures = new ITexture[]{BlockTextureDefault.get("machines/covers/buttonselector/0", false), BlockTextureDefault.get("machines/covers/buttonselector/1", false), BlockTextureDefault.get("machines/covers/buttonselector/2", false), BlockTextureDefault.get("machines/covers/buttonselector/3", false), BlockTextureDefault.get("machines/covers/buttonselector/4", false), BlockTextureDefault.get("machines/covers/buttonselector/5", false), BlockTextureDefault.get("machines/covers/buttonselector/6", false), BlockTextureDefault.get("machines/covers/buttonselector/7", false), BlockTextureDefault.get("machines/covers/buttonselector/8", false), BlockTextureDefault.get("machines/covers/buttonselector/9", false), BlockTextureDefault.get("machines/covers/buttonselector/10", false), BlockTextureDefault.get("machines/covers/buttonselector/11", false), BlockTextureDefault.get("machines/covers/buttonselector/12", false), BlockTextureDefault.get("machines/covers/buttonselector/13", false), BlockTextureDefault.get("machines/covers/buttonselector/14", false), BlockTextureDefault.get("machines/covers/buttonselector/15", false)};
    public static final ITexture[] sTexturesBase = new ITexture[]{BlockTextureDefault.get("machines/covers/buttonselector/underlay", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_0_to_15", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_0_to_F", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_1_to_16", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_16_1_to_15", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_keypad_1_to_9", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_keypad_9_to_1", false), BlockTextureDefault.get("machines/covers/buttonselector/underlay_bits", false)};

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof ITileEntitySwitchableMode);
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        super.onCoverPlaced(aSide, aData, aPlayer, aCover);
        if (aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] & 0xFFFFFFF0 | UT.Code.bind4(((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).getStateMode())));
        }
    }

    @Override
    public void onCoverLoaded(byte aSide, CoverData aData) {
        super.onCoverLoaded(aSide, aData);
        if (aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            ((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode(UT.Code.bind4(aData.mVisuals[aSide] & 0xF));
        }
    }

    @Override
    public void onBlockUpdate(byte aSide, CoverData aData) {
        if (!aData.mStopped && aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] & 0xFFFFFFF0 | UT.Code.bind4(((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).getStateMode())));
        }
    }

    @Override
    public boolean onCoverClickedRight(byte aSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (!aData.mStopped && aSide == aSideClicked && aData.mTileEntity instanceof ITileEntitySwitchableMode) {
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSideClicked, aHitX, aHitY, aHitZ);
            byte tMode = UT.Code.bind4((int)(tCoords[0] * 4.0f) % 4 + (int)(tCoords[1] * 4.0f) % 4 * 4);
            if (aData.mTileEntity.isServerSide()) {
                aData.visual(aSide, (short)(aData.mVisuals[aSide] & 0xFFFFFFF0 | UT.Code.bind4(((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode(tMode))));
            }
            if (aData.mValues[aSide] > 0) {
                aData.value(aSide, (short)10);
            }
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("chisel")) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] + 16 & 0x7F));
            return 100L;
        }
        if (aTool.equals("screwdriver")) {
            aData.value(aSide, (short)(aData.mValues[aSide] <= 0 ? 1 : 0));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mValues[aSide] > 0 ? "Buttons will reset" : "Buttons stay pressed");
            }
            return 10000L;
        }
        return 0L;
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (!aData.mStopped && aIsServerSide) {
            if (aData.mValues[aSide] > 1) {
                aData.value(aSide, (short)(aData.mValues[aSide] - 1));
                if (aData.mValues[aSide] == 1) {
                    ((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).setStateMode((byte)0);
                }
            }
            aData.visual(aSide, (short)(aData.mVisuals[aSide] & 0xFFFFFFF0 | UT.Code.bind4(((ITileEntitySwitchableMode)((Object)aData.mTileEntity)).getStateMode())));
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.chisel.to.switch.design"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return BlockTextureMulti.get(sTexturesBase[aData.mVisuals[aSide] >> 4 & 7], sTextures[UT.Code.bind4(aData.mVisuals[aSide] & 0xF)]);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? sTexturesBase[0] : BlockTextureMulti.get(sTexturesBase[0], this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTexturesBase[0];
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isOpaque(byte aSide, CoverData aData) {
        return true;
    }
}

