/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityPipeItem;
import gregapi.util.ST;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverConveyor
extends AbstractCoverAttachment {
    public final int mTiming;
    public static final ITexture sTextureIn = BlockTextureDefault.get("machines/covers/conveyor/in");
    public static final ITexture sTextureOut = BlockTextureDefault.get("machines/covers/conveyor/out");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IInventory);
    }

    public CoverConveyor(int aTiming) {
        this.mTiming = Math.max(1, aTiming);
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aData.mTileEntity instanceof MultiTileEntityPipeItem) {
            aData.visual(aCoverSide, (short)1);
        }
        super.onCoverPlaced(aCoverSide, aData, aPlayer, aCover);
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aSide, (short)(aData.mVisuals[aSide] == 0 || aData.mTileEntity instanceof MultiTileEntityPipeItem ? 1 : 0));
            return 1000L;
        }
        return 0L;
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && CS.SERVER_TIME % (long)this.mTiming == 0L && !aData.mStopped && aData.mTileEntity instanceof IInventory) {
            if (aData.mVisuals[aSide] == 0) {
                ST.move(aData.delegator(aSide), aData.mTileEntity.getAdjacentTileEntity(aSide));
            } else {
                ST.move(aData.mTileEntity.getAdjacentTileEntity(aSide), aData.delegator(aSide));
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Transfers a Stack every " + (this.mTiming == 1 ? "Tick" : this.mTiming + " Ticks"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureOut : sTextureIn;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return aCoverSide == aTextureSide ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureOut : sTextureIn) : (aCoverSide == CS.OPOS[aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] != 0 ? sTextureOut : sTextureIn) : BACKGROUND_COVER);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide && aData.mVisuals[aSide] == 0;
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide && aData.mVisuals[aSide] != 0;
    }
}

