/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.tileentity.connectors.MultiTileEntityWireRedstoneInsulated;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public abstract class AbstractCoverAttachmentTorch
extends AbstractCoverAttachment {
    public static final float[][] BOXES_TORCHES = new float[][]{{CS.PX_P[7], CS.PX_P[0], CS.PX_P[7], CS.PX_N[7], CS.PX_N[8], CS.PX_N[7]}, {CS.PX_P[7], CS.PX_P[8], CS.PX_P[7], CS.PX_N[7], CS.PX_N[0], CS.PX_N[7]}, {CS.PX_P[7], CS.PX_P[7], CS.PX_P[0], CS.PX_N[7], CS.PX_N[7], CS.PX_N[8]}, {CS.PX_P[7], CS.PX_P[7], CS.PX_P[8], CS.PX_N[7], CS.PX_N[7], CS.PX_N[0]}, {CS.PX_P[0], CS.PX_P[7], CS.PX_P[7], CS.PX_N[8], CS.PX_N[7], CS.PX_N[7]}, {CS.PX_P[8], CS.PX_P[7], CS.PX_P[7], CS.PX_N[0], CS.PX_N[7], CS.PX_N[7]}};

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !(aData.mTileEntity instanceof MultiTileEntityWireRedstoneInsulated);
    }

    @Override
    public boolean interceptConnect(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (((MultiTileEntityWireRedstoneInsulated)aData.mTileEntity).connected(aSide)) {
            ((MultiTileEntityWireRedstoneInsulated)aData.mTileEntity).disconnect(aSide, true);
        }
        if (aPlayer != null) {
            UT.Sounds.send("dig.wood", 1.0f, -1.0f, aData.mTileEntity);
        }
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send("dig.wood", 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public byte getRedstoneOutStrong(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return (byte)(aData.mVisuals[aCoverSide] == 0 ? 15 : 0);
    }

    @Override
    public byte getRedstoneOutWeak(byte aCoverSide, CoverData aData, byte aDefaultRedstone) {
        return (byte)(aData.mVisuals[aCoverSide] == 0 ? 15 : 0);
    }

    @Override
    public void onTickPost(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && aData.mTileEntity instanceof MultiTileEntityWireRedstoneInsulated) {
            if (this.condition(aSide, aData, aTimer, aIsServerSide, aReceivedBlockUpdate, aReceivedInventoryUpdate)) {
                if (aData.mVisuals[aSide] == 0) {
                    aData.visual(aSide, (short)1, true);
                }
            } else if (aData.mVisuals[aSide] != 0) {
                aData.visual(aSide, (short)0, true);
            }
        }
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean isSolid(byte aSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isOpaque(byte aSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isFullTexture(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public float[] getCoverBounds(byte aCoverSide, CoverData aData) {
        return BOXES_TORCHES[aCoverSide];
    }

    @Override
    public float[] getHolderBounds(byte aCoverSide, CoverData aData) {
        return BOXES_TORCHES[aCoverSide];
    }

    public abstract boolean condition(byte var1, CoverData var2, long var3, boolean var5, boolean var6, boolean var7);
}

