/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

public interface ICondition<O> {
    public static final ICondition<?> TRUE = new True();
    public static final ICondition<?> FALSE = new False();
    public static final ICondition<?> NULL = new Null();
    public static final ICondition<?> NOTNULL = new NotNull();

    public boolean isTrue(O var1);

    public static class NotNull<O>
    implements ICondition<O> {
        NotNull() {
        }

        @Override
        public boolean isTrue(O aObject) {
            return aObject != null;
        }
    }

    public static class Null<O>
    implements ICondition<O> {
        Null() {
        }

        @Override
        public boolean isTrue(O aObject) {
            return aObject == null;
        }
    }

    public static class False<O>
    implements ICondition<O> {
        False() {
        }

        @Override
        public boolean isTrue(O aObject) {
            return false;
        }
    }

    public static class True<O>
    implements ICondition<O> {
        True() {
        }

        @Override
        public boolean isTrue(O aObject) {
            return true;
        }
    }

    public static class Equal<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition1;
        private final ICondition<O> mCondition2;
        public final Not<O> NOT = new Not(this);

        public Equal(ICondition<O> aCondition1, ICondition<O> aCondition2) {
            this.mCondition1 = aCondition1;
            this.mCondition2 = aCondition2;
        }

        @Override
        public boolean isTrue(O aObject) {
            return this.mCondition1.isTrue(aObject) == this.mCondition2.isTrue(aObject);
        }
    }

    public static class Xor<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition1;
        private final ICondition<O> mCondition2;
        public final Not<O> NOT = new Not(this);

        public Xor(ICondition<O> aCondition1, ICondition<O> aCondition2) {
            this.mCondition1 = aCondition1;
            this.mCondition2 = aCondition2;
        }

        @Override
        public boolean isTrue(O aObject) {
            return this.mCondition1.isTrue(aObject) != this.mCondition2.isTrue(aObject);
        }
    }

    public static class Nand<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;
        public final Not<O> NOT = new Not(this);

        @SafeVarargs
        public Nand(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (tCondition.isTrue(aObject)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;
        public final Not<O> NOT = new Not(this);

        @SafeVarargs
        public And(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (tCondition.isTrue(aObject)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Nor<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;
        public final Not<O> NOT = new Not(this);

        @SafeVarargs
        public Nor(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (!tCondition.isTrue(aObject)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Or<O>
    implements ICondition<O> {
        private final ICondition<O>[] mConditions;
        public final Not<O> NOT = new Not(this);

        @SafeVarargs
        public Or(ICondition<O> ... aConditions) {
            this.mConditions = aConditions;
        }

        @Override
        public boolean isTrue(O aObject) {
            for (ICondition<O> tCondition : this.mConditions) {
                if (!tCondition.isTrue(aObject)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Not<O>
    implements ICondition<O> {
        private final ICondition<O> mCondition;

        public Not(ICondition<O> aCondition) {
            this.mCondition = aCondition;
        }

        @Override
        public boolean isTrue(O aObject) {
            return !this.mCondition.isTrue(aObject);
        }
    }
}

