/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.tree;

import cpw.mods.fml.common.Optional;
import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.TerrainGen;

@Optional.InterfaceList(value={@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock", modid="GalacticraftCore")})
public abstract class BlockBaseSapling
extends BlockBaseMeta
implements IPlantable,
IGrowable,
IOxygenReliantBlock {
    public BlockBaseSapling(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType, long aMaxMeta, IIconContainer[] aIcons) {
        super(aItemClass, aNameInternal, aMaterial, aSoundType, Math.min(8L, aMaxMeta), aIcons);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("forester", ST.make(this, 1L, 32767L));
        }
    }

    public abstract boolean grow(World var1, int var2, int var3, int var4, byte var5, Random var6);

    @Override
    public String getHarvestTool(int aMeta) {
        return "sword";
    }

    @Override
    public int func_149692_a(int aMeta) {
        return aMeta & 7;
    }

    @Override
    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7;
    }

    @Override
    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150345_g.func_149712_f(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.field_150345_g.func_149638_a(null);
    }

    @Override
    public boolean checkNoEntityCollision(World aWorld, int aX, int aY, int aZ, byte aMeta, Entity aExceptThisOne) {
        return true;
    }

    @Override
    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return false;
    }

    @Override
    public int func_149717_k() {
        return 1;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.treeSapling.mDefaultStackSize);
    }

    @Override
    public IIcon func_149691_a(int aSide, int aMeta) {
        return this.mIcons[aMeta & 0xF].getIcon(0);
    }

    public boolean func_149718_j(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY - 1, aZ).canSustainPlant((IBlockAccess)aWorld, aX, aY - 1, aZ, ForgeDirection.UP, (IPlantable)Blocks.field_150345_g);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        return null;
    }

    public int func_149645_b() {
        return 1;
    }

    public void onOxygenAdded(World aWorld, int aX, int aY, int aZ) {
    }

    public void onOxygenRemoved(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.field_72995_K && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150330_I, 0, 3);
            return;
        }
    }

    @Override
    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.field_72995_K && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150330_I, 0, 3);
            return;
        }
    }

    @Override
    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (!aWorld.field_72995_K && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150330_I, 0, 3);
            return;
        }
        if (aWorld.field_72995_K || this.checkAndDropBlock(aWorld, aX, aY, aZ) || aWorld.func_72957_l(aX, aY + 1, aZ) < 9 || aRandom.nextInt(7) != 0) {
            return;
        }
        this.tryGrow(aWorld, aX, aY, aZ, aRandom);
    }

    public boolean tryGrow(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (!aWorld.field_72995_K && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)Blocks.field_150330_I, 0, 3);
            return false;
        }
        if (CS.TREE_GROWTH_TIME > 1 && CS.RNGSUS.nextInt(CS.TREE_GROWTH_TIME) > 0) {
            return false;
        }
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aMeta < 8) {
            aWorld.func_72921_c(aX, aY, aZ, aMeta | 8, 2);
            return false;
        }
        return TerrainGen.saplingGrowTree((World)aWorld, (Random)aRandom, (int)aX, (int)aY, (int)aZ) && this.grow(aWorld, aX, aY, aZ, aMeta, aRandom);
    }

    public int getMaxHeight(World aWorld, int aX, int aY, int aZ, int aMaxTreeHeight) {
        --aMaxTreeHeight;
        int rMaxHeight = 0;
        while (rMaxHeight++ < aMaxTreeHeight) {
            if (aY + rMaxHeight < aWorld.func_72800_K() && this.canPlaceTree(aWorld, aX, aY + rMaxHeight, aZ)) continue;
            return rMaxHeight - 1;
        }
        return rMaxHeight;
    }

    public boolean placeTree(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMeta) {
        return this.canPlaceTree(aWorld, aX, aY, aZ) && WD.set(aWorld, aX, aY, aZ, aBlock, (long)aMeta, 3L);
    }

    public boolean canPlaceTree(World aWorld, int aX, int aY, int aZ) {
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        return tBlock == this || tBlock instanceof BlockTallGrass || tBlock instanceof BlockSnow || tBlock instanceof BlockLeavesBase || tBlock.canBeReplacedByLeaves((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public boolean func_149742_c(World aWorld, int aX, int aY, int aZ) {
        return super.func_149742_c(aWorld, aX, aY, aZ) && this.func_149718_j(aWorld, aX, aY, aZ);
    }

    @Override
    public void onNeighborBlockChange2(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        this.checkAndDropBlock(aWorld, aX, aY, aZ);
    }

    public boolean checkAndDropBlock(World aWorld, int aX, int aY, int aZ) {
        if (this.func_149718_j(aWorld, aX, aY, aZ)) {
            return false;
        }
        this.func_149697_b(aWorld, aX, aY, aZ, WD.meta((IBlockAccess)aWorld, aX, aY, aZ), 0);
        aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.meta(aWorld, aX, aY, aZ);
    }

    public boolean func_149851_a(World aWorld, int aX, int aY, int aZ, boolean aIsRemote) {
        return true;
    }

    public boolean func_149852_a(World aWorld, Random aRandom, int aX, int aY, int aZ) {
        return (double)aRandom.nextFloat() < 0.45;
    }

    public void func_149853_b(World aWorld, Random aRandom, int aX, int aY, int aZ) {
        this.tryGrow(aWorld, aX, aY, aZ, aRandom);
    }
}

