/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.misc;

import gregapi.block.BlockBaseSealable;
import gregapi.block.ItemBlockBase;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockBaseBars
extends BlockBaseSealable
implements IRenderedBlock {
    public final OreDictMaterial mMat;
    public BarRendererBase[] mRenderers = new BarRendererBase[16];

    public BlockBaseBars(String aNameInternal, OreDictMaterial aMat, Material aVanillaMaterial, Block.SoundType aSoundType) {
        super(null, aNameInternal, aVanillaMaterial, aSoundType);
        this.func_149647_a(CreativeTabs.field_78028_d);
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
        this.mMat = aMat;
        CR.shaped(ST.make(this, 3L, 0L), CR.DEF_REV_NCC_MIR, "BBB", aVanillaMaterial == Material.field_151575_d ? "r v" : "h w", "BBB", 'B', (Object)OP.stick.dat(this.mMat));
        if (CS.CODE_CLIENT) {
            this.mRenderers[0] = new BarRendererItem(aMat);
            this.mRenderers[1] = new BarRenderer(aMat, 1);
            this.mRenderers[2] = new BarRenderer(aMat, 2);
            this.mRenderers[3] = new BarRenderer(aMat, 3);
            this.mRenderers[4] = new BarRenderer(aMat, 4);
            this.mRenderers[5] = new BarRenderer(aMat, 5);
            this.mRenderers[6] = new BarRenderer(aMat, 6);
            this.mRenderers[7] = new BarRenderer(aMat, 7);
            this.mRenderers[8] = new BarRenderer(aMat, 8);
            this.mRenderers[9] = new BarRenderer(aMat, 9);
            this.mRenderers[10] = new BarRenderer(aMat, 10);
            this.mRenderers[11] = new BarRenderer(aMat, 11);
            this.mRenderers[12] = new BarRenderer(aMat, 12);
            this.mRenderers[13] = new BarRenderer(aMat, 13);
            this.mRenderers[14] = new BarRenderer(aMat, 14);
            this.mRenderers[15] = new BarRenderer(aMat, 15);
        }
    }

    @Override
    public boolean onItemUseFirst(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        Block aBlock;
        if (aStack.field_77994_a == 0 || aWorld.field_72995_K) {
            return false;
        }
        if (!aPlayer.func_70093_af()) {
            for (int i = 0; i < 2; ++i) {
                if (i == 1) {
                    aX += CS.OFFX[aSide];
                    aY += CS.OFFY[aSide];
                    aZ += CS.OFFZ[aSide];
                }
                if (!aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack)) {
                    return false;
                }
                Block aBlock2 = WD.block((IBlockAccess)aWorld, aX, aY, aZ);
                byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
                if (aBlock2 != this) continue;
                byte tMeta = (byte)(CS.FACE_CONNECTION_COUNT[aMeta] == 3 ? 15 - aMeta : (aHitX < aHitZ ? (aHitX + aHitZ < 1.0f ? 4 : 2) : (aHitX + aHitZ < 1.0f ? 1 : 8)));
                if ((aMeta & tMeta) != 0 || CS.SIDES_HORIZONTAL[aSide]) {
                    tMeta = (byte)(CS.SIDES_AXIS_X[aSide] ? ((double)aHitZ < 0.5 ? 1 : 2) : ((double)aHitX < 0.5 ? 4 : 8));
                }
                if ((aMeta & tMeta) != 0 && CS.SIDES_HORIZONTAL[aSide]) {
                    tMeta = (byte)(CS.SBIT[aSide] >> 2);
                }
                if ((aMeta & tMeta) == 0 && tMeta != 0) {
                    if (WD.set(aWorld, aX, aY, aZ, (Block)this, (long)(aMeta | tMeta), 3L)) {
                        aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, this.field_149762_H.func_150496_b(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
                        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                            --aStack.field_77994_a;
                        }
                    }
                    return true;
                }
                if (aMeta == 15) continue;
                return false;
            }
            aX -= CS.OFFX[aSide];
            aY -= CS.OFFY[aSide];
            aZ -= CS.OFFZ[aSide];
        }
        if ((aBlock = WD.block((IBlockAccess)aWorld, aX, aY, aZ)) == Blocks.field_150431_aC && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (aBlock != Blocks.field_150395_bd && aBlock != Blocks.field_150329_H && aBlock != Blocks.field_150330_I && !aBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aBlock = WD.block((IBlockAccess)aWorld, aX += CS.OFFX[aSide], aY += CS.OFFY[aSide], aZ += CS.OFFZ[aSide]);
        }
        if (!aBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        int n = CS.SIDES_HORIZONTAL[aSide] ? (CS.SIDES_AXIS_X[aSide] ? ((double)aHitZ < 0.5 ? 1 : 2) : ((double)aHitX < 0.5 ? 4 : 8)) : (aHitX < aHitZ ? (aHitX + aHitZ < 1.0f ? 4 : 2) : (aHitX + aHitZ < 1.0f ? 1 : 8));
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, n)) {
            aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, this.field_149762_H.func_150496_b(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return this.func_149688_o() == Material.field_151575_d ? "axe" : "pickaxe";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return this.mMat.mToolQuality;
    }

    @Override
    public int func_149717_k() {
        return 0;
    }

    @Override
    public int func_149692_a(int aMeta) {
        return 0;
    }

    @Override
    public int quantityDropped(int aMeta, int aFortune, Random aRandom) {
        return aMeta == 0 ? 1 : CS.FACE_CONNECTION_COUNT[aMeta];
    }

    @Override
    public byte maxMeta() {
        return 1;
    }

    @Override
    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return 5.0f;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 5.0f;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return true;
    }

    public void func_149666_a(Item aItem, CreativeTabs aTab, List aList) {
        aList.add(ST.make(aItem, 1L, 0L));
    }

    public ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return ST.make(this, 1L, 0L);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        return null;
    }

    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        for (Object tEntity : aWorld.field_72996_f) {
            if (!(tEntity instanceof EntityPlayer) || !ST.equal(((EntityPlayer)tEntity).func_71045_bC(), this) || !(((EntityPlayer)tEntity).func_70092_e((double)aX, (double)aY, (double)aZ) <= 25.0)) continue;
            return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
        }
        switch (WD.meta((IBlockAccess)aWorld, aX, aY, aZ)) {
            case 1: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)((float)aZ + CS.PX_P[1]));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)((float)aZ + CS.PX_P[15]), (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)((float)aX + CS.PX_P[1]), (double)(aY + 1), (double)(aZ + 1));
            }
            case 8: {
                return AxisAlignedBB.func_72330_a((double)((float)aX + CS.PX_P[15]), (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
            }
        }
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    public void func_149719_a(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld instanceof World) {
            for (Object tEntity : ((World)aWorld).field_72996_f) {
                if (!(tEntity instanceof EntityPlayer) || !ST.equal(((EntityPlayer)tEntity).func_71045_bC(), this) || !(((EntityPlayer)tEntity).func_70092_e((double)aX, (double)aY, (double)aZ) <= 25.0)) continue;
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
        }
        switch (WD.meta(aWorld, aX, aY, aZ)) {
            case 1: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, CS.PX_P[1]);
                return;
            }
            case 2: {
                this.func_149676_a(0.0f, 0.0f, CS.PX_P[15], 1.0f, 1.0f, 1.0f);
                return;
            }
            case 4: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, CS.PX_P[1], 1.0f, 1.0f);
                return;
            }
            case 8: {
                this.func_149676_a(CS.PX_P[15], 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB aAABB, List aList, Entity aEntity) {
        AxisAlignedBB tBox;
        if (aEntity instanceof EntityItem || aEntity instanceof EntityXPOrb || aEntity instanceof IProjectile) {
            return;
        }
        byte tMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if ((tMeta & 1) != 0 && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)((float)aZ + CS.PX_P[2])))) {
            aList.add(tBox);
        }
        if ((tMeta & 2) != 0 && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)((float)aZ + CS.PX_P[14]), (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)))) {
            aList.add(tBox);
        }
        if ((tMeta & 4) != 0 && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)((float)aX + CS.PX_P[2]), (double)(aY + 1), (double)(aZ + 1)))) {
            aList.add(tBox);
        }
        if ((tMeta & 8) != 0 && aAABB.func_72326_a(tBox = AxisAlignedBB.func_72330_a((double)((float)aX + CS.PX_P[14]), (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)))) {
            aList.add(tBox);
        }
    }

    public int func_149645_b() {
        return RendererBlockTextured.INSTANCE == null ? 23 : RendererBlockTextured.INSTANCE.mRenderID;
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        return Blocks.field_150411_aY.func_149691_a(2, 0);
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return null;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return null;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 0;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.mRenderers[0];
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mRenderers[WD.meta(aWorld, aX, aY, aZ)];
    }

    public static class BarRenderer
    extends BarRendererBase {
        public byte mMeta;

        public BarRenderer(OreDictMaterial aMat, int aMeta) {
            super(aMat);
            this.mMeta = (byte)aMeta;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
            switch (aRenderPass) {
                default: {
                    return (this.mMeta & 5) != 0;
                }
                case 1: {
                    return (this.mMeta & 9) != 0;
                }
                case 2: {
                    return (this.mMeta & 6) != 0;
                }
                case 3: {
                    return (this.mMeta & 0xA) != 0;
                }
                case 4: 
                case 8: 
                case 12: 
                case 16: {
                    return (this.mMeta & 1) != 0;
                }
                case 5: 
                case 9: 
                case 13: 
                case 17: {
                    return (this.mMeta & 4) != 0;
                }
                case 6: 
                case 10: 
                case 14: 
                case 18: {
                    return (this.mMeta & 2) != 0;
                }
                case 7: 
                case 11: 
                case 15: 
                case 19: 
            }
            return (this.mMeta & 8) != 0;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            switch (aRenderPass) {
                default: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_P[1], CS.PX_P[16], CS.PX_P[1]);
                    return true;
                }
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[0], CS.PX_P[0], CS.PX_P[16], CS.PX_P[16], CS.PX_P[1]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[15], CS.PX_P[1], CS.PX_P[16], CS.PX_P[16]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[0], CS.PX_P[15], CS.PX_P[16], CS.PX_P[16], CS.PX_P[16]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[0], CS.PX_P[0], CS.PX_P[15], CS.PX_P[1], CS.PX_P[1]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_P[15]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[0], CS.PX_P[15], CS.PX_P[15], CS.PX_P[1], CS.PX_P[16]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[0], CS.PX_P[1], CS.PX_P[16], CS.PX_P[1], CS.PX_P[15]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[15], CS.PX_P[0], CS.PX_P[15], CS.PX_P[16], CS.PX_P[1]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[15], CS.PX_P[1], CS.PX_P[1], CS.PX_P[16], CS.PX_P[15]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[15], CS.PX_P[15], CS.PX_P[15], CS.PX_P[16], CS.PX_P[16]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[15], CS.PX_P[1], CS.PX_P[16], CS.PX_P[16], CS.PX_P[15]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[1], CS.PX_P[0], CS.PX_P[6], CS.PX_P[15], CS.PX_P[1]);
                    return true;
                }
                case 13: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[1], CS.PX_P[5], CS.PX_P[1], CS.PX_P[15], CS.PX_P[6]);
                    return true;
                }
                case 14: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[1], CS.PX_P[15], CS.PX_P[6], CS.PX_P[15], CS.PX_P[16]);
                    return true;
                }
                case 15: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[1], CS.PX_P[5], CS.PX_P[16], CS.PX_P[15], CS.PX_P[6]);
                    return true;
                }
                case 16: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[1], CS.PX_P[0], CS.PX_P[11], CS.PX_P[15], CS.PX_P[1]);
                    return true;
                }
                case 17: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[1], CS.PX_P[10], CS.PX_P[1], CS.PX_P[15], CS.PX_P[11]);
                    return true;
                }
                case 18: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[1], CS.PX_P[15], CS.PX_P[11], CS.PX_P[15], CS.PX_P[16]);
                    return true;
                }
                case 19: 
            }
            aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[1], CS.PX_P[10], CS.PX_P[16], CS.PX_P[15], CS.PX_P[11]);
            return true;
        }
    }

    public static class BarRendererItem
    extends BarRendererBase {
        public BarRendererItem(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
            return 6;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            switch (aRenderPass) {
                default: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[7], CS.PX_P[1], CS.PX_P[16], CS.PX_P[8]);
                    return true;
                }
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[15], CS.PX_P[0], CS.PX_P[7], CS.PX_P[16], CS.PX_P[16], CS.PX_P[8]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[0], CS.PX_P[7], CS.PX_P[15], CS.PX_P[1], CS.PX_P[8]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[15], CS.PX_P[7], CS.PX_P[15], CS.PX_P[16], CS.PX_P[8]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[1], CS.PX_P[7], CS.PX_P[6], CS.PX_P[15], CS.PX_P[8]);
                    return true;
                }
                case 5: 
            }
            aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[1], CS.PX_P[7], CS.PX_P[11], CS.PX_P[15], CS.PX_P[8]);
            return true;
        }
    }

    public static abstract class BarRendererBase
    implements IRenderedBlockObject {
        public ITexture mTexture;

        public BarRendererBase(OreDictMaterial aMat) {
            this.mTexture = aMat.getTextureSmooth();
        }

        @Override
        public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
            return 20;
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return this.mTexture;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
            return true;
        }

        @Override
        public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
            return false;
        }

        @Override
        public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
            return false;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
            return this;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
            return this;
        }
    }
}

