/*
 * Decompiled with CFR 0.152.
 */
package gregapi.api;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import gregapi.api.Abstract_Proxy;
import gregapi.code.ArrayListNoNulls;
import gregapi.compat.ICompat;
import gregapi.data.CS;
import gregapi.util.CR;
import gregapi.util.UT;
import java.util.List;

public abstract class Abstract_Mod {
    public static final List<Abstract_Mod> MODS_USING_GT_API = new ArrayListNoNulls<Abstract_Mod>();
    public static int sModCountUsingGTAPI = 0;
    public static int sStartedPreInit = 0;
    public static int sFinishedPreInit = 0;
    public static int sStartedInit = 0;
    public static int sFinishedInit = 0;
    public static int sStartedPostInit = 0;
    public static int sFinishedPostInit = 0;
    public static int sFinalized = 0;
    public static final List<Runnable> sConfigs = new ArrayListNoNulls<Runnable>();
    public Abstract_Proxy mProxy;
    public boolean mStartedPreInit = false;
    public boolean mFinishedPreInit = false;
    public boolean mStartedInit = false;
    public boolean mFinishedInit = false;
    public boolean mStartedPostInit = false;
    public boolean mFinishedPostInit = false;
    public boolean mFinalized = false;
    public int mStartedServerStarting = 0;
    public int mFinishedServerStarting = 0;
    public int mStartedServerStarted = 0;
    public int mFinishedServerStarted = 0;
    public int mStartedServerStopping = 0;
    public int mFinishedServerStopping = 0;
    public int mStartedServerStopped = 0;
    public int mFinishedServerStopped = 0;
    public List<Runnable> mBeforePreInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mAfterPreInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mBeforeInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mAfterInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mBeforePostInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mAfterPostInit = new ArrayListNoNulls<Runnable>();
    public List<Runnable> mFinalize = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mBeforeServerStarting = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mAfterServerStarting = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mBeforeServerStarted = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mAfterServerStarted = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mBeforeServerStopping = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mAfterServerStopping = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mBeforeServerStopped = new ArrayListNoNulls<Runnable>();
    public final List<Runnable> mAfterServerStopped = new ArrayListNoNulls<Runnable>();
    public final List<ICompat> mCompatClasses = new ArrayListNoNulls<ICompat>();

    public Abstract_Mod() {
        ++sModCountUsingGTAPI;
        MODS_USING_GT_API.add(this);
    }

    public abstract String getModID();

    public abstract String getModName();

    public abstract String getModNameForLog();

    public abstract Abstract_Proxy getProxy();

    public abstract void onModPreInit2(FMLPreInitializationEvent var1);

    public abstract void onModInit2(FMLInitializationEvent var1);

    public abstract void onModPostInit2(FMLPostInitializationEvent var1);

    public abstract void onModServerStarting2(FMLServerStartingEvent var1);

    public abstract void onModServerStarted2(FMLServerStartedEvent var1);

    public abstract void onModServerStopping2(FMLServerStoppingEvent var1);

    public abstract void onModServerStopped2(FMLServerStoppedEvent var1);

    public void onModFinalPreInit(FMLPreInitializationEvent aEvent) {
    }

    public void onModFinalInit(FMLInitializationEvent aEvent) {
    }

    public void onModFinalPostInit(FMLPostInitializationEvent aEvent) {
    }

    public String toString() {
        return this.getModID();
    }

    public void loadRunnables(String aName, List<Runnable> aList) {
        if (aList.isEmpty()) {
            return;
        }
        UT.LoadingBar.start(aName, aList.size());
        for (Runnable tRunnable : aList) {
            String tString = tRunnable.toString();
            UT.LoadingBar.step(UT.Code.stringValid(tString) ? tString : "UNNAMED");
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        UT.LoadingBar.finish();
    }

    public void loadRunnables(List<Runnable> aList) {
        for (Runnable tRunnable : aList) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    public void onModPreInit(FMLPreInitializationEvent aEvent) {
        if (this.mStartedPreInit) {
            return;
        }
        try {
            this.mProxy = this.getProxy();
            CS.OUT.println(this.getModNameForLog() + ": ======================");
            CS.ORD.println(this.getModNameForLog() + ": ======================");
            this.loadRunnables("Before PreInit", this.mBeforePreInit);
            this.mBeforePreInit.clear();
            this.mBeforePreInit = null;
            CS.OUT.println(this.getModNameForLog() + ": PreInit-Phase started!");
            CS.ORD.println(this.getModNameForLog() + ": PreInit-Phase started!");
            this.mStartedPreInit = true;
            ++sStartedPreInit;
            if (this.mProxy != null) {
                this.mProxy.onProxyBeforePreInit(this, aEvent);
            }
            this.onModPreInit2(aEvent);
            if (this.mProxy != null) {
                this.mProxy.onProxyAfterPreInit(this, aEvent);
            }
            ++sFinishedPreInit;
            this.mFinishedPreInit = true;
            CS.OUT.println(this.getModNameForLog() + ": PreInit-Phase finished!");
            CS.ORD.println(this.getModNameForLog() + ": PreInit-Phase finished!");
            if (!this.mCompatClasses.isEmpty()) {
                UT.LoadingBar.start("Loading Compat (PreInit)", this.mCompatClasses.size());
                for (ICompat tCompat : this.mCompatClasses) {
                    String tString = tCompat.toString();
                    UT.LoadingBar.step(UT.Code.stringValid(tString) ? tString : "UNNAMED");
                    try {
                        tCompat.onPreLoad(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                UT.LoadingBar.finish();
            }
            this.loadRunnables("After PreInit", this.mAfterPreInit);
            this.mAfterPreInit.clear();
            this.mAfterPreInit = null;
            this.loadRunnables("Saving Configs", sConfigs);
            if (sFinishedPreInit >= sModCountUsingGTAPI) {
                for (Abstract_Mod tMod : MODS_USING_GT_API) {
                    try {
                        tMod.onModFinalPreInit(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
            }
            CS.OUT.println(this.getModNameForLog() + ": =======================");
            CS.ORD.println(this.getModNameForLog() + ": =======================");
        }
        catch (Throwable e) {
            this.loadRunnables("Saving Configs after Exception!", sConfigs);
            e.printStackTrace(CS.ERR);
            throw new RuntimeException(e);
        }
    }

    public void onModInit(FMLInitializationEvent aEvent) {
        if (this.mStartedInit) {
            return;
        }
        try {
            CS.OUT.println(this.getModNameForLog() + ": ===================");
            CS.ORD.println(this.getModNameForLog() + ": ===================");
            this.loadRunnables("Before Init", this.mBeforeInit);
            this.mBeforeInit.clear();
            this.mBeforeInit = null;
            CS.OUT.println(this.getModNameForLog() + ": Init-Phase started!");
            CS.ORD.println(this.getModNameForLog() + ": Init-Phase started!");
            this.mStartedInit = true;
            ++sStartedInit;
            if (this.mProxy != null) {
                this.mProxy.onProxyBeforeInit(this, aEvent);
            }
            this.onModInit2(aEvent);
            if (this.mProxy != null) {
                this.mProxy.onProxyAfterInit(this, aEvent);
            }
            ++sFinishedInit;
            this.mFinishedInit = true;
            CS.OUT.println(this.getModNameForLog() + ": Init-Phase finished!");
            CS.ORD.println(this.getModNameForLog() + ": Init-Phase finished!");
            if (!this.mCompatClasses.isEmpty()) {
                UT.LoadingBar.start("Loading Compat (Init)", this.mCompatClasses.size());
                for (ICompat tCompat : this.mCompatClasses) {
                    String tString = tCompat.toString();
                    UT.LoadingBar.step(UT.Code.stringValid(tString) ? tString : "UNNAMED");
                    try {
                        tCompat.onLoad(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                UT.LoadingBar.finish();
            }
            this.loadRunnables("After Init", this.mAfterInit);
            this.mAfterInit.clear();
            this.mAfterInit = null;
            this.loadRunnables("Saving Configs", sConfigs);
            if (sFinishedInit >= sModCountUsingGTAPI) {
                for (Abstract_Mod tMod : MODS_USING_GT_API) {
                    try {
                        tMod.onModFinalInit(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
            }
            CS.OUT.println(this.getModNameForLog() + ": ====================");
            CS.ORD.println(this.getModNameForLog() + ": ====================");
        }
        catch (Throwable e) {
            this.loadRunnables("Saving Configs after Exception!", sConfigs);
            e.printStackTrace(CS.ERR);
            throw new RuntimeException(e);
        }
    }

    public void onModPostInit(FMLPostInitializationEvent aEvent) {
        if (this.mStartedPostInit) {
            return;
        }
        try {
            CS.OUT.println(this.getModNameForLog() + ": =======================");
            CS.ORD.println(this.getModNameForLog() + ": =======================");
            this.loadRunnables("Before PostInit", this.mBeforePostInit);
            this.mBeforePostInit.clear();
            this.mBeforePostInit = null;
            CS.OUT.println(this.getModNameForLog() + ": PostInit-Phase started!");
            CS.ORD.println(this.getModNameForLog() + ": PostInit-Phase started!");
            this.mStartedPostInit = true;
            ++sStartedPostInit;
            if (this.mProxy != null) {
                this.mProxy.onProxyBeforePostInit(this, aEvent);
            }
            this.onModPostInit2(aEvent);
            if (this.mProxy != null) {
                this.mProxy.onProxyAfterPostInit(this, aEvent);
            }
            ++sFinishedPostInit;
            this.mFinishedPostInit = true;
            CS.OUT.println(this.getModNameForLog() + ": PostInit-Phase finished!");
            CS.ORD.println(this.getModNameForLog() + ": PostInit-Phase finished!");
            if (!this.mCompatClasses.isEmpty()) {
                UT.LoadingBar.start("Loading Compat (PostInit)", this.mCompatClasses.size());
                for (ICompat tCompat : this.mCompatClasses) {
                    String tString = tCompat.toString();
                    UT.LoadingBar.step(UT.Code.stringValid(tString) ? tString : "UNNAMED");
                    try {
                        tCompat.onPostLoad(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                UT.LoadingBar.finish();
            }
            this.loadRunnables("After PostInit", this.mAfterPostInit);
            this.mAfterPostInit.clear();
            this.mAfterPostInit = null;
            this.loadRunnables("Finalize", this.mFinalize);
            this.mFinalize.clear();
            this.mFinalize = null;
            if (sFinishedPostInit >= sModCountUsingGTAPI) {
                for (Abstract_Mod tMod : MODS_USING_GT_API) {
                    try {
                        tMod.onModFinalPostInit(aEvent);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
            }
            this.mFinalized = true;
            if (++sFinalized >= sModCountUsingGTAPI) {
                CR.stopBuffering();
            }
            this.loadRunnables("Saving Configs", sConfigs);
            CS.OUT.println(this.getModNameForLog() + ": ========================");
            CS.ORD.println(this.getModNameForLog() + ": ========================");
        }
        catch (Throwable e) {
            this.loadRunnables("Saving Configs after Exception!", sConfigs);
            e.printStackTrace(CS.ERR);
            throw new RuntimeException(e);
        }
    }

    public void onModServerStarting(FMLServerStartingEvent aEvent) {
        this.loadRunnables(this.mBeforeServerStarting);
        ++this.mStartedServerStarting;
        if (this.mProxy != null) {
            this.mProxy.onProxyBeforeServerStarting(this, aEvent);
        }
        this.onModServerStarting2(aEvent);
        for (ICompat tCompat : this.mCompatClasses) {
            try {
                tCompat.onServerStarting(aEvent);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (this.mProxy != null) {
            this.mProxy.onProxyAfterServerStarting(this, aEvent);
        }
        ++this.mFinishedServerStarting;
        this.loadRunnables(this.mAfterServerStarting);
    }

    public void onModServerStarted(FMLServerStartedEvent aEvent) {
        this.loadRunnables(this.mBeforeServerStarted);
        ++this.mStartedServerStarted;
        if (this.mProxy != null) {
            this.mProxy.onProxyBeforeServerStarted(this, aEvent);
        }
        this.onModServerStarted2(aEvent);
        for (ICompat tCompat : this.mCompatClasses) {
            try {
                tCompat.onServerStarted(aEvent);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (this.mProxy != null) {
            this.mProxy.onProxyAfterServerStarted(this, aEvent);
        }
        ++this.mFinishedServerStarted;
        this.loadRunnables(this.mAfterServerStarted);
    }

    public void onModServerStopping(FMLServerStoppingEvent aEvent) {
        this.loadRunnables(this.mBeforeServerStopping);
        ++this.mStartedServerStopping;
        if (this.mProxy != null) {
            this.mProxy.onProxyBeforeServerStopping(this, aEvent);
        }
        this.onModServerStopping2(aEvent);
        for (ICompat tCompat : this.mCompatClasses) {
            try {
                tCompat.onServerStopping(aEvent);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (this.mProxy != null) {
            this.mProxy.onProxyAfterServerStopping(this, aEvent);
        }
        ++this.mFinishedServerStopping;
        this.loadRunnables(this.mAfterServerStopping);
    }

    public void onModServerStopped(FMLServerStoppedEvent aEvent) {
        this.loadRunnables(this.mBeforeServerStopped);
        ++this.mStartedServerStopped;
        if (this.mProxy != null) {
            this.mProxy.onProxyBeforeServerStopped(this, aEvent);
        }
        this.onModServerStopped2(aEvent);
        for (ICompat tCompat : this.mCompatClasses) {
            try {
                tCompat.onServerStopped(aEvent);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (this.mProxy != null) {
            this.mProxy.onProxyAfterServerStopped(this, aEvent);
        }
        ++this.mFinishedServerStopped;
        this.loadRunnables(this.mAfterServerStopped);
    }
}

