/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.StoneLayer;
import gregapi.worldgen.StoneLayerOres;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.NoiseGenerator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class WorldgenStoneLayers
extends WorldgenObject {
    @SafeVarargs
    public WorldgenStoneLayers(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        CS.GENERATE_STONE = this.mEnabled;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (CS.GENERATING_SPECIAL) {
            return false;
        }
        NoiseGenerator tNoise = new NoiseGenerator(aWorld);
        ExtendedBlockStorage[] aStorages = aChunk.func_76587_i();
        int tListSize = StoneLayer.LAYERS.size();
        int tMaxHeight = aChunk.func_76625_h() + 15;
        StoneLayer[] tScan = new StoneLayer[7];
        int tScanMinusOne = tScan.length - 1;
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        Block tLastReplaced = Blocks.field_150348_b;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int tX = aMinX + i;
                int tZ = aMinZ + j;
                BiomeGenBase aBiome = aBiomes[i][j];
                for (int k = 0; k < tScan.length; ++k) {
                    tScan[k] = StoneLayer.LAYERS.get(tNoise.get(tX, k - 2, tZ, tListSize));
                    if (!tScan[k].mNoDeep) continue;
                    tScan[k] = StoneLayer.DEEPSLATE;
                }
                boolean tCanPlaceRocks = false;
                OreDictMaterial tLastRock = MT.STONES.Deepslate;
                OreDictMaterial tLastOre = null;
                for (int tY = 1; tY < tMaxHeight; ++tY) {
                    boolean temp;
                    Block aBlock;
                    ExtendedBlockStorage aStorage = aStorages[tY >> 4];
                    Block block = aBlock = aStorage == null ? CS.NB : aStorage.func_150819_a(i, tY & 0xF, j);
                    assert (aStorage != null);
                    if (aBlock == Blocks.field_150357_h) {
                        tCanPlaceRocks = true;
                    } else if (aBlock == CS.NB) {
                        if (tCanPlaceRocks && aRandom.nextInt(128) == 0) {
                            tRegistry.mBlock.placeBlock(aWorld, tX, tY, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(aRandom.nextBoolean() && tLastOre != null ? tLastOre.mTargetCrushing.mMaterial : tLastRock, 1L)), false, true);
                        }
                        tLastOre = null;
                        tCanPlaceRocks = false;
                    } else if (aBlock == Blocks.field_150348_b || aBlock == Blocks.field_150418_aU && aStorage.func_76665_b(i, tY & 0xF, j) == 0) {
                        tCanPlaceRocks = true;
                        temp = true;
                        if (tScan[5] == tScan[1]) {
                            for (StoneLayerOres tOres : tScan[3].mOres) {
                                if (tOres.mMaterial.mID <= 0 || !tOres.check(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom) || !(tScan[6] == tScan[0] ? tOres.normal(tScan[3], aWorld, tX, tY, tZ, aBiome) : tOres.small(tScan[3], aWorld, tX, tY, tZ, aBiome))) continue;
                                if (tOres.mGenerateIndicators) {
                                    tLastOre = tOres.mMaterial;
                                }
                                temp = false;
                                break;
                            }
                        } else {
                            for (StoneLayerOres tOres : StoneLayer.get(tScan[5], tScan[1])) {
                                if (tOres.mMaterial.mID <= 0 || !tOres.check(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom) || !tOres.set(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom)) continue;
                                if (tOres.mGenerateIndicators) {
                                    tLastOre = tOres.mMaterial;
                                }
                                temp = false;
                                break;
                            }
                        }
                        if (temp && tScan[4] != tScan[2] && tScan[3].mOreSmall != null && !StoneLayer.RANDOM_SMALL_GEM_ORES.isEmpty() && aRandom.nextInt(100) == 0 && tScan[3].mOreSmall.placeBlock(aWorld, tX, tY, tZ, (byte)6, UT.Code.select(MT.Emerald, StoneLayer.RANDOM_SMALL_GEM_ORES).mID, null, false, true)) {
                            temp = false;
                        }
                        if (temp) {
                            tLastRock = tScan[3].mMaterialSurface;
                            if (aBlock != tScan[3].mStone) {
                                aStorage.func_150818_a(i, tY & 0xF, j, tScan[3].mStone);
                                aStorage.func_76654_b(i, tY & 0xF, j, (int)tScan[3].mMetaStone);
                            }
                        }
                    } else if (aBlock == Blocks.field_150347_e) {
                        tCanPlaceRocks = true;
                        if (tScan[3].mCobble != null) {
                            tLastRock = tScan[3].mMaterialSurface;
                            if (aBlock != tScan[3].mCobble) {
                                aStorage.func_150818_a(i, tY & 0xF, j, tScan[3].mCobble);
                                aStorage.func_76654_b(i, tY & 0xF, j, (int)tScan[3].mMetaCobble);
                            }
                        }
                    } else if (aBlock == Blocks.field_150341_Y) {
                        tCanPlaceRocks = true;
                        if (tScan[3].mMossy != null) {
                            tLastRock = tScan[3].mMaterialSurface;
                            if (aBlock != tScan[3].mMossy) {
                                aStorage.func_150818_a(i, tY & 0xF, j, tScan[3].mMossy);
                                aStorage.func_76654_b(i, tY & 0xF, j, (int)tScan[3].mMetaMossy);
                            }
                        }
                    } else if (aBlock instanceof BlockStones) {
                        tCanPlaceRocks = aStorage.func_76665_b(i, tY & 0xF, j) < 3;
                    } else if (aBlock == tLastReplaced || StoneLayer.REPLACEABLE_BLOCKS.contains(aBlock)) {
                        tLastReplaced = aBlock;
                        tCanPlaceRocks = true;
                        temp = true;
                        if (tScan[5] == tScan[1]) {
                            for (StoneLayerOres tOres : tScan[3].mOres) {
                                if (tOres.mMaterial.mID <= 0 || !tOres.check(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom) || !(tScan[6] == tScan[0] ? tOres.normal(tScan[3], aWorld, tX, tY, tZ, aBiome) : tOres.small(tScan[3], aWorld, tX, tY, tZ, aBiome))) continue;
                                if (tOres.mGenerateIndicators) {
                                    tLastOre = tOres.mMaterial;
                                }
                                temp = false;
                                break;
                            }
                        } else {
                            for (StoneLayerOres tOres : StoneLayer.get(tScan[5], tScan[1])) {
                                if (tOres.mMaterial.mID <= 0 || !tOres.check(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom) || !tOres.set(tScan[3], aWorld, tX, tY, tZ, aBiome, aRandom)) continue;
                                if (tOres.mGenerateIndicators) {
                                    tLastOre = tOres.mMaterial;
                                }
                                temp = false;
                                break;
                            }
                        }
                        if (temp && tScan[4] != tScan[2] && tScan[3].mOreSmall != null && !StoneLayer.RANDOM_SMALL_GEM_ORES.isEmpty() && aRandom.nextInt(100) == 0 && tScan[3].mOreSmall.placeBlock(aWorld, tX, tY, tZ, (byte)6, UT.Code.select(MT.Emerald, StoneLayer.RANDOM_SMALL_GEM_ORES).mID, null, false, true)) {
                            temp = false;
                        }
                        if (temp) {
                            tLastRock = tScan[3].mMaterialSurface;
                            if (aBlock != tScan[3].mStone) {
                                aStorage.func_150818_a(i, tY & 0xF, j, tScan[3].mStone);
                                aStorage.func_76654_b(i, tY & 0xF, j, (int)tScan[3].mMetaStone);
                            }
                        }
                    } else if (WD.easyRep(aWorld, tX, tY, tZ, aBlock)) {
                        if (tCanPlaceRocks && !aBlock.func_149688_o().func_76224_d() && aRandom.nextInt(128) == 0) {
                            tRegistry.mBlock.placeBlock(aWorld, tX, tY, tZ, (byte)6, (short)32757, ST.save("gt.value", OP.rockGt.mat(aRandom.nextBoolean() && tLastOre != null ? tLastOre.mTargetCrushing.mMaterial : tLastRock, 1L)), false, true);
                        }
                        tLastOre = null;
                        tCanPlaceRocks = false;
                    } else if (aBlock.func_149662_c()) {
                        tCanPlaceRocks = aBlock.func_149688_o() == Material.field_151571_B || aBlock.func_149688_o() == Material.field_151595_p || aBlock.func_149688_o() == Material.field_151577_b || aBlock.func_149688_o() == Material.field_151578_c;
                    } else {
                        tLastOre = null;
                        tCanPlaceRocks = false;
                    }
                    for (int t = 0; t < tScanMinusOne; ++t) {
                        tScan[t] = tScan[t + 1];
                    }
                    tScan[tScanMinusOne] = StoneLayer.LAYERS.get(tNoise.get(tX, tY - 2 + tScanMinusOne, tZ, tListSize));
                    if (tY - 2 + tScanMinusOne >= 24 || !tScan[tScanMinusOne].mNoDeep) continue;
                    tScan[tScanMinusOne] = StoneLayer.DEEPSLATE;
                }
            }
        }
        return true;
    }

    @Override
    public boolean enabled(World aWorld, int aDimType) {
        return CS.GENERATE_STONE;
    }
}

