/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import twilightforest.TFTreasure;
import twilightforest.TFTreasureTable;

public class TwilightTreasureReplacer
extends TFTreasure {
    public static final HashMap<String, TwilightTreasureReplacer> TWILIGHT_TREASURE = new HashMap();
    public static TwilightTreasureReplacer HILLS_2;
    public final TFTreasure mTreasure;
    public final TFTreasureTable mUseless;
    public final TFTreasureTable mCommon;
    public final TFTreasureTable mUncommon;
    public final TFTreasureTable mRare;
    public final TFTreasureTable mUltrarare;
    public final String mCategory;
    public final String mVanillacategory;
    public final short mChestID;
    public final int mTreasureID;
    public int mRares = 2;
    public int mUncommons = 6;
    public int mCommons = 10;
    public int mVanillas = 6;
    public int mVanillaRNG = 7;
    public int mLootBag = 0;

    public static TFTreasure create(TFTreasure aTreasure, int aIndex, String aCategory, String aVanillacategory, long aChestID) {
        return new TwilightTreasureReplacer(aTreasure, aIndex, aCategory, aVanillacategory, aChestID);
    }

    public TwilightTreasureReplacer(TFTreasure aTreasure, int aIndex, String aCategory, String aVanillacategory, long aChestID) {
        super(aIndex);
        this.mCategory = "twilightforest:" + aCategory;
        this.mVanillacategory = aVanillacategory;
        this.mChestID = (short)aChestID;
        this.mTreasureID = aIndex;
        this.mTreasure = aTreasure;
        this.mUseless = this.useless = (TFTreasureTable)UT.Reflection.getFieldContent(this.mTreasure, "useless", true, true);
        this.mCommon = this.common = (TFTreasureTable)UT.Reflection.getFieldContent(this.mTreasure, "common", true, true);
        this.mUncommon = this.uncommon = (TFTreasureTable)UT.Reflection.getFieldContent(this.mTreasure, "uncommon", true, true);
        this.mRare = this.rare = (TFTreasureTable)UT.Reflection.getFieldContent(this.mTreasure, "rare", true, true);
        this.mUltrarare = this.ultrarare = (TFTreasureTable)UT.Reflection.getFieldContent(this.mTreasure, "ultrarare", true, true);
        if (aIndex == 1) {
            this.mLootBag = 0;
        }
        if (aIndex == 2) {
            this.mLootBag = 0;
            HILLS_2 = this;
            this.rare.add(OP.stick.mat(MT.Basalz, 4L));
        }
        if (aIndex == 3) {
            this.mLootBag = 1;
        }
        if (aIndex == 4) {
            ItemStack tStack;
            this.mLootBag = 0;
            if (MD.ChocoCraft.mLoaded && ST.valid(tStack = ST.make(MD.ChocoCraft, "gysahlGreenBlock", 4L, 0L))) {
                this.useless.add(tStack);
            }
            if (MD.HaC.mLoaded) {
                tStack = ST.make(MD.HaC, "tropicalgarden", 4L, 0L);
                if (ST.valid(tStack)) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "watergarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "herbgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "grassgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "textilegarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "groundgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "berrygarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "mushroomgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "leafygarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "desertgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "stalkgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
                if (ST.valid(tStack = ST.make(MD.HaC, "gourdgarden", 4L, 0L))) {
                    this.useless.add(tStack);
                }
            }
            this.uncommon.add(IL.Dye_Cocoa.get(4L, new Object[0]));
            this.uncommon.add(IL.Resin.get(24L, new Object[0]));
            this.uncommon.add(IL.Food_Cinnamon.get(12L, new Object[0]));
            this.uncommon.add(IL.Bag_Loot_Seeds.get(1L, new Object[0]));
            this.rare.add(Items.field_151057_cb, 4);
            this.rare.add(Items.field_151058_ca, 2);
            this.rare.add(IL.Bag_Loot_Seeds.get(4L, new Object[0]));
            this.rare.add(OP.stick.mat(MT.Breeze, 4L));
        }
        if (aIndex == 5) {
            this.mLootBag = 1;
        }
        if (aIndex == 6) {
            this.mLootBag = 0;
        }
        if (aIndex == 7) {
            this.mLootBag = 1;
            this.mVanillas = 3;
            this.mVanillaRNG = 3;
            this.useless.clear();
            this.useless.add(Items.field_151075_bm, 12);
            this.useless.add(Items.field_151128_bU, 48);
            this.useless.add(Blocks.field_150425_aM, 24);
            this.useless.add(Blocks.field_150424_aL, 36);
            if (IL.EtFu_Magmatic_Netherrack.exists()) {
                this.useless.add(IL.EtFu_Magmatic_Netherrack.get(24L, new Object[0]));
            }
        }
        if (aIndex == 8) {
            this.mLootBag = 1;
            this.useless.clear();
            this.useless.add(IL.Dye_SquidInk.get(36L, new Object[0]));
            this.useless.add(IL.Bottle_Ink.get(16L, new Object[0]));
            this.useless.add(Items.field_151008_G, 8);
            this.useless.add(FL.Potion_NightVision_1L.fill(IL.Porcelain_Cup.get(1L, new Object[0])));
            this.useless.add(IL.Food_Pickle.get(8L, new Object[0]));
            this.rare.add(ST.book("Manual_Portal_TF"));
            this.ultrarare.add(IL.Compass_Death.get(1L, new Object[0]));
        }
        if (aIndex == 9) {
            this.mLootBag = 1;
            this.mRares = 3;
            this.mVanillas = 3;
            this.mVanillaRNG = 3;
            this.rare.add(ST.book("Manual_Portal_TF"));
            this.rare.add(IL.Bag_Loot_Misc.get(4L, new Object[0]));
        }
        if (aIndex == 10) {
            this.mLootBag = 2;
            this.mRares = 4;
            this.rare.add(IL.Bag_Loot_Gems.get(8L, new Object[0]));
        }
        if (aIndex == 11) {
            this.mLootBag = 1;
            this.useless.clear();
            this.useless.add(Items.field_151128_bU, 48);
            this.useless.add(Blocks.field_150377_bs, 36);
            if (IL.EtFu_Magmatic_Netherrack.exists()) {
                this.useless.add(IL.EtFu_Magmatic_Netherrack.get(24L, new Object[0]));
            }
        }
        if (aIndex == 12) {
            this.mLootBag = 2;
            if (MD.AE.mLoaded) {
                this.useless.add(OP.gem.mat(MT.CertusQuartz, 48L));
                this.useless.add(OP.gem.mat(MT.ChargedCertusQuartz, 8L));
                this.useless.add(OP.rockGt.mat(MT.STONES.SkyStone, 48L));
            }
            this.useless.add(Items.field_151079_bi, 4);
        }
        if (aIndex == 13) {
            this.mLootBag = 2;
            this.mVanillas = 3;
            this.mVanillaRNG = 3;
            this.mCommons = 8;
            this.mUncommons = 27;
            this.mRares = 1;
        }
        if (aIndex == 14) {
            this.mLootBag = 0;
            this.mRares = 4;
            if (IL.TC_Greatwood_Sapling.exists()) {
                this.rare.add(IL.TC_Greatwood_Sapling.get(4L, new Object[0]));
            }
            if (IL.TC_Silverwood_Sapling.exists()) {
                this.ultrarare.add(IL.TC_Silverwood_Sapling.get(1L, new Object[0]));
            }
            this.useless.add(IL.Bag_Loot_Sapling.get(4L, new Object[0]));
            this.uncommon.add(IL.Bag_Loot_Sapling.get(8L, new Object[0]));
        }
        if (aIndex == 15) {
            this.mLootBag = 0;
        }
        if (aIndex == 16) {
            this.mLootBag = 1;
        }
        if (aIndex == 17) {
            this.mLootBag = 2;
        }
        if (aIndex == 18) {
            this.mLootBag = 1;
        }
        if (aIndex == 19) {
            this.mLootBag = 2;
        }
        if (aIndex == 21) {
            this.mLootBag = 2;
            this.mRares = 1;
            this.useless.add(Items.field_151079_bi, 16);
            this.useless.add(Blocks.field_150377_bs, 64);
            if (IL.EtFu_Chorus_Fruit.exists()) {
                this.useless.add(IL.EtFu_Chorus_Fruit.get(24L, new Object[0]));
            }
            if (IL.EtFu_Chorus_Flower.exists()) {
                this.uncommon.add(IL.EtFu_Chorus_Flower.get(8L, new Object[0]));
            }
            this.uncommon.add(OP.stick.mat(MT.Blitz, 4L));
        }
        if (aIndex == 22) {
            this.mLootBag = 2;
            this.mRares = 1;
            this.mUncommons = 12;
            if (IL.EtFu_Dragon_Breath.exists()) {
                this.useless.add(IL.EtFu_Dragon_Breath.get(36L, new Object[0]));
            }
            this.useless.add(IL.Ancient_Debris.get(1L, OP.crushed.mat(MT.AncientDebris, 2L)));
            this.common.add(IL.Ancient_Debris.get(2L, OP.crushed.mat(MT.AncientDebris, 4L)));
            this.uncommon.add(IL.Ancient_Debris.get(4L, OP.crushed.mat(MT.AncientDebris, 8L)));
            this.uncommon.add(ST.make(Items.field_151144_bL, 2L, 1L));
        }
        TWILIGHT_TREASURE.put(this.mCategory, this);
        ST.LOOT_TABLES.add(this.mCategory);
    }

    public boolean generate(World aWorld, Random aRandom, int aX, int aY, int aZ) {
        return this.generate(aWorld, aRandom, aX, aY, aZ, (Block)Blocks.field_150486_ae);
    }

    public boolean generate(World aWorld, Random aRandom, int aX, int aY, int aZ, Block aChest) {
        if (this.mTreasureID == 3 && CS.RNGSUS.nextInt(3) == 0) {
            return HILLS_2.generate(aWorld, aRandom, aX, aY, aZ, aChest);
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return super.generate(aWorld, aRandom, aX, aY, aZ, aChest);
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL_ORDER.length)]) {
            Block tBlock = WD.block(aWorld, aX, aY, aZ, tSide);
            if (tBlock != Blocks.field_150486_ae && tBlock != Blocks.field_150447_bR) continue;
            WD.set(aWorld, aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide], IL.TF_Firefly_Jar.block(), 0L, 3L);
            for (byte tFace : CS.SIDES_AXIS_Z[tSide] ? CS.ALL_SIDES_X : CS.ALL_SIDES_Z) {
                if (!WD.opq(aWorld, aX + CS.OFFX[tFace], aY, aZ + CS.OFFZ[tFace], true, true)) continue;
                return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)CS.OPOS[tFace], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
            }
            for (byte tFace : CS.SIDES_AXIS_Z[tSide] ? CS.ALL_SIDES_X : CS.ALL_SIDES_Z) {
                if (!WD.opq(aWorld, aX + CS.OFFX[tFace] * 2, aY, aZ + CS.OFFZ[tFace] * 2, true, true)) continue;
                return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)CS.OPOS[tFace], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
            }
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)(CS.SIDES_AXIS_Z[tSide] ? CS.ALL_SIDES_X : CS.ALL_SIDES_Z)[CS.RNGSUS.nextInt(2)], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL_ORDER.length)]) {
            if (!WD.air(aWorld, aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide])) continue;
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)tSide, "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL_ORDER.length)]) {
            if (!WD.opq(aWorld, aX + CS.OFFX[tSide], aY, aZ + CS.OFFZ[tSide], true, true)) continue;
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)CS.OPOS[tSide], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL_ORDER.length)]) {
            if (!WD.opq(aWorld, aX + CS.OFFX[tSide] * 2, aY, aZ + CS.OFFZ[tSide] * 2, true, true)) continue;
            return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)CS.OPOS[tSide], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
        }
        return tRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, this.mChestID, UT.NBT.make("gt.facing", (Object)CS.ALL_SIDES_HORIZONTAL[CS.RNGSUS.nextInt(CS.ALL_SIDES_HORIZONTAL.length)], "gt.trapped", true, "gt.dungeonloot", this.mCategory), false, true);
    }

    public static boolean generate(IInventory aInventory, String aCategory) {
        TwilightTreasureReplacer tTreasure = TWILIGHT_TREASURE.get(aCategory);
        return tTreasure != null && tTreasure.generate(aInventory);
    }

    public boolean generate(IInventory aInventory) {
        int i;
        boolean rReturn = true;
        for (i = 0; i < this.mRares; ++i) {
            rReturn &= this.addToInventory(aInventory, this.mTreasure.getRareItem(CS.RNGSUS));
        }
        for (i = 0; i < this.mUncommons; ++i) {
            rReturn &= this.addToInventory(aInventory, this.mTreasure.getUncommonItem(CS.RNGSUS));
        }
        for (i = 0; i < this.mCommons; ++i) {
            rReturn &= this.addToInventory(aInventory, this.mTreasure.getCommonItem(CS.RNGSUS));
        }
        rReturn &= this.addToInventory(aInventory, IL.TC_LOOT_BAGS[this.mLootBag].get(1L, new Object[0]));
        if (UT.Code.stringValid(this.mVanillacategory)) {
            int j = this.mVanillas + CS.RNGSUS.nextInt(this.mVanillaRNG);
            for (i = 0; i < j; ++i) {
                rReturn &= this.addToInventory(aInventory, ChestGenHooks.getOneItem((String)this.mVanillacategory, (Random)CS.RNGSUS));
            }
        }
        return rReturn;
    }

    public boolean addToInventory(IInventory aInventory, ItemStack aStack) {
        int tSlot = this.findEmptySlot(aInventory);
        if (tSlot == -1) {
            return false;
        }
        aInventory.func_70299_a(tSlot, IL.TF_Uncrafting.equal(aStack, true, true) ? IL.TF_Transformation_Powder.get(12 + CS.RNGSUS.nextInt(13), new Object[0]) : (ST.item(aStack) == Items.field_151068_bn ? IL.Bottle_Loot.get(1 + CS.RNGSUS.nextInt(2), new Object[0]) : aStack));
        return true;
    }

    public int findEmptySlot(IInventory aInventory) {
        int i;
        int j = aInventory.func_70302_i_();
        for (i = 0; i < 100; ++i) {
            int k = CS.RNGSUS.nextInt(j);
            if (aInventory.func_70301_a(k) != null) continue;
            return k;
        }
        for (i = 0; i < j; ++i) {
            if (aInventory.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }
}

