/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityRope
extends TileEntityBase09FacingSingle
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_IsLadder,
IMultiTileEntity.IMTE_OnBlockHarvested,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public static IIconContainer sColored = new Textures.BlockIcons.CustomIcon("machines/tools/rope/colored");
    public static IIconContainer sOverlay = new Textures.BlockIcons.CustomIcon("machines/tools/rope/overlay");

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ItemStack aStack = aPlayer.func_71045_bC();
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        if (tRegistry != null && ST.equal(aStack, this.toStack(), false)) {
            if (this.isServerSide()) {
                for (int tY = this.field_145848_d - 1; tY >= 0; --tY) {
                    TileEntity tTileEntity = this.getTileEntity(this.field_145851_c, tY, this.field_145849_e);
                    if (tTileEntity instanceof MultiTileEntityRope) {
                        if (((MultiTileEntityRope)tTileEntity).getMultiTileEntityRegistryID() != this.getMultiTileEntityRegistryID()) {
                            return true;
                        }
                        if (((MultiTileEntityRope)tTileEntity).getMultiTileEntityID() != this.getMultiTileEntityID()) {
                            return true;
                        }
                        if (((MultiTileEntityRope)tTileEntity).mFacing == this.mFacing) continue;
                        return true;
                    }
                    if (WD.air(this.field_145850_b, this.field_145851_c, tY, this.field_145849_e)) {
                        tRegistry.mBlock.placeBlock(this.field_145850_b, this.field_145851_c, tY, this.field_145849_e, (byte)6, this.getMultiTileEntityID(), UT.NBT.make(aStack.func_77942_o() ? (NBTTagCompound)aStack.func_77978_p().func_74737_b() : null, "gt.facing", this.mFacing), true, false);
                        if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                            --aStack.field_77994_a;
                        }
                        UT.Sounds.send("dig.cloth", this, false);
                    }
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockHarvested(int aMetaData, EntityPlayer aPlayer) {
        TileEntity tTileEntity;
        if (this.isServerSide() && aPlayer != null && !((tTileEntity = this.getTileEntityAtSideAndDistance((byte)1, 1)) instanceof MultiTileEntityRope)) {
            for (int tY = this.field_145848_d - 1; tY >= 0 && (tTileEntity = this.getTileEntity(this.field_145851_c, tY, this.field_145849_e)) instanceof MultiTileEntityRope && ((MultiTileEntityRope)tTileEntity).mFacing == this.mFacing && ((MultiTileEntityRope)tTileEntity).getMultiTileEntityRegistryID() == this.getMultiTileEntityRegistryID() && ((MultiTileEntityRope)tTileEntity).getMultiTileEntityID() == this.getMultiTileEntityID(); --tY) {
                ((MultiTileEntityRope)tTileEntity).popOff((Entity)aPlayer);
            }
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (!(!aIsServerSide || !this.mBlockUpdated && aTimer != 1L || WD.opq(this.field_145850_b, this.getOffsetX(this.mFacing), this.getOffsetY(this.mFacing), this.getOffsetZ(this.mFacing), false, true) || WD.opq(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, false, true) || this.getTileEntityAtSideAndDistance((byte)1, 1) instanceof MultiTileEntityRope)) {
            this.popOff();
        }
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return this.mFacing == 0 ? 2 : 1;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 3: {
                        return this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[12], CS.PX_N[6], CS.PX_N[0], CS.PX_N[0]);
                    }
                    case 2: {
                        return this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[0], CS.PX_N[6], CS.PX_N[0], CS.PX_N[12]);
                    }
                    case 5: {
                        return this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[6], CS.PX_N[0], CS.PX_N[0], CS.PX_N[6]);
                    }
                    case 4: {
                        return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[6], CS.PX_N[12], CS.PX_N[0], CS.PX_N[6]);
                    }
                    case 1: {
                        return this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[0], CS.PX_N[6]);
                    }
                    case 0: {
                        return this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
                    }
                }
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[4], CS.PX_P[4], CS.PX_P[4], CS.PX_N[4], CS.PX_N[8], CS.PX_N[4]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return BlockTextureMulti.get(BlockTextureDefault.get(sColored, this.mRGBa), BlockTextureDefault.get(sOverlay));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 3: {
                return this.box(CS.PX_P[7], CS.PX_P[0], CS.PX_P[12], CS.PX_N[7], CS.PX_N[0], CS.PX_N[2]);
            }
            case 2: {
                return this.box(CS.PX_P[7], CS.PX_P[0], CS.PX_P[2], CS.PX_N[7], CS.PX_N[0], CS.PX_N[12]);
            }
            case 5: {
                return this.box(CS.PX_P[12], CS.PX_P[0], CS.PX_P[7], CS.PX_N[2], CS.PX_N[0], CS.PX_N[7]);
            }
            case 4: {
                return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[7], CS.PX_N[12], CS.PX_N[0], CS.PX_N[7]);
            }
            case 1: {
                return this.box(CS.PX_P[7], CS.PX_P[0], CS.PX_P[7], CS.PX_N[7], CS.PX_N[0], CS.PX_N[7]);
            }
            case 0: {
                return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
            }
        }
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 3: {
                return this.box(CS.PX_P[6], CS.PX_P[0], CS.PX_P[12], CS.PX_N[6], CS.PX_N[0], CS.PX_N[0]);
            }
            case 2: {
                return this.box(CS.PX_P[6], CS.PX_P[0], CS.PX_P[0], CS.PX_N[6], CS.PX_N[0], CS.PX_N[12]);
            }
            case 5: {
                return this.box(CS.PX_P[12], CS.PX_P[0], CS.PX_P[6], CS.PX_N[0], CS.PX_N[0], CS.PX_N[6]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[6], CS.PX_N[12], CS.PX_N[0], CS.PX_N[6]);
            }
            case 1: {
                return this.box(CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[0], CS.PX_N[6]);
            }
            case 0: {
                return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
            }
        }
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 3: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[12], CS.PX_N[6], CS.PX_N[0], CS.PX_N[0]);
                return;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[0], CS.PX_N[6], CS.PX_N[0], CS.PX_N[12]);
                return;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[6], CS.PX_N[0], CS.PX_N[0], CS.PX_N[6]);
                return;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[6], CS.PX_N[12], CS.PX_N[0], CS.PX_N[6]);
                return;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[0], CS.PX_N[6]);
                return;
            }
            case 0: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
                return;
            }
        }
        this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[8], CS.PX_N[2]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean isLadder(EntityLivingBase aEntity) {
        return true;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return true;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public byte getDefaultSide() {
        return 0;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getFacingTool() {
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.rope";
    }
}

