/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.ANY;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.RM;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityMortar
extends TileEntityBase07Paintable
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected Recipe.RecipeMap mRecipes = RM.Mortar;
    protected Recipe mLastRecipe = null;
    public byte mStyle = 0;
    public static final OreDictMaterial[] MORTAR_MATERIALS = new OreDictMaterial[]{ANY.Steel, MT.Netherite, ANY.Sapphire, ANY.Diamond, ANY.Amethyst};
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/bottom");
    public static IIconContainer sTextureMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/middletop");
    public static IIconContainer sTextureMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/colored/middleside");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/bottom");
    public static IIconContainer sOverlayMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/middletop");
    public static IIconContainer sOverlayMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/mortar/overlay/middleside");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        if (aNBT.func_74764_b("gt.design")) {
            this.mStyle = aNBT.func_74771_c("gt.design");
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mortar.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide()) {
            float[] tCoords2;
            ItemStack aStack = aPlayer.func_71045_bC();
            if (CS.SIDES_TOP[aSide] && (tCoords2 = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PX_P[4] && tCoords2[1] <= CS.PX_P[4]) {
                return true;
            }
            if (!UT.Entities.isPlayer(aPlayer)) {
                return true;
            }
            Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, CS.V[1], CS.NI, CS.ZL_FS, aStack);
            if (tRecipe != null) {
                if (tRecipe.mCanBeBuffered) {
                    this.mLastRecipe = tRecipe;
                }
                if (tRecipe.isRecipeInputEqual(true, false, CS.ZL_FS, aStack)) {
                    for (ItemStack tStack : tRecipe.getOutputs()) {
                        ST.give((Entity)aPlayer, tStack, true);
                    }
                    UT.Entities.exhaust(aPlayer, (float)tRecipe.getAbsoluteTotalPower() / 250.0f);
                    UT.Sounds.send("dig.stone", this, false);
                    return true;
                }
            }
        } else if (CS.SIDES_TOP[aSide] && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PX_P[4] && tCoords[1] <= CS.PX_P[4]) {
            this.mRecipes.openNEI();
            return true;
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[10], CS.PX_N[2]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[12]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[12], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[15], CS.PX_N[2]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[7], CS.PX_N[6]);
                return true;
            }
            case 6: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[10] + 0.001f, CS.PX_N[12]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return 5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 2: {
                return 4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 1: {
                return 3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 3: {
                return 2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 4: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa), BlockTextureDefault.get(sOverlayBottom)) : null);
            }
            case 5: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleTop, MultiTileEntityMortar.MORTAR_MATERIALS[this.mStyle % MultiTileEntityMortar.MORTAR_MATERIALS.length].fRGBaSolid), BlockTextureDefault.get(sOverlayMiddleTop)) : (0 == aSide ? null : BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleSide, MultiTileEntityMortar.MORTAR_MATERIALS[this.mStyle % MultiTileEntityMortar.MORTAR_MATERIALS.length].fRGBaSolid), BlockTextureDefault.get(sOverlayMiddleSide)));
            }
            case 6: {
                return 1 == aSide ? BI.nei() : null;
            }
        }
        return null;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(aAABB, aList, CS.PX_P[12], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[12], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[10], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[12]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[15], CS.PX_N[2]);
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[10], CS.PX_N[2]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_P[10] : CS.PX_P[2];
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.mortar";
    }
}

