/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntityCrucible;
import gregapi.tileentity.machines.ITileEntityMold;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityCrossing
extends TileEntityBase07Paintable
implements ITileEntityCrucible,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public boolean mRedstone = false;
    public long mLock = 0L;
    public static long sLockID = 0L;
    public static boolean sLock = false;
    private ITexture mTexture;

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mLock = 0L;
            if (this.mBlockUpdated || CS.SERVER_TIME % 50L == 0L) {
                if (this.getRedstoneIncoming((byte)1) > 0 || this.getRedstoneIncoming((byte)0) > 0) {
                    if (!this.mRedstone) {
                        this.mRedstone = true;
                        this.causeBlockUpdate();
                    }
                } else if (this.mRedstone) {
                    this.mRedstone = false;
                    this.causeBlockUpdate();
                }
            }
        }
    }

    @Override
    public boolean fillMoldAtSide(ITileEntityMold aMold, byte aSide, byte aSideOfMold) {
        boolean rReturn = false;
        if (sLock) {
            if (this.mLock == sLockID) {
                return false;
            }
            this.mLock = sLockID;
            for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                if (tSide == aSide) continue;
                DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityCrucible) || !((ITileEntityCrucible)tDelegator.mTileEntity).fillMoldAtSide(aMold, tDelegator.mSideOfTileEntity, aSideOfMold)) continue;
                return true;
            }
        } else {
            this.mLock = 0L;
            ++sLockID;
            sLock = true;
            rReturn = this.fillMoldAtSide(aMold, aSide, aSideOfMold);
            sLock = false;
        }
        return rReturn;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTexture = BlockTextureDefault.get(this.mMaterial, OP.blockSolid, UT.Code.getRGBaArray(this.mRGBa), this.mMaterial.contains(TD.Properties.GLOWING));
        return 11;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            default: {
                return this.box(aBlock, CS.PX_P[6], CS.PX_P[1], CS.PX_P[0], CS.PX_N[6], CS.PX_N[14], CS.PX_N[0]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[1], CS.PX_P[6], CS.PX_N[10], CS.PX_N[14], CS.PX_N[6]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[10], CS.PX_P[1], CS.PX_P[6], CS.PX_N[0], CS.PX_N[14], CS.PX_N[6]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[5], CS.PX_P[2], CS.PX_P[0], CS.PX_N[10], CS.PX_N[10], CS.PX_N[11]);
            }
            case 4: {
                return this.box(aBlock, CS.PX_P[5], CS.PX_P[2], CS.PX_P[11], CS.PX_N[10], CS.PX_N[10], CS.PX_N[0]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[5], CS.PX_N[10], CS.PX_N[10], CS.PX_N[10]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[5], CS.PX_N[0], CS.PX_N[10], CS.PX_N[10]);
            }
            case 7: {
                return this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[0], CS.PX_N[5], CS.PX_N[10], CS.PX_N[11]);
            }
            case 8: {
                return this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[11], CS.PX_N[5], CS.PX_N[10], CS.PX_N[0]);
            }
            case 9: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[2], CS.PX_P[10], CS.PX_N[10], CS.PX_N[10], CS.PX_N[5]);
            }
            case 10: 
        }
        return this.box(aBlock, CS.PX_P[10], CS.PX_P[2], CS.PX_P[10], CS.PX_N[0], CS.PX_N[10], CS.PX_N[5]);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return this.mTexture;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[1], CS.PX_P[0], CS.PX_N[0], CS.PX_N[10], CS.PX_N[0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[1], CS.PX_P[0], CS.PX_N[0], CS.PX_N[10], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[1], CS.PX_P[0], CS.PX_N[0], CS.PX_N[10], CS.PX_N[0]);
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (byte)(this.mRedstone && CS.SIDES_HORIZONTAL[aSide] ? 1 : 0);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_P[10] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.smeltery.crossing";
    }
}

