/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.fluid.FluidTankGT;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityTapFillable;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityBathingPot
extends TileEntityBase07Paintable
implements IFluidHandler,
ITileEntityConnectedTank,
ITileEntityTapFillable,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected short mDisplay = 0;
    protected short oDisplay = (short)-1;
    protected Recipe.RecipeMap mRecipes = RM.Bath;
    protected Recipe mLastRecipe = null;
    protected FluidTankGT[] mTanksInput = CS.ZL_FT;
    protected FluidTankGT[] mTanksOutput = CS.ZL_FT;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/bottom");
    public static IIconContainer sTextureTableBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/tablebottom");
    public static IIconContainer sTextureTableSide = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/colored/tableside");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/bottom");
    public static IIconContainer sOverlayTableBottom = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/tablebottom");
    public static IIconContainer sOverlayTableSide = new Textures.BlockIcons.CustomIcon("machines/tools/bathing_pot/overlay/tableside");
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        int tCapacity = 1000;
        if (aNBT.func_74764_b("gt.tankcap")) {
            tCapacity = UT.Code.bindInt(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTanksInput = new FluidTankGT[this.mRecipes.mInputFluidCount];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i] = new FluidTankGT(tCapacity).readFromNBT(aNBT, "gt.tank.in." + i);
        }
        this.mTanksOutput = new FluidTankGT[this.mRecipes.mOutputFluidCount];
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i] = new FluidTankGT(tCapacity).readFromNBT(aNBT, "gt.tank.out." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        for (i = 0; i < this.mTanksInput.length; ++i) {
            this.mTanksInput[i].writeToNBT(aNBT, "gt.tank.in." + i);
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i].writeToNBT(aNBT, "gt.tank.out." + i);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.bathingsink.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            long rAmount;
            this.updateInventory();
            for (FluidTankGT tTank : this.mTanksOutput) {
                rAmount = CS.GarbageGT.trash(tTank, 1000L);
                if (rAmount <= 0L) continue;
                return rAmount;
            }
            for (FluidTankGT tTank : this.mTanksInput) {
                rAmount = CS.GarbageGT.trash(tTank, 1000L);
                if (rAmount <= 0L) continue;
                return rAmount;
            }
            this.updateAdjacentInventories();
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                boolean temp = true;
                for (FluidTankGT tTank : this.mTanksInput) {
                    if (tTank.isEmpty()) continue;
                    temp = false;
                    aChatReturn.add("Input: " + tTank.content());
                }
                for (FluidTankGT tTank : this.mTanksOutput) {
                    if (tTank.isEmpty()) continue;
                    temp = false;
                    aChatReturn.add("Output: " + tTank.content());
                }
                if (temp) {
                    aChatReturn.add("Contains no Fluids");
                }
            }
            return this.mTanksInput.length + this.mTanksOutput.length;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (CS.SERVER_TIME % 600L == 10L && this.field_145850_b.func_72896_J() && this.getRainOffset(0, 1, 0)) {
                IFluidTank tTank;
                FluidStack tWater;
                Block tInFront;
                BiomeGenBase tBiome = this.getBiome();
                if (tBiome.field_76751_G > 0.0f && (double)tBiome.field_76750_F >= 0.2 && !((tInFront = this.getBlockAtSide((byte)1)) instanceof BlockLiquid) && !(tInFront instanceof IFluidBlock) && !tInFront.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.FORGE_DIR_OPPOSITES[1]) && !tInFront.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.FORGE_DIR[1]) && (tWater = FL.Water.make((long)Math.max(1.0f, tBiome.field_76751_G * 200.0f) * (long)(this.field_145850_b.func_72911_I() ? 2 : 1))) != null && (tTank = this.getFluidTankFillable2((byte)1, tWater)) != null) {
                    tTank.fill(tWater, true);
                }
            }
            boolean tBreak = false;
            this.mDisplay = 0;
            for (FluidTankGT tTank : this.mTanksOutput) {
                if (!tTank.has()) continue;
                this.mDisplay = (short)(-2 - tTank.getFluid().getFluidID());
                tBreak = true;
                break;
            }
            if (!tBreak) {
                for (FluidTankGT tTank : this.mTanksInput) {
                    if (!tTank.has()) continue;
                    this.mDisplay = (short)(-2 - tTank.getFluid().getFluidID());
                    tBreak = true;
                    break;
                }
                if (!tBreak) {
                    for (int i = 0; i < 7; ++i) {
                        ItemStack tStack = this.slot(6 - i);
                        if (!ST.valid(tStack)) continue;
                        OreDictItemData tData = OM.data_(tStack);
                        this.mDisplay = tData == null || tData.mMaterial == null ? (short)-1 : tData.mMaterial.mMaterial.mID;
                        tBreak = true;
                        break;
                    }
                }
            }
        }
    }

    protected boolean canOutput(Recipe aRecipe) {
        int i;
        for (i = 0; i < 6; ++i) {
            if (this.slot(i + 6) == null || !aRecipe.mNeedsEmptyOutput && (aRecipe.mOutputs.length <= 0 || aRecipe.mOutputs[i] == null || ST.equal(this.slot(i + 6), aRecipe.mOutputs[i], false) && this.slot((int)(i + 6)).field_77994_a + aRecipe.mOutputs[i].field_77994_a <= this.slot(i + 6).func_77976_d())) continue;
            return false;
        }
        for (i = 0; i < this.mTanksOutput.length && i < aRecipe.mFluidOutputs.length; ++i) {
            if (!this.mTanksOutput[i].has() || !aRecipe.mNeedsEmptyOutput && (aRecipe.mFluidOutputs[i] == null || this.mTanksOutput[i].contains(aRecipe.mFluidOutputs[i]) && FL.temperature(aRecipe.mFluidOutputs[i]) < this.mMaterial.mMeltingPoint - 100L && !FL.lighter(aRecipe.mFluidOutputs[i]) && !FL.gas(aRecipe.mFluidOutputs[i]) && !this.mTanksOutput[i].has(Math.max(1000, 1 + aRecipe.mFluidOutputs[i].amount)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            if (CS.SIDES_TOP[aSide]) {
                float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
                if (tCoords[0] <= CS.PX_P[2] && tCoords[1] <= CS.PX_P[2]) {
                    return true;
                }
                if (!UT.Entities.isPlayer(aPlayer)) {
                    return true;
                }
                ItemStack[] tInputItems = ST.array(this.slot(0), this.slot(1), this.slot(2), this.slot(3), this.slot(4), this.slot(5));
                Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, CS.V[1], CS.NI, this.mTanksInput, tInputItems);
                if (tRecipe != null) {
                    if (tRecipe.mCanBeBuffered) {
                        this.mLastRecipe = tRecipe;
                    }
                    if (this.canOutput(tRecipe) && tRecipe.isRecipeInputEqual(true, false, this.mTanksInput, tInputItems)) {
                        int i;
                        ItemStack[] tOutputItems = tRecipe.getOutputs();
                        FluidStack[] tOutputFluids = tRecipe.getFluidOutputs();
                        for (i = 0; i < this.mRecipes.mOutputItemsCount && i < tOutputItems.length; ++i) {
                            this.addStackToSlot(i + 6, tOutputItems[i]);
                        }
                        for (i = 0; i < this.mTanksOutput.length && i < tOutputFluids.length; ++i) {
                            this.mTanksOutput[i].fill(tOutputFluids[i], true);
                        }
                        UT.Entities.exhaust(aPlayer, (float)Math.max(1L, tRecipe.getAbsoluteTotalPower()) / 1000.0f);
                        this.removeAllDroppableNullStacks();
                        this.updateInventory();
                        this.updateAdjacentInventories();
                        return true;
                    }
                }
            }
            for (int i = 6; i < 12; ++i) {
                if (!ST.add((Entity)aPlayer, this.slot(i), false)) continue;
                this.playCollect();
                this.slotKill(i);
                return true;
            }
            ItemStack aStack = aPlayer.func_71045_bC();
            ItemStack tStack = ST.container(ST.amount(1L, aStack), true);
            FluidStack tFluid = FL.getFluid(ST.amount(1L, aStack), true);
            if (aStack != null && tFluid != null && FL.fillAll_((IFluidHandler)this, (byte)6, tFluid, true)) {
                --aStack.field_77994_a;
                ST.give((Entity)aPlayer, tStack, true);
                return true;
            }
            if (CS.SIDES_TOP[aSide] && aHitX > CS.PX_P[2] && aHitX < CS.PX_N[2] && aHitZ > CS.PX_P[2] && aHitZ < CS.PX_N[2]) {
                if (aStack != null) {
                    for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                        if (ST.move((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, i) <= 0) continue;
                        return true;
                    }
                }
                if (aStack != null) {
                    for (FluidTankGT tTank : this.mTanksOutput) {
                        tStack = FL.fill(tTank, ST.amount(1L, aStack), true, true, true, true);
                        if (tStack == null) continue;
                        --aStack.field_77994_a;
                        ST.give((Entity)aPlayer, tStack, true);
                        return true;
                    }
                }
                if (aStack != null) {
                    for (FluidTankGT tTank : this.mTanksInput) {
                        tStack = FL.fill(tTank, ST.amount(1L, aStack), true, true, true, true);
                        if (tStack == null) continue;
                        --aStack.field_77994_a;
                        ST.give((Entity)aPlayer, tStack, true);
                        return true;
                    }
                }
            } else {
                if (aStack != null) {
                    for (FluidTankGT tTank : this.mTanksOutput) {
                        tStack = FL.fill(tTank, ST.amount(1L, aStack), true, true, true, true);
                        if (tStack == null) continue;
                        --aStack.field_77994_a;
                        ST.give((Entity)aPlayer, tStack, true);
                        return true;
                    }
                }
                if (aStack != null) {
                    for (FluidTankGT tTank : this.mTanksInput) {
                        tStack = FL.fill(tTank, ST.amount(1L, aStack), true, true, true, true);
                        if (tStack == null) continue;
                        --aStack.field_77994_a;
                        ST.give((Entity)aPlayer, tStack, true);
                        return true;
                    }
                }
                if (aStack != null) {
                    for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                        if (ST.move((IInventory)aPlayer.field_71071_by, this, aPlayer.field_71071_by.field_70461_c, i) <= 0) continue;
                        return true;
                    }
                }
            }
            if (this.slot(6) == null && this.slot(7) == null && this.slot(8) == null && this.slot(9) == null && this.slot(10) == null && this.slot(11) == null) {
                for (int i = 0; i < 6; ++i) {
                    if (!ST.add((Entity)aPlayer, this.slot(i), true)) continue;
                    this.playCollect();
                    this.slotKill(i);
                    return true;
                }
            }
        } else if (CS.SIDES_TOP[aSide]) {
            float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
            if (tCoords[0] <= CS.PX_P[2] && tCoords[1] <= CS.PX_P[2]) {
                this.mRecipes.openNEI();
                return true;
            }
            if (this.mDisplay != 0) {
                if (this.mDisplay < -1) {
                    UT.Sounds.play("liquid.water", 5, 1.0f, 1.0f, this.getCoords());
                } else {
                    UT.Sounds.play("dig.sand", 5, 1.0f, 1.0f, this.getCoords());
                }
            }
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplay != this.oDisplay;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplay = this.mDisplay;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        if (aData.length > 1) {
            this.mDisplay = UT.Code.combine(aData[0], aData[1]);
        }
        if (aData.length > 4) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        int i;
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!this.mTanksInput[i].contains(aFluidToFill)) continue;
            return this.mTanksInput[i];
        }
        if (FL.temperature(aFluidToFill) >= this.mMaterial.mMeltingPoint - 100L || !FL.heavier(aFluidToFill)) {
            return null;
        }
        for (i = 0; i < this.mTanksInput.length; ++i) {
            if (!this.mTanksInput[i].isEmpty()) continue;
            return this.mTanksInput[i];
        }
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                int j = ((int)(CS.SERVER_TIME / 20L) + i) % this.mTanksOutput.length;
                if (!this.mTanksOutput[j].has()) continue;
                return this.mTanksOutput[j];
            }
        } else {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (!this.mTanksOutput[i].contains(aFluidToDrain)) continue;
                return this.mTanksOutput[i];
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        int i;
        IFluidTank[] rTanks = new IFluidTank[this.mTanksInput.length + this.mTanksOutput.length];
        for (i = 0; i < this.mTanksInput.length; ++i) {
            rTanks[i] = this.mTanksInput[i];
        }
        for (i = 0; i < this.mTanksOutput.length; ++i) {
            rTanks[this.mTanksInput.length + i] = this.mTanksOutput[i];
        }
        return rTanks;
    }

    @Override
    public int tapFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return this.fill(CS.FORGE_DIR[aSide], aFluid, aDoFill);
    }

    @Override
    public boolean breakBlock() {
        CS.GarbageGT.trash(this.mTanksInput);
        CS.GarbageGT.trash(this.mTanksOutput);
        return super.breakBlock();
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[8], CS.PX_N[0]);
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[14]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
            }
            case 4: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[9], CS.PX_N[0]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[8] + 0.001f, CS.PX_N[14]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return 5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 2: {
                return 4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 1: {
                return 3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 3: {
                return 2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 4: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa), BlockTextureDefault.get(sOverlayBottom)) : null);
            }
            case 5: {
                if (this.mDisplay == 0 || 1 != aSide) {
                    return null;
                }
                if (this.mDisplay < -1) {
                    Fluid tFluid = FluidRegistry.getFluid((int)(-this.mDisplay - 2));
                    return tFluid == null ? BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false) : BlockTextureFluid.get(FL.make(tFluid, 1000L));
                }
                if (UT.Code.exists(this.mDisplay, OreDictMaterial.MATERIAL_ARRAY)) {
                    return OreDictMaterial.MATERIAL_ARRAY[this.mDisplay].getTextureDust();
                }
                return BlockTextureDefault.get(MT.NULL, OP.blockDust, CS.CA_GRAY_128, false);
            }
            case 6: {
                return 1 == aSide ? BI.nei() : null;
            }
            case 7: {
                return 1 != aSide ? (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTableBottom, this.mRGBa), BlockTextureDefault.get(sOverlayTableBottom)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureTableSide, this.mRGBa), BlockTextureDefault.get(sOverlayTableSide))) : null;
            }
        }
        return null;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(aAABB, aList, CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[8], CS.PX_N[0]);
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[14]);
        this.box(aAABB, aList, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_N[8] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[12];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        if (aSlot >= 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (!ST.equal(aStack, this.slot(i), true)) continue;
            return i == aSlot;
        }
        return this.mRecipes.containsInput(aStack, (IHasWorldAndCoords)this, CS.NI);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot >= 6;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        return 0;
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (aFluid == CS.NF) {
            return 0;
        }
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.contains(aFluid) || !tTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) continue;
            return (int)tTank.remove(aFluid.amount);
        }
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.contains(aFluid) || !tTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) continue;
            return (int)tTank.remove(aFluid.amount);
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        if (aFluid == CS.NF) {
            return 0L;
        }
        long rAmount = 0L;
        for (FluidTankGT tTank : this.mTanksInput) {
            if (!tTank.contains(aFluid)) continue;
            rAmount += tTank.amount();
        }
        for (FluidTankGT tTank : this.mTanksOutput) {
            if (!tTank.contains(aFluid)) continue;
            rAmount += tTank.amount();
        }
        return rAmount;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bathing.pot";
    }
}

