/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.FM;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.UT;
import gregtech.tileentity.multiblocks.MultiTileEntityLargeTurbine;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityLargeTurbineGas
extends MultiTileEntityLargeTurbine {
    public FluidTankGT mInputTank = new FluidTankGT();
    public FluidTankGT[] mTanksOutput = new FluidTankGT[]{new FluidTankGT(), new FluidTankGT(), new FluidTankGT()};
    public FluidTankGT[] mTanks = new FluidTankGT[]{this.mInputTank, this.mTanksOutput[0], this.mTanksOutput[1], this.mTanksOutput[2]};
    public Recipe.RecipeMap mRecipes = FM.Gas;
    public Recipe mLastRecipe = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.fuelmap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.fuelmap"));
        }
        for (int i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i].readFromNBT(aNBT, "gt.tank." + i).setCapacity(this.mEnergyIN.mMax * 16L);
        }
        this.mInputTank.readFromNBT(aNBT, "gt.tank").setCapacity(this.mEnergyIN.mMax * 4L);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        for (int i = 0; i < this.mTanksOutput.length; ++i) {
            this.mTanksOutput[i].writeToNBT(aNBT, "gt.tank." + i);
        }
        this.mInputTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.gasturbine.1") + MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID()).getLocal(this.mTurbineWalls));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.gasturbine.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.gasturbine.3"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.tooltip.multiblock.gasturbine.4"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void addToolTipsEnergy(List<String> aList, ItemStack aStack, boolean aF3_H) {
        this.mEnergyOUT.addToolTips(aList, aStack, aF3_H, null, true);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            if (this.mTanksOutput[0].has()) {
                return CS.GarbageGT.trash(this.mTanksOutput[0]);
            }
            if (this.mTanksOutput[1].has()) {
                return CS.GarbageGT.trash(this.mTanksOutput[1]);
            }
            if (this.mTanksOutput[2].has()) {
                return CS.GarbageGT.trash(this.mTanksOutput[2]);
            }
            return CS.GarbageGT.trash(this.mInputTank);
        }
        return 0L;
    }

    @Override
    public void doConversion(long aTimer) {
        Recipe tRecipe;
        if (this.mStorage.mEnergy >= this.mConverter.mEnergyIN.mMax) {
            long tEnergy = this.mStorage.mEnergy;
            this.mStorage.mEnergy = this.mConverter.mEnergyIN.mMax;
            super.doConversion(aTimer);
            this.mStorage.mEnergy = tEnergy - this.mConverter.mEnergyIN.mMax;
            return;
        }
        if (!this.mStopped && this.mInputTank.has() && this.mTanksOutput[0].underHalf() && this.mTanksOutput[1].underHalf() && this.mTanksOutput[2].underHalf() && (tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, this.mEnergyIN.mMax, CS.NI, this.mInputTank.AS_ARRAY, CS.ZL_IS)) != null) {
            this.mLastRecipe = tRecipe;
            if (tRecipe.mEUt < 0L && tRecipe.mDuration > 0L) {
                int tMax = UT.Code.bindInt(UT.Code.divup(this.mEnergyIN.mMax - this.mStorage.mEnergy, -tRecipe.mEUt * tRecipe.mDuration));
                int tParallel = tRecipe.isRecipeInputEqual(tMax, this.mInputTank.AS_ARRAY, CS.ZL_IS);
                if (tParallel < tMax) {
                    this.mInputTank.setEmpty();
                }
                if (tParallel > 0) {
                    this.mStorage.mEnergy -= (long)tParallel * tRecipe.mEUt * tRecipe.mDuration;
                    for (int i = 0; i < tRecipe.mFluidOutputs.length && i < this.mTanksOutput.length; ++i) {
                        if (this.mTanksOutput[i].fillAll(tRecipe.mFluidOutputs[i], tParallel)) continue;
                        this.mStorage.mEnergy = 0L;
                    }
                    super.doConversion(aTimer);
                    return;
                }
            }
        }
        this.mStorage.mEnergy -= this.mConverter.mEnergyIN.mMax;
        if (this.mStorage.mEnergy < 0L) {
            this.mStorage.mEnergy = 0L;
        }
        super.doConversion(aTimer);
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return !this.mStopped && this.mRecipes.containsInput(aFluidToFill, (IHasWorldAndCoords)this, CS.NI) ? this.mInputTank : null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                int j = ((int)(CS.SERVER_TIME / 20L) + i) % this.mTanksOutput.length;
                if (!this.mTanksOutput[j].has()) continue;
                return this.mTanksOutput[j];
            }
        } else {
            for (int i = 0; i < this.mTanksOutput.length; ++i) {
                if (!this.mTanksOutput[i].contains(aFluidToDrain)) continue;
                return this.mTanksOutput[i];
            }
        }
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.turbine.gas";
    }

    static {
        LH.add("gt.tooltip.multiblock.gasturbine.1", "3x3x4 of 35 ");
        LH.add("gt.tooltip.multiblock.gasturbine.2", "Main centered on the 3x3 facing outwards");
        LH.add("gt.tooltip.multiblock.gasturbine.3", "Input only possible at frontal 3x3");
        LH.add("gt.tooltip.multiblock.gasturbine.4", "Exhaust Gas has to be removed!");
    }
}

