/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.extenders;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Holo;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictPrefix;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.logistics.ITileEntityLogisticsSemiFilteredItem;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.extenders.MultiTileEntityExtender;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityFilterPrefix
extends MultiTileEntityExtender
implements ITileEntityLogisticsSemiFilteredItem {
    public OreDictPrefix mFilter = null;
    public ItemStack mCycle = null;
    public boolean mInverted = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("gt.inverted")) {
            this.mInverted = aNBT.func_74767_n("gt.inverted");
        }
        this.mFilter = OreDictPrefix.sPrefixes.get(aNBT.func_74779_i("gt.invfilter"));
        super.readFromNBT2(aNBT);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.inverted", this.mInverted);
        if (this.mFilter != null) {
            aNBT.func_74778_a("gt.invfilter", this.mFilter.mNameInternal);
        }
        super.writeToNBT2(aNBT);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.inverted", this.mInverted);
        if (this.mFilter != null) {
            aNBT.func_74778_a("gt.invfilter", this.mFilter.mNameInternal);
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && aTimer % 10L == 1L) {
            if (this.mFilter == null || this.mFilter.mRegisteredItems.isEmpty()) {
                this.mCycle = null;
            } else {
                this.mCycle = ST.make(UT.Code.select(null, this.mFilter.mRegisteredItems.toArray(CS.ZL_ISC)), this.mFilter.mNameInternal, null);
                if (this.mCycle != null && ST.meta_(this.mCycle) == Short.MAX_VALUE) {
                    ST.meta_(this.mCycle, 0L);
                }
            }
        }
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        return this.delegator(aSide);
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUIClientFilterPrefix(aPlayer.field_71071_by, this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new MultiTileEntityGUICommonFilterPrefix(aPlayer.field_71071_by, this, aGUIID);
    }

    @Override
    public int getSizeInventoryGUI() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mCycle;
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        return null;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        return null;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.mCycle = aStack;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return 1;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.filter.prefix";
    }

    public boolean allowInput(ItemStack aStack) {
        return this.mFilter != null && this.mFilter.contains(aStack) != this.mInverted;
    }

    public boolean allowInput(FluidStack aFluid) {
        return true;
    }

    public boolean allowInput(Fluid aFluid) {
        return true;
    }

    @Override
    public ItemStackSet<ItemStackContainer> getLogisticsFilter(byte aSide) {
        return this.mInverted || this.mFilter == null ? null : this.mFilter.mRegisteredItems;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("screwdriver")) {
            boolean bl = this.mInverted = !this.mInverted;
            if (aChatReturn != null) {
                aChatReturn.add(this.mInverted ? "Blacklist Filter" : "Whitelist Filter");
            }
            return 2000L;
        }
        if (aTool.equals("softhammer")) {
            this.mInverted = false;
            this.mFilter = null;
            this.mCycle = null;
            if (aChatReturn != null) {
                aChatReturn.add("Cleared the Filter");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mInverted ? "Blacklist Filter" : "Whitelist Filter");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        this.mLastSide = aSide;
        if ((this.mModes & 1) != 0 && ST.valid(aStack) && (this.mLastSide == this.mFacing || this.allowInput(aStack))) {
            DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory(this.getExtenderTargetSide(this.mLastSide), false, true);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102008_b(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean aDoFill) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, aFluid)) {
                return 0;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, FluidStack aFluid, boolean aDoDrain) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, aFluid)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aFluid, aDoDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int aToDrain, boolean aDoDrain) {
        if ((this.mModes & 2) != 0) {
            byte aSide = UT.Code.side(aDirection);
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, null)) {
                return null;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return aSide == this.mFacing || this.allowInput(((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, false)) ? ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), aToDrain, aDoDrain) : null;
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection aDirection, Fluid aFluid) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidFill(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection aDirection, Fluid aFluid) {
        byte aSide = UT.Code.side(aDirection);
        if ((this.mModes & 2) != 0 && (aSide == this.mFacing || this.allowInput(aFluid))) {
            if (this.hasCovers() && CS.SIDES_VALID[aSide] && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptFluidDrain(aSide, this.mCovers, aSide, FL.make(aFluid, 1L))) {
                return false;
            }
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.getAdjacentTank(this.getExtenderTargetSide(aSide), false, true);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), aFluid);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientFilterPrefix
    extends ContainerClient {
        public MultiTileEntityGUIClientFilterPrefix(InventoryPlayer aInventoryPlayer, MultiTileEntityFilterPrefix aTileEntity, int aGUIID) {
            super(new MultiTileEntityGUICommonFilterPrefix(aInventoryPlayer, aTileEntity, aGUIID), CS.RES_PATH_GUI + "machines/FilterPrefix.png");
        }
    }

    public class MultiTileEntityGUICommonFilterPrefix
    extends ContainerCommon {
        public MultiTileEntityGUICommonFilterPrefix(InventoryPlayer aInventoryPlayer, MultiTileEntityFilterPrefix aTileEntity, int aGUIID) {
            super(aInventoryPlayer, aTileEntity, aGUIID);
        }

        @Override
        public int addSlots(InventoryPlayer aPlayerInventory) {
            this.func_75146_a(new Slot_Holo(this.mTileEntity, this.mOffset, 80, 35, false, false, 1));
            return 84;
        }

        @Override
        public ItemStack func_75144_a(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
            if (aSlotIndex < 0 || aSlotIndex >= this.mTileEntity.getSizeInventoryGUI()) {
                return super.func_75144_a(aSlotIndex, aMouseclick, aShifthold, aPlayer);
            }
            ItemStack tStack = aPlayer.field_71071_by.func_70445_o();
            if (tStack == null) {
                ((MultiTileEntityFilterPrefix)this.mTileEntity).mFilter = null;
            } else {
                OreDictItemData tData = OM.anyassociation_(tStack);
                if (tData == null || ((MultiTileEntityFilterPrefix)this.mTileEntity).mFilter == tData.mPrefix) {
                    for (OreDictPrefix tPrefix : OreDictPrefix.VALUES_SORTED) {
                        if (((MultiTileEntityFilterPrefix)this.mTileEntity).mFilter == tPrefix || tPrefix.containsAny(TD.Prefix.UNIFICATABLE, TD.Prefix.NO_PREFIX_FILTERING) || !tPrefix.contains(tStack)) continue;
                        ((MultiTileEntityFilterPrefix)this.mTileEntity).mFilter = tPrefix;
                        break;
                    }
                } else {
                    ((MultiTileEntityFilterPrefix)this.mTileEntity).mFilter = tData.mPrefix;
                }
            }
            return null;
        }
    }
}

