/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.transformers;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.tool.BlockLongDistWire;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class MultiTileEntityLongDistanceTransformer
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData,
ITileEntityCanDelegate,
ITileEntityMachineBlockUpdateable,
ITileEntityRunningActively,
ITileEntityEnergyElectricityAcceptor,
ITileEntitySwitchableOnOff {
    protected boolean mWasteEnergy = false;
    protected boolean mStopped = false;
    protected boolean mActive = false;
    protected long mInput = 0L;
    protected long mOutput = 0L;
    protected long mThroughput = 0L;
    protected long mActiveData = 0L;
    protected long mDistance = 0L;
    protected byte mActiveState = 0;
    protected TagData mEnergyTypeAccepted = TD.Energy.EU;
    protected TagData mEnergyTypeEmitted = TD.Energy.EU;
    protected MultiTileEntityLongDistanceTransformer mTarget = null;
    protected MultiTileEntityLongDistanceTransformer mSender = null;
    protected ChunkCoordinates mTargetPos = null;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/colored/front"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/colored/back"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/colored/side")};
    public static IIconContainer[][] sOverlays = new IIconContainer[][]{{new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay/side")}, {new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_active/back"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_active/side")}, {new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_blinking/front"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_blinking/back"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_blinking/side")}, {new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_unloaded/front"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_unloaded/back"), new Textures.BlockIcons.CustomIcon("machines/transformers/longdistancetransformer_electric/overlay_unloaded/side")}};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.wasteenergy")) {
            this.mWasteEnergy = aNBT.func_74767_n("gt.wasteenergy");
        }
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mStopped = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
        if (aNBT.func_74764_b("gt.active.data")) {
            this.mActiveData = aNBT.func_74763_f("gt.active.data");
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mInput = aNBT.func_74763_f("gt.input");
        }
        if (aNBT.func_74764_b("gt.output")) {
            this.mOutput = aNBT.func_74763_f("gt.output");
        }
        if (aNBT.func_74764_b("gt.distance")) {
            this.mDistance = aNBT.func_74763_f("gt.distance");
        }
        if (aNBT.func_74764_b("gt.througput")) {
            this.mThroughput = aNBT.func_74763_f("gt.througput");
        }
        if (aNBT.func_74764_b("gt.target")) {
            this.mTargetPos = new ChunkCoordinates(UT.Code.bindInt(aNBT.func_74763_f("gt.target.x")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.y")), UT.Code.bindInt(aNBT.func_74763_f("gt.target.z")));
        }
        if (aNBT.func_74764_b("gt.energy.emitted")) {
            this.mEnergyTypeEmitted = TagData.createTagData(aNBT.func_74779_i("gt.energy.emitted"));
        }
        if (aNBT.func_74764_b("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.func_74779_i("gt.energy.accepted"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mTargetPos != null && this.mTarget != this) {
            UT.NBT.setBoolean(aNBT, "gt.target", true);
            UT.NBT.setNumber(aNBT, "gt.target.x", this.mTargetPos.field_71574_a);
            UT.NBT.setNumber(aNBT, "gt.target.y", this.mTargetPos.field_71572_b);
            UT.NBT.setNumber(aNBT, "gt.target.z", this.mTargetPos.field_71573_c);
            UT.NBT.setNumber(aNBT, "gt.distance", this.mDistance);
            UT.NBT.setNumber(aNBT, "gt.througput", this.mThroughput);
        }
        UT.NBT.setNumber(aNBT, "gt.active.data", this.mActiveData);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mStopped);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, this.mEnergyTypeEmitted, this.getLocalisedInputSide(), this.getLocalisedOutputSide());
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("softhammer")) {
            this.scanWires(false);
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
                    aChatReturn.add("Is the Target");
                    aChatReturn.add("Sender is at: X: " + this.mSender.field_145851_c + " Y: " + this.mSender.field_145848_d + " Z: " + this.mSender.field_145849_e);
                } else {
                    aChatReturn.add(this.checkTarget() ? "Has Target" : "Has no loaded Target");
                    if (this.mTargetPos != null) {
                        aChatReturn.add("Target should be around: X: " + this.mTargetPos.field_71574_a + " Y: " + this.mTargetPos.field_71572_b + " Z: " + this.mTargetPos.field_71573_c);
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        byte tActiveState = this.mActiveState;
        if (this.mStopped) {
            this.mActiveState = 0;
        } else if (this.mTarget != null && (this.mTarget.mSender == null || this.mTarget.mSender.isDead() || this.mTarget.mSender.mTarget == null || this.mTarget.mSender.mTarget.isDead()) && this.mTargetPos != null && (this.mTarget == null || this.mTarget.isDead() || !this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c))) {
            this.mActiveState = (byte)3;
        } else {
            this.mActiveData <<= 1;
            if (this.mActive) {
                this.mActiveData |= 1L;
            }
            this.mActiveState = this.mActiveData == -1L ? (byte)1 : (this.mActiveData == 0L ? (byte)0 : (byte)2);
        }
        this.mActive = false;
        return tActiveState != this.mActiveState || super.onTickCheck(aTimer);
    }

    public boolean checkTarget() {
        if (this.mStopped || this.isClientSide()) {
            return false;
        }
        if (this.mTargetPos == null || this.mDistance <= 0L || this.mThroughput <= 0L) {
            this.scanWires(false);
        } else if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (this.field_145850_b.func_72899_e(this.mTargetPos.field_71574_a, this.mTargetPos.field_71572_b, this.mTargetPos.field_71573_c)) {
                TileEntity tTileEntity = WD.te(this.field_145850_b, this.mTargetPos, true);
                if (tTileEntity instanceof MultiTileEntityLongDistanceTransformer) {
                    this.mTarget = (MultiTileEntityLongDistanceTransformer)tTileEntity;
                } else if (tTileEntity != null) {
                    this.mTargetPos = null;
                }
            }
        }
        if (this.mTarget == null || this.mTarget == this) {
            return false;
        }
        if (this.mTarget.mSender == null || this.mTarget.mSender.isDead() || this.mTarget.mSender.mTarget == null || this.mTarget.mSender.mTarget.isDead()) {
            this.mTarget.mSender = this;
        }
        return this.mTarget.mSender == this;
    }

    private void scanWires(boolean aBurnWires) {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            return;
        }
        this.mIgnoreUnloadedChunks = false;
        this.mTargetPos = this.getCoords();
        this.mTarget = this;
        this.mSender = null;
        this.mDistance = 0L;
        this.mThroughput = 0L;
        Block aBlock = this.getBlockAtSide(CS.OPOS[this.mFacing]);
        byte aMetaData = this.getMetaDataAtSide(CS.OPOS[this.mFacing]);
        if (aBlock instanceof BlockLongDistWire) {
            this.mThroughput = CS.VMAX[((BlockLongDistWire)aBlock).mTiers[aMetaData]];
            HashSetNoNulls<ChunkCoordinates> tNewChecks = new HashSetNoNulls<ChunkCoordinates>();
            HashSetNoNulls<ChunkCoordinates> tOldChecks = new HashSetNoNulls<ChunkCoordinates>(false, this.getCoords());
            HashSetNoNulls<ChunkCoordinates> tToCheck = new HashSetNoNulls<ChunkCoordinates>(false, this.getOffsetN(this.mFacing, 1));
            HashSetNoNulls<ChunkCoordinates> tWires = new HashSetNoNulls<ChunkCoordinates>();
            this.mDistance = -1L;
            while (!tToCheck.isEmpty()) {
                ++this.mDistance;
                for (ChunkCoordinates aCoords : tToCheck) {
                    if (this.getBlock(aCoords) == aBlock && this.getMetaData(aCoords) == aMetaData) {
                        tWires.add(aCoords);
                        ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c);
                        if (tOldChecks.add(tCoords)) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1))) {
                            tNewChecks.add(tCoords);
                        }
                        if (tOldChecks.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1))) {
                            tNewChecks.add(tCoords);
                        }
                        if (!aBurnWires) continue;
                        WD.burn(this.field_145850_b, aCoords, true, false);
                        this.field_145850_b.func_147465_d(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c, (Block)Blocks.field_150480_ab, 0, 3);
                        continue;
                    }
                    TileEntity tTileEntity = this.getTileEntity(aCoords);
                    if (tTileEntity == this || !(tTileEntity instanceof MultiTileEntityLongDistanceTransformer)) continue;
                    if (tWires.contains(((MultiTileEntityLongDistanceTransformer)tTileEntity).getOffset(((MultiTileEntityLongDistanceTransformer)tTileEntity).mFacing, 1))) {
                        this.mTarget = (MultiTileEntityLongDistanceTransformer)tTileEntity;
                        this.mTargetPos = this.mTarget.getCoords();
                        this.mIgnoreUnloadedChunks = true;
                        return;
                    }
                    tOldChecks.remove(aCoords);
                }
                tToCheck.clear();
                tToCheck.addAll(tNewChecks);
                tNewChecks.clear();
            }
        }
        this.mIgnoreUnloadedChunks = true;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (this.mStopped) {
            return 0L;
        }
        int aSign = 1;
        if (aSize < 0L) {
            aSize = -aSize;
            aSign = -1;
        }
        if (aSize > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            if (aDoInject) {
                this.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (!this.checkTarget()) {
            return 0L;
        }
        if (aSize > this.mThroughput) {
            if (aDoInject) {
                this.scanWires(true);
            }
            return aAmount;
        }
        if ((aSize = Math.max(0L, aSize - Math.max(64L, this.mDistance / 8L))) <= 0L || aSize < this.mTarget.getEnergySizeOutputMin(this.mTarget.mEnergyTypeEmitted, aSide)) {
            return 0L;
        }
        if (aSize > this.mTarget.getEnergySizeOutputMax(this.mTarget.mEnergyTypeEmitted, aSide)) {
            if (aDoInject) {
                this.mTarget.overcharge(aSize, aEnergyType);
            }
            return aAmount;
        }
        if (aDoInject) {
            long tConsumed = ITileEntityEnergy.Util.emitEnergyToNetwork(this.mTarget.mEnergyTypeEmitted, aSize * (long)aSign, aAmount, this.mTarget);
            this.mActive = this.mActive || tConsumed > 0L;
            this.mTarget.mActive = this.mActive;
            return tConsumed;
        }
        return aAmount;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return !(!aTheoretical && !this.checkTarget() || !CS.SIDES_INVALID[aSide] && !this.isInput(aSide) || !super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical));
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (CS.SIDES_INVALID[aSide] || this.isOutput(aSide)) && super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return new ArrayListNoNulls<TagData>(false, this.mEnergyTypeAccepted, this.mEnergyTypeEmitted);
    }

    @Override
    public double getDemandedEnergy() {
        return this.checkTarget() ? super.getDemandedEnergy() : 0.0;
    }

    @Override
    public boolean getStateRunningPossible() {
        return true;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mActive;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mActive && (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this || this.mTarget != null && !this.mTarget.isDead());
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mStopped = !aOnOff;
        return !this.mStopped;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mStopped;
    }

    @Override
    public byte getVisualData() {
        return this.mActiveState;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mActiveState = aData;
    }

    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.front");
    }

    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.back");
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting ? aEnergyType == this.mEnergyTypeEmitted : aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mOutput;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mInput;
    }

    public boolean isInput(byte aSide) {
        return aSide == this.mFacing;
    }

    public boolean isOutput(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public void onCoordinateChange() {
        super.onCoordinateChange();
        this.mTargetPos = null;
        this.mSender = null;
    }

    @Override
    public void onMachineBlockUpdate(ChunkCoordinates aCoords, Block aBlock, byte aMeta, boolean aRemoved) {
        if (aBlock instanceof BlockLongDistWire) {
            this.mTargetPos = null;
            this.mSender = null;
        }
    }

    @Override
    public boolean hasMultiBlockMachineRelevantData() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isExtender(byte aSide) {
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get(sOverlays[this.mActiveState][aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.longdistancetransformers.transformer_electric";
    }
}

