/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.block.IBlockFoamable;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.BlockCFoamFresh;
import gregtech.tileentity.misc.MultiTileEntityCFoam;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Spray_Foam
extends IBehavior.AbstractBehaviorDefault {
    private final ItemStack mEmpty;
    private final ItemStack mUsed;
    private final ItemStack mFull;
    private final long mUses;
    private final byte mColor;
    private final boolean mOwned;

    public Behavior_Spray_Foam(ItemStack aEmpty, ItemStack aUsed, ItemStack aFull, long aUses, byte aColor, boolean aOwned) {
        this.mEmpty = aEmpty;
        this.mUsed = aUsed;
        this.mFull = aFull;
        this.mUses = aUses * 10L;
        this.mOwned = aOwned;
        this.mColor = UT.Code.bind4(aColor);
        LH.add("gt.behaviour.foamspray." + this.mColor + ".tooltip", "Can place " + CS.DYE_NAMES[this.mColor] + " C-Foam");
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aPlayer.func_70093_af()) {
            this.switchMode(aStack, aPlayer);
        }
        return super.onItemRightClick(aItem, aStack, aWorld, aPlayer);
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        long tFoamed;
        if (aWorld.field_72995_K || aStack.field_77994_a != 1 || aPlayer.func_70093_af() || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        boolean rOutput = false;
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        }
        long tUses = tNBT.func_74763_f("gt.remaining");
        if (ST.equal(aStack, this.mFull, true)) {
            aStack.func_150996_a(this.mUsed.func_77973_b());
            ST.meta_(aStack, ST.meta_(this.mUsed));
            tUses = this.mUses;
        }
        if (ST.equal(aStack, this.mUsed, true) && (tFoamed = this.foam(aWorld, aX, aY, aZ, aSide, UT.Entities.hasInfiniteItems(aPlayer) ? this.mUses : tUses, aPlayer, aStack)) > 0L) {
            UT.Sounds.send(CS.SFX.IC_SPRAY, aWorld, aX, aY, aZ);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                tUses -= tFoamed;
            }
            rOutput = true;
        }
        if (tUses <= 0L) {
            tUses = 0L;
            tNBT.func_82580_o("gt.mode");
            if (this.mEmpty == null) {
                --aStack.field_77994_a;
            } else {
                aStack.func_150996_a(this.mEmpty.func_77973_b());
                ST.meta_(aStack, ST.meta_(this.mEmpty));
            }
        }
        UT.NBT.setNumber(tNBT, "gt.remaining", tUses);
        UT.NBT.set(aStack, tNBT);
        return rOutput;
    }

    public long foam(World aWorld, int aX, int aY, int aZ, byte aSide, long aUses, EntityPlayer aPlayer, ItemStack aStack) {
        if (aUses < 1L) {
            return 0L;
        }
        long rUses = 0L;
        DelegatorTileEntity<TileEntity> aDelegator = WD.te(aWorld, aX, aY, aZ, aSide, true);
        if (aDelegator.mTileEntity instanceof ITileEntityFoamable && !((ITileEntityFoamable)aDelegator.mTileEntity).hasFoam(aDelegator.mSideOfTileEntity)) {
            return ((ITileEntityFoamable)aDelegator.mTileEntity).applyFoam(aDelegator.mSideOfTileEntity, (Entity)aPlayer, CS.DYES[this.mColor], this.mColor, this.mOwned) ? 10L : 0L;
        }
        Block aBlock = aDelegator.getBlock();
        aWorld = aDelegator.mWorld;
        aX = aDelegator.mX;
        aY = aDelegator.mY;
        aZ = aDelegator.mZ;
        if (aBlock instanceof IBlockFoamable && !((IBlockFoamable)aBlock).hasFoam(aWorld, aX, aY, aZ, aDelegator.mSideOfTileEntity)) {
            return ((IBlockFoamable)aBlock).applyFoam(aWorld, aX, aY, aZ, aDelegator.mSideOfTileEntity, CS.DYES[this.mColor], this.mColor) ? 10L : 0L;
        }
        try {
            if (UT.Reflection.getClassName(aDelegator.mTileEntity).startsWith("TileEntityCable") && UT.Reflection.getPublicField(aDelegator.mTileEntity, "foamed").getByte(aDelegator.mTileEntity) == 0) {
                if (aUses >= 10L) {
                    UT.Reflection.callPublicMethod(aDelegator.mTileEntity, "changeFoam", (byte)1);
                    return 10L;
                }
                return 0L;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (IL.IC2_Scaffold.equal(aBlock)) {
            return aUses >= 10L && MultiTileEntityCFoam.setBlock(aWorld, aX, aY, aZ, aDelegator.mSideOfTileEntity, aPlayer, aStack, CS.DYES[this.mColor], this.mOwned) ? 10L : 0L;
        }
        if (IL.IC2_Scaffold_Iron.equal(aBlock)) {
            return aUses >= 10L && aWorld.func_147465_d(aX, aY, aZ, IL.IC2_Foam_Reinforced.block(), 0, 3) ? 10L : 0L;
        }
        aX += CS.OFFX[aSide];
        aY += CS.OFFY[aSide];
        aZ += CS.OFFZ[aSide];
        if (CS.BlocksGT.CFoamFresh != null) {
            byte tSide = UT.Code.getSideForPlayerPlacing((Entity)aPlayer);
            switch ((int)this.getMode(aStack)) {
                case 0: {
                    if (aUses >= 10L && WD.air(aWorld, aX, aY, aZ) && (this.mOwned ? MultiTileEntityCFoam.setBlock(aWorld, aX, aY, aZ, aSide, aPlayer, aStack, CS.DYES[this.mColor], this.mOwned) : aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.CFoamFresh, (int)this.mColor, 3))) {
                        aUses -= 10L;
                        rUses += 10L;
                    }
                    return rUses;
                }
                case 1: {
                    for (int i = 0; i < 4 && aUses >= 10L && WD.air(aWorld, aX, aY, aZ) && (this.mOwned ? MultiTileEntityCFoam.setBlock(aWorld, aX, aY, aZ, aSide, aPlayer, aStack, CS.DYES[this.mColor], this.mOwned) : aWorld.func_147465_d(aX, aY, aZ, (Block)CS.BlocksGT.CFoamFresh, (int)this.mColor, 3)); i = (int)((byte)(i + 1))) {
                        aUses -= 10L;
                        rUses += 10L;
                        aX -= CS.OFFX[tSide];
                        aY -= CS.OFFY[tSide];
                        aZ -= CS.OFFZ[tSide];
                    }
                    return rUses;
                }
                case 2: {
                    aX -= CS.SIDES_AXIS_X[tSide] ? 0 : 1;
                    aY -= CS.SIDES_AXIS_Y[tSide] ? 0 : 1;
                    aZ -= CS.SIDES_AXIS_Z[tSide] ? 0 : 1;
                    for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                        for (int j = 0; j < 3 && aUses >= 10L; j = (int)((byte)(j + 1))) {
                            if (!WD.air(aWorld, aX + (CS.SIDES_AXIS_X[tSide] ? 0 : i), aY + (CS.SIDES_AXIS_X[tSide] ? i : 0) + (CS.SIDES_AXIS_Z[tSide] ? j : 0), aZ + (CS.SIDES_AXIS_Z[tSide] ? 0 : j)) || !(this.mOwned ? MultiTileEntityCFoam.setBlock(aWorld, aX + (CS.SIDES_AXIS_X[tSide] ? 0 : i), aY + (CS.SIDES_AXIS_X[tSide] ? i : 0) + (CS.SIDES_AXIS_Z[tSide] ? j : 0), aZ + (CS.SIDES_AXIS_Z[tSide] ? 0 : j), aSide, aPlayer, aStack, CS.DYES[this.mColor], this.mOwned) : aWorld.func_147465_d(aX + (CS.SIDES_AXIS_X[tSide] ? 0 : i), aY + (CS.SIDES_AXIS_X[tSide] ? i : 0) + (CS.SIDES_AXIS_Z[tSide] ? j : 0), aZ + (CS.SIDES_AXIS_Z[tSide] ? 0 : j), (Block)CS.BlocksGT.CFoamFresh, (int)this.mColor, 3))) continue;
                            aUses -= 10L;
                            rUses += 10L;
                        }
                    }
                    return rUses;
                }
                case 3: {
                    if (aUses >= 5L && WD.air(aWorld, aX, aY, aZ) && aWorld.func_147465_d(aX, aY, aZ, (Block)((BlockCFoamFresh)CS.BlocksGT.CFoamFresh).mSlabs[CS.OPOS[aSide]], (int)this.mColor, 3)) {
                        aUses -= 5L;
                        rUses += 5L;
                    }
                    return rUses;
                }
                case 4: {
                    aX -= CS.SIDES_AXIS_X[tSide] ? 0 : 1;
                    aY -= CS.SIDES_AXIS_Y[tSide] ? 0 : 1;
                    aZ -= CS.SIDES_AXIS_Z[tSide] ? 0 : 1;
                    for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                        for (int j = 0; j < 3 && aUses >= 5L; j = (int)((byte)(j + 1))) {
                            if (!WD.air(aWorld, aX + (CS.SIDES_AXIS_X[tSide] ? 0 : i), aY + (CS.SIDES_AXIS_X[tSide] ? i : 0) + (CS.SIDES_AXIS_Z[tSide] ? j : 0), aZ + (CS.SIDES_AXIS_Z[tSide] ? 0 : j)) || !aWorld.func_147465_d(aX + (CS.SIDES_AXIS_X[tSide] ? 0 : i), aY + (CS.SIDES_AXIS_X[tSide] ? i : 0) + (CS.SIDES_AXIS_Z[tSide] ? j : 0), aZ + (CS.SIDES_AXIS_Z[tSide] ? 0 : j), (Block)((BlockCFoamFresh)CS.BlocksGT.CFoamFresh).mSlabs[CS.OPOS[tSide]], (int)this.mColor, 3)) continue;
                            aUses -= 5L;
                            rUses += 5L;
                        }
                    }
                    return rUses;
                }
            }
        }
        return rUses;
    }

    public void setMode(ItemStack aStack, long aMode) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        UT.NBT.set(aStack, UT.NBT.setNumber(aNBT, "gt.mode", aMode));
    }

    public long getMode(ItemStack aStack) {
        return UT.NBT.getNBT(aStack).func_74763_f("gt.mode");
    }

    public void switchMode(ItemStack aStack, EntityPlayer aPlayer) {
        this.setMode(aStack, (this.getMode(aStack) + 1L) % (long)(this.mOwned ? 3 : 5));
        switch ((int)this.getMode(aStack)) {
            case 0: {
                UT.Entities.sendchat((Object)aPlayer, "Single Block Mode");
                break;
            }
            case 1: {
                UT.Entities.sendchat((Object)aPlayer, "4m Line Mode");
                break;
            }
            case 2: {
                UT.Entities.sendchat((Object)aPlayer, "3mx3m Area Mode");
                break;
            }
            case 3: {
                UT.Entities.sendchat((Object)aPlayer, "Single Slab Mode");
                break;
            }
            case 4: {
                UT.Entities.sendchat((Object)aPlayer, "3mx3m Slab Mode");
            }
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.foamspray." + this.mColor + ".tooltip"));
        NBTTagCompound tNBT = aStack.func_77978_p();
        long tRemaining = ST.equal(aStack, this.mFull, true) ? this.mUses : (tNBT == null ? 0L : tNBT.func_74763_f("gt.remaining"));
        aList.add(LH.get("gt.behaviour.foamspray.uses") + " " + tRemaining / 10L + "." + tRemaining % 10L);
        aList.add(LH.get("gt.behaviour.unstackable"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.foamspray.uses", "Remaining Uses:");
        LH.add("gt.behaviour.unstackable", "Not usable when stacked!");
    }
}

