/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import gregapi.util.UT;
import gregtech.entities.projectiles.EntityArrow_Potion;
import gregtech.items.behaviors.Behavior_Arrow;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Behavior_Arrow_Potion
extends Behavior_Arrow {
    private final int[] mPotions;

    public Behavior_Arrow_Potion(float aSpeed, float aPrecision, int ... aPotions) {
        super(EntityArrow_Potion.class, aSpeed, aPrecision);
        this.mPotions = aPotions;
    }

    public Behavior_Arrow_Potion(float aSpeed, float aPrecision, Enchantment aEnchantment, int aLevel, int ... aPotions) {
        super(EntityArrow_Potion.class, aSpeed, aPrecision, aEnchantment, aLevel);
        this.mPotions = aPotions;
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aEntity instanceof EntityLivingBase) {
            for (int i = 3; i < this.mPotions.length; i += 4) {
                if (CS.RNGSUS.nextInt(100) >= this.mPotions[i]) continue;
                UT.Entities.applyPotion(aEntity, this.mPotions[i - 3], this.mPotions[i - 2], this.mPotions[i - 1], false);
            }
        }
        return super.onLeftClickEntity(aItem, aStack, aPlayer, aEntity);
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (!this.hasProjectile(aItem, aProjectileType, aStack)) {
            return null;
        }
        EntityArrow_Potion rArrow = new EntityArrow_Potion(aWorld, aX, aY, aZ);
        rArrow.setProjectileStack(aStack);
        rArrow.setPotions(this.mPotions);
        return rArrow;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        if (!this.hasProjectile(aItem, aProjectileType, aStack)) {
            return null;
        }
        EntityArrow_Potion rArrow = new EntityArrow_Potion(aWorld, aEntity, aSpeed);
        rArrow.setProjectileStack(aStack);
        rArrow.setPotions(this.mPotions);
        return rArrow;
    }
}

