/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.stone;

import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.WD;
import java.util.ArrayList;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVanillaOresA
extends BlockBaseMeta {
    public static byte[] HARVEST_LEVELS = new byte[]{0, 0, 2, 1, 2, 1, 1, 1, 2, 1, 2, 2, 2, 0, 3, 0};
    public static int[] BURN_LEVELS = new int[]{30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0};
    public static float[] HARDNESS_LEVELS = new float[]{0.5f, 0.5f, 1.5f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.5f, 1.0f, 1.5f, 1.5f, 1.5f, 0.5f, 2.0f, 0.5f};
    public static OreDictMaterial[] ORE_MATERIALS = new OreDictMaterial[]{MT.S, MT.Apatite, MT.Ruby, MT.Amber, MT.Amethyst, MT.OREMATS.Galena, MT.OREMATS.Tetrahedrite, MT.OREMATS.Cassiterite, MT.OREMATS.Cooperite, MT.OREMATS.Pentlandite, MT.OREMATS.Scheelite, MT.TiO2, MT.OREMATS.Bastnasite, MT.Graphite, MT.OREMATS.Pitchblende, MT.OREMATS.Borax};

    public BlockVanillaOresA(String aUnlocalised) {
        super(null, aUnlocalised, Material.field_151576_e, field_149769_e, ORE_MATERIALS.length, Textures.BlockIcons.VANILLA_ORES_A);
        LH.add(this.func_149739_a() + ".0", "Sulfur Ore");
        LH.add(this.func_149739_a() + ".1", "Apatite Ore");
        LH.add(this.func_149739_a() + ".2", "Ruby Ore");
        LH.add(this.func_149739_a() + ".3", "Amber Ore");
        LH.add(this.func_149739_a() + ".4", "Amethyst Ore");
        LH.add(this.func_149739_a() + ".5", "Galena Ore");
        LH.add(this.func_149739_a() + ".6", "Tetrahedrite Ore");
        LH.add(this.func_149739_a() + ".7", "Cassiterite Ore");
        LH.add(this.func_149739_a() + ".8", "Sheldonite Ore");
        LH.add(this.func_149739_a() + ".9", "Pentlandite Ore");
        LH.add(this.func_149739_a() + ".10", "Scheelite Ore");
        LH.add(this.func_149739_a() + ".11", "Rutile Ore");
        LH.add(this.func_149739_a() + ".12", "Bastnasite Ore");
        LH.add(this.func_149739_a() + ".13", "Graphite Ore");
        LH.add(this.func_149739_a() + ".14", "Pitchblende Ore");
        LH.add(this.func_149739_a() + ".15", "Borax Ore");
        for (int i = 0; i < this.maxMeta(); ++i) {
            OM.reg(ST.make(this, 1L, (long)i), OP.oreVanillastone.dat(ORE_MATERIALS[i]));
        }
        if (CS.COMPAT_IC2 != null) {
            CS.COMPAT_IC2.valuable(this, 0, 1);
            CS.COMPAT_IC2.valuable(this, 1, 1);
            CS.COMPAT_IC2.valuable(this, 2, 4);
            CS.COMPAT_IC2.valuable(this, 3, 4);
            CS.COMPAT_IC2.valuable(this, 4, 4);
            CS.COMPAT_IC2.valuable(this, 5, 2);
            CS.COMPAT_IC2.valuable(this, 6, 2);
            CS.COMPAT_IC2.valuable(this, 7, 2);
            CS.COMPAT_IC2.valuable(this, 8, 5);
            CS.COMPAT_IC2.valuable(this, 9, 3);
            CS.COMPAT_IC2.valuable(this, 10, 3);
            CS.COMPAT_IC2.valuable(this, 11, 3);
            CS.COMPAT_IC2.valuable(this, 12, 3);
            CS.COMPAT_IC2.valuable(this, 13, 2);
            CS.COMPAT_IC2.valuable(this, 14, 5);
            CS.COMPAT_IC2.valuable(this, 15, 1);
        }
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("miner", ST.make(this, 1L, 32767L));
        }
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        return ST.arraylist(OP.oreRaw.mat(ORE_MATERIALS[aMeta], aFortune > 0 ? (long)(1 + CS.RNGSUS.nextInt(aFortune + 1)) : 1L));
    }

    public int getExpDrop(IBlockAccess aWorld, int aMeta, int aFortune) {
        switch (aMeta) {
            case 0: 
            case 1: {
                return 0 + CS.RNGSUS.nextInt(3);
            }
            case 2: 
            case 3: 
            case 4: {
                return 3 + CS.RNGSUS.nextInt(5);
            }
        }
        return 2 + CS.RNGSUS.nextInt(4);
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return true;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return HARVEST_LEVELS[aMeta];
    }

    @Override
    public int getFlammability(byte aMeta) {
        return BURN_LEVELS[aMeta];
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150348_b.func_149712_f(aWorld, aX, aY, aZ) * HARDNESS_LEVELS[WD.meta((IBlockAccess)aWorld, aX, aY, aZ)];
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.field_150348_b.func_149638_a(null);
    }
}

