/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.block.IBlockExtendedMetaData;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockOcean;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.Fluid;

public class BlockSwamp
extends BlockWaterlike {
    public static boolean PLACEMENT_ALLOWED = false;
    public static boolean FLOWS_OUT = true;

    public BlockSwamp(String aName, Fluid aFluid) {
        super(aName, aFluid, FLOWS_OUT, true);
        this.tickRate = 10;
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        if (PLACEMENT_ALLOWED) {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, 10 + CS.RNGSUS.nextInt(90));
        } else {
            aWorld.func_147468_f(aX, aY, aZ);
        }
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        int j;
        Block tBlock;
        PLACEMENT_ALLOWED = true;
        if (aWorld.func_72873_a(aX, aY, aZ, 33)) {
            aWorld.func_147451_t(aX, aY, aZ);
            WD.update((IBlockAccess)aWorld, aX, aY, aZ);
            if (aY > 0) {
                if (aWorld.func_147439_a(aX, aY - 1, aZ) == this) {
                    aWorld.func_147464_a(aX, aY - 1, aZ, (Block)this, this.tickRate);
                } else {
                    aWorld.func_147451_t(aX, aY - 1, aZ);
                    WD.update((IBlockAccess)aWorld, aX, aY - 1, aZ);
                }
            }
        } else {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, Math.max(600, this.tickRate));
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (aY <= 0) {
            this.updateFlow(aWorld, aX, aY, aZ, aRandom);
            PLACEMENT_ALLOWED = false;
            return;
        }
        BiomeGenBase tBiome = aWorld.func_72807_a(aX, aZ);
        boolean tDirt = false;
        int tSwampCounter = 0;
        ArrayListNoNulls<ChunkCoordinates> tList = new ArrayListNoNulls<ChunkCoordinates>();
        for (byte tSide : CS.ALL_SIDES_BUT_TOP) {
            tBlock = WD.block(aWorld, aX, aY, aZ, tSide);
            if (tBlock == CS.NB) continue;
            byte tMeta = WD.meta(aWorld, aX, aY, aZ, tSide);
            if (tBlock == this) {
                if (tMeta != 0) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock instanceof BlockWaterlike) {
                if (tMeta != 0 && !(tBlock instanceof BlockOcean)) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) {
                tList.add(new ChunkCoordinates(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]));
                if (tMeta != 0) continue;
                tSwampCounter = (byte)(tSwampCounter + 1);
                continue;
            }
            if (tBlock == Blocks.field_150354_m || tBlock == Blocks.field_150346_d || tBlock == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh || tBlock == CS.BlocksGT.Grass || tBlock == CS.BlocksGT.Diggables || tBlock == CS.BlocksGT.Sands || tBlock == CS.BlocksGT.oreSand || tBlock == CS.BlocksGT.oreRedSand || tBlock == CS.BlocksGT.oreMud || tBlock == CS.BlocksGT.oreSmallSand || tBlock == CS.BlocksGT.oreSmallRedSand || tBlock == CS.BlocksGT.oreSmallMud || IL.EtFu_Dirt.equal(tBlock)) {
                tDirt = true;
                continue;
            }
            if (!IL.TF_Mazestone.equal(tBlock)) continue;
            if (WD.air(aWorld, aX, aY + 1, aZ)) {
                aWorld.func_147465_d(aX, aY + 1, aZ, Blocks.field_150420_aW, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 1, aZ)) {
                aWorld.func_147465_d(aX, aY + 1, aZ, Blocks.field_150420_aW, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 2, aZ)) {
                aWorld.func_147465_d(aX, aY + 2, aZ, Blocks.field_150420_aW, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 2, aZ)) {
                aWorld.func_147465_d(aX, aY + 2, aZ, Blocks.field_150420_aW, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 3, aZ)) {
                aWorld.func_147465_d(aX, aY + 3, aZ, Blocks.field_150420_aW, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 3, aZ)) {
                aWorld.func_147465_d(aX, aY + 3, aZ, Blocks.field_150420_aW, 10, 3);
            }
            if (WD.air(aWorld, aX, aY + 4, aZ)) {
                aWorld.func_147465_d(aX, aY + 4, aZ, Blocks.field_150420_aW, 10, 3);
            } else if (WD.anywater((IBlockAccess)aWorld, aX, aY + 4, aZ)) {
                aWorld.func_147465_d(aX, aY + 4, aZ, Blocks.field_150420_aW, 10, 3);
            }
            for (int i = -2; i <= 2; ++i) {
                for (int j2 = -2; j2 <= 2; ++j2) {
                    if (Math.abs(i * j2) < 4) {
                        if (WD.air(aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY, aZ + j2, Blocks.field_150420_aW, 5, 3);
                        } else if (WD.anywater((IBlockAccess)aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY, aZ + j2, Blocks.field_150420_aW, 5, 3);
                        }
                        if (WD.air(aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY + 5, aZ + j2, Blocks.field_150420_aW, 5, 3);
                        } else if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY + 5, aZ + j2, Blocks.field_150420_aW, 5, 3);
                        }
                    } else {
                        if (WD.anywater((IBlockAccess)aWorld, aX + i, aY, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY, aZ + j2, CS.NB, 0, 3);
                        }
                        if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 5, aZ + j2)) {
                            aWorld.func_147465_d(aX + i, aY + 5, aZ + j2, CS.NB, 0, 3);
                        }
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 4, aZ + j2)) {
                        aWorld.func_147465_d(aX + i, aY + 4, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 3, aZ + j2)) {
                        aWorld.func_147465_d(aX + i, aY + 3, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 2, aZ + j2)) {
                        aWorld.func_147465_d(aX + i, aY + 2, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY + 1, aZ + j2)) {
                        aWorld.func_147465_d(aX + i, aY + 1, aZ + j2, CS.NB, 0, 3);
                    }
                    if (WD.anywater((IBlockAccess)aWorld, aX + i, aY - 1, aZ + j2)) {
                        aWorld.func_147465_d(aX + i, aY - 1, aZ + j2, CS.NB, 0, 3);
                    }
                    if (!WD.anywater((IBlockAccess)aWorld, aX + i, aY - 2, aZ + j2)) continue;
                    aWorld.func_147465_d(aX + i, aY - 1, aZ + j2, CS.NB, 0, 3);
                }
            }
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (tDirt) {
            for (int i = -1; i <= 1; ++i) {
                for (j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        tBlock = aWorld.func_147439_a(aX + i, aY + j, aZ + k);
                        if (tBlock == Blocks.field_150354_m || tBlock == Blocks.field_150346_d || tBlock == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh || IL.EtFu_Dirt.equal(tBlock)) {
                            aWorld.func_147465_d(aX + i, aY + j, aZ + k, (Block)CS.BlocksGT.Diggables, 0, 2);
                            continue;
                        }
                        if (tBlock == CS.BlocksGT.oreSand || tBlock == CS.BlocksGT.oreRedSand) {
                            CS.BlocksGT.oreMud.placeBlock(aWorld, aX + i, aY + j, aZ + k, (byte)6, ((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX + i, aY + j, aZ + k), null, true, true);
                            continue;
                        }
                        if (tBlock != CS.BlocksGT.oreSmallSand && tBlock != CS.BlocksGT.oreSmallRedSand) continue;
                        CS.BlocksGT.oreSmallMud.placeBlock(aWorld, aX + i, aY + j, aZ + k, (byte)6, ((IBlockExtendedMetaData)tBlock).getExtendedMetaData((IBlockAccess)aWorld, aX + i, aY + j, aZ + k), null, true, true);
                    }
                }
            }
        }
        if (aWorld.func_72805_g(aX, aY, aZ) == 0) {
            if (tSwampCounter <= 0 && !(aWorld.func_147439_a(aX, aY + 1, aZ) instanceof BlockSwamp)) {
                aWorld.func_147468_f(aX, aY, aZ);
                PLACEMENT_ALLOWED = false;
                return;
            }
        } else if (tSwampCounter >= 2) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)this, 0, WATER_UPDATE_FLAGS);
        }
        if (CS.BIOMES_INFINITE_WATER.contains(tBiome.field_76791_y)) {
            tSwampCounter = 0;
            for (int i = -1; i < 2; ++i) {
                for (j = -1; j < 2; ++j) {
                    if (i == 0 || j == 0 || !(aWorld.func_147439_a(aX + i, aY, aZ + j) instanceof BlockSwamp) || aWorld.func_72805_g(aX + i, aY, aZ + j) != 0) continue;
                    tSwampCounter = (byte)(tSwampCounter + 1);
                }
            }
            if (tSwampCounter < 3) {
                this.updateFlow(aWorld, aX, aY, aZ, aRandom);
                PLACEMENT_ALLOWED = false;
                return;
            }
        }
        Object object = tList.iterator();
        while (object.hasNext()) {
            ChunkCoordinates tCoords = (ChunkCoordinates)object.next();
            if (!aWorld.func_147465_d(tCoords.field_71574_a, tCoords.field_71572_b, tCoords.field_71573_c, (Block)this, 0, WATER_UPDATE_FLAGS)) continue;
            for (int i = -1; i < 2; ++i) {
                for (int j3 = -1; j3 < 2; ++j3) {
                    if (!aWorld.func_72899_e(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j3) || !((tBlock = aWorld.func_147439_a(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j3)) instanceof BlockSwamp)) continue;
                    aWorld.func_147464_a(tCoords.field_71574_a + i, tCoords.field_71572_b, tCoords.field_71573_c + j3, (Block)this, this.tickRate);
                }
            }
        }
        this.updateFlow(aWorld, aX, aY, aZ, aRandom);
        PLACEMENT_ALLOWED = false;
    }

    @Override
    public void onHeadInside(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if (aEntity instanceof EntitySlime) {
            return;
        }
        super.onHeadInside(aEntity, aWorld, aX, aY, aZ);
    }

    public int getLightOpacity(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld.func_147439_a(aX, aY + 1, aZ) != this || aWorld.func_72805_g(aX, aY, aZ) > 0) {
            return 3;
        }
        return 255;
    }

    @Override
    public IIcon func_149691_a(int aSide, int aMeta) {
        return Blocks.field_150355_j.func_149691_a(aSide, aMeta);
    }

    @Override
    public int func_149741_i(int aMeta) {
        return 65280;
    }

    @Override
    public int func_149720_d(IBlockAccess aWorld, int aX, int aY, int aZ) {
        if (aWorld.func_147439_a(aX, aY + 1, aZ) == this) {
            return 65280;
        }
        if (BlockSwamp.water(aWorld.func_147439_a(aX + 1, aY, aZ))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.func_147439_a(aX - 1, aY, aZ))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.func_147439_a(aX, aY, aZ + 1))) {
            return 0x60FF60;
        }
        if (BlockSwamp.water(aWorld.func_147439_a(aX, aY, aZ - 1))) {
            return 0x60FF60;
        }
        return 65280;
    }

    public static boolean water(Block aBlock) {
        return aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i || aBlock == CS.BlocksGT.Ocean || aBlock == CS.BlocksGT.River;
    }
}

