/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.StoneLayer;
import gregapi.worldgen.WorldgenObject;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenOresBedrock
extends WorldgenObject {
    public final int mProbability;
    public final OreDictMaterial mMaterial;
    public final boolean mIndicatorRocks;
    public final boolean mIndicatorFlowers;
    public final Block mFlower;
    public final byte mFlowerMeta;
    public static boolean GENERATED_NO_BEDROCK_ORE = true;
    public static boolean CAN_GENERATE_BEDROCK_ORE = true;

    @SafeVarargs
    public WorldgenOresBedrock(String aName, boolean aDefault, int aProbability, OreDictMaterial aPrimary, List<WorldgenObject> ... aLists) {
        this(aName, aDefault, true, aProbability, aPrimary, aLists);
    }

    @SafeVarargs
    public WorldgenOresBedrock(String aName, boolean aDefault, boolean aIndicatorRocks, int aProbability, OreDictMaterial aPrimary, List<WorldgenObject> ... aLists) {
        this(aName, aDefault, aIndicatorRocks, aProbability, aPrimary, CS.NB, 0L, aLists);
    }

    @SafeVarargs
    public WorldgenOresBedrock(String aName, boolean aDefault, boolean aIndicatorRocks, int aProbability, OreDictMaterial aPrimary, Object aFlower, long aFlowerMeta, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
        aFlower = aFlower instanceof Block ? (Block)aFlower : CS.NB;
        this.mProbability = Math.max(1, this.getConfigFile().get((Object)this.mCategory, "Probability", (long)aProbability));
        this.mMaterial = OreDictMaterial.get(this.getConfigFile().get((Object)this.mCategory, "Ore", aPrimary.mNameInternal));
        this.mIndicatorRocks = this.getConfigFile().get((Object)this.mCategory, "IndicatorRocks", aIndicatorRocks);
        this.mIndicatorFlowers = this.getConfigFile().get((Object)this.mCategory, "IndicatorFlowers", aFlower != CS.NB);
        if (this.mIndicatorFlowers && aFlower == CS.NB) {
            this.mFlower = Blocks.field_150327_N;
            this.mFlowerMeta = 0;
        } else {
            this.mFlower = (Block)aFlower;
            this.mFlowerMeta = UT.Code.bind4(aFlowerMeta);
        }
        if (this.mEnabled) {
            OreDictManager.INSTANCE.triggerVisibility("ore" + this.mMaterial.mNameInternal);
        }
        if (this.mMaterial == ANY.Hexorium) {
            ItemStack[] tOres = new ItemStack[]{ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)MT.HexoriumWhite.mID), ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)MT.HexoriumBlack.mID), ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)MT.HexoriumRed.mID), ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)MT.HexoriumGreen.mID), ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)MT.HexoriumBlue.mID), OP.dust.mat(MT.Bedrock, 1L), ST.make(Blocks.field_150347_e, 1L, 0L, "Various Cobblestone Types")};
            long[] tChances = new long[tOres.length];
            tChances[0] = 5000L;
            tChances[1] = 3500L;
            tChances[2] = 500L;
            tChances[3] = 500L;
            tChances[4] = 500L;
            tChances[5] = 10L;
            tChances[6] = 10000L;
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)MT.HexoriumWhite.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)MT.HexoriumBlack.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)MT.HexoriumRed.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)MT.HexoriumGreen.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)MT.HexoriumBlue.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
        } else if (this.mMaterial.mID <= 0) {
            CS.ERR.println("The Material is not valid for Ores: " + this.mMaterial);
            this.mInvalid = true;
        } else {
            ItemStack[] tOres = new ItemStack[this.mMaterial.mByProducts.size() + 3];
            tOres[0] = ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)this.mMaterial.mID);
            tOres[tOres.length - 2] = OP.dust.mat(MT.Bedrock, 1L);
            tOres[tOres.length - 1] = ST.make(Blocks.field_150347_e, 1L, 0L, "Various Cobblestone Types");
            long[] tChances = new long[tOres.length];
            int n = tChances.length > 2 ? 9687 : 10000;
            tChances[0] = n;
            tChances[tChances.length - 2] = 10L;
            tChances[tChances.length - 1] = 10000L;
            int j = this.mMaterial.mByProducts.size();
            for (int i = 0; i < j; ++i) {
                OreDictMaterial tByProduct = this.mMaterial.mByProducts.get(i);
                tOres[i + 1] = ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)(tByProduct.mID > 0 ? tByProduct : this.mMaterial).mID);
                tChances[i + 1] = UT.Code.divup(10000L, 32 * (tChances.length - 2));
            }
            RM.BedrockOreList.addFakeRecipe(false, ST.array(ST.make((Block)CS.BlocksGT.oreBedrock, 1L, (long)this.mMaterial.mID)), tOres, null, tChances, FL.array(FL.lube(100L)), null, 0L, 0L, 0L);
        }
    }

    @Override
    public void reset(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        CAN_GENERATE_BEDROCK_ORE = true;
        GENERATED_NO_BEDROCK_ORE = true;
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (CS.GENERATING_SPECIAL || !CAN_GENERATE_BEDROCK_ORE || aRandom.nextInt(this.mProbability) != 0) {
            return false;
        }
        if (!WorldgenOresBedrock.generateVein(this.mMaterial, aWorld, aDimType, aMinX, aMinZ, aRandom)) {
            return false;
        }
        GENERATED_NO_BEDROCK_ORE = false;
        if ((this.mIndicatorRocks || this.mIndicatorFlowers) && (!CS.GENERATE_STREETS || aWorld.field_73011_w.field_76574_g != 0 || Math.abs(aMinX) >= 64 && Math.abs(aMaxX) >= 64 && Math.abs(aMinZ) >= 64 && Math.abs(aMaxZ) >= 64)) {
            MultiTileEntityRegistry tRegistry;
            MultiTileEntityRegistry multiTileEntityRegistry = tRegistry = this.mIndicatorRocks ? MultiTileEntityRegistry.getRegistry("gt.multitileentity") : null;
            ItemStack tRock = tRegistry == null ? null : OP.oreRaw.mat(this.mMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : this.mMaterial, 1L);
            boolean tFlowers = this.mIndicatorFlowers && !CS.BIOMES_WASTELANDS.contains(aBiomes[8][8].field_76791_y);
            boolean tRocks = ST.valid(tRock);
            int tMinHeight = Math.min(aWorld.func_72800_K() - 2, WD.waterLevel(aWorld) - 1);
            int tMaxHeight = Math.min(aWorld.func_72800_K() - 1, tMinHeight * 2 + 16);
            for (int tD = 4; tD <= 16; tD *= 2) {
                try {
                    block3: for (int i = 0; i < tD; ++i) {
                        Block tContact;
                        int tX = aMinX + aRandom.nextInt(tD * 2) + 8 - tD;
                        int tZ = aMinZ + aRandom.nextInt(tD * 2) + 8 - tD;
                        for (int tY = tMaxHeight; tY > tMinHeight && !(tContact = aWorld.func_147439_a(tX, tY, tZ)).func_149688_o().func_76224_d() && tContact != Blocks.field_150458_ak; --tY) {
                            if (!tContact.func_149662_c() || tContact.isWood((IBlockAccess)aWorld, tX, tY, tZ) || tContact.isLeaves((IBlockAccess)aWorld, tX, tY, tZ)) continue;
                            if (!WD.easyRep(aWorld, tX, tY + 1, tZ)) continue block3;
                            if (tFlowers && tContact != Blocks.field_150346_d && (!tRocks || aRandom.nextInt(4) > 0)) {
                                WD.set(aWorld, tX, tY + 1, tZ, this.mFlower, (long)this.mFlowerMeta, 0L);
                                if (this.mFlower.func_149718_j(aWorld, tX, tY + 1, tZ)) continue block3;
                                WD.set(aWorld, tX, tY + 1, tZ, CS.NB, 0L, 0L);
                            }
                            if (!tRocks || tContact.func_149688_o() != Material.field_151577_b && tContact.func_149688_o() != Material.field_151578_c && tContact.func_149688_o() != Material.field_151595_p && tContact.func_149688_o() != Material.field_151576_e) continue block3;
                            tRegistry.mBlock.placeBlock(aWorld, tX, tY + 1, tZ, (byte)6, (short)32757, ST.save("gt.value", tRock), false, true);
                            continue block3;
                        }
                    }
                    continue;
                }
                catch (Throwable e) {
                    CS.ERR.println(tD);
                    e.printStackTrace(CS.ERR);
                }
            }
        }
        return true;
    }

    public static boolean generateVein(OreDictMaterial aMaterial, World aWorld, int aDimType, int aMinX, int aMinZ, Random aRandom) {
        try {
            int tZ;
            int tX;
            Block tStone = WD.block((IBlockAccess)aWorld, aMinX + 8, 0, aMinZ + 8);
            if (tStone != CS.BlocksGT.oreBedrock && tStone != CS.BlocksGT.oreSmallBedrock && !WD.bedrock(tStone)) {
                return false;
            }
            for (int tX2 = 5; tX2 < 11; ++tX2) {
                block17: for (int tZ2 = 5; tZ2 < 11; ++tZ2) {
                    switch (aRandom.nextInt(6)) {
                        case 0: {
                            CS.BlocksGT.oreBedrock.placeBlock(aWorld, aMinX + tX2, 0, aMinZ + tZ2, (byte)6, (aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial).mID, null, false, true);
                            continue block17;
                        }
                        case 1: 
                        case 2: {
                            CS.BlocksGT.oreSmallBedrock.placeBlock(aWorld, aMinX + tX2, 0, aMinZ + tZ2, (byte)6, (aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial).mID, null, false, true);
                        }
                    }
                }
            }
            CS.BlocksGT.oreBedrock.placeBlock(aWorld, aMinX + 6 + aRandom.nextInt(4), 0, aMinZ + 6 + aRandom.nextInt(4), (byte)6, (aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial).mID, null, false, true);
            tStone = aDimType == -1 ? Blocks.field_150424_aL : (StoneLayer.DEEPSLATE == null ? CS.NB : StoneLayer.DEEPSLATE.mStone);
            int[] tD1 = new int[]{5, 4, 2, 1, 0, 2, 5};
            int[] tD2 = new int[]{11, 12, 14, 15, 16, 14, 11};
            for (int tY = 1; tY < tD1.length; ++tY) {
                for (tX = tD1[tY]; tX < tD2[tY]; ++tX) {
                    block20: for (tZ = tD1[tY]; tZ < tD2[tY]; ++tZ) {
                        if (GENERATED_NO_BEDROCK_ORE) {
                            if (tStone != CS.NB) {
                                aWorld.func_147465_d(aMinX + tX, tY, aMinZ + tZ, tStone, 0, 0);
                            } else {
                                WD.removeBedrock(aWorld, aMinX + tX, tY, aMinZ + tZ);
                            }
                        }
                        switch (aRandom.nextInt(6)) {
                            case 0: {
                                WD.setOre(aWorld, aMinX + tX, tY, aMinZ + tZ, aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial);
                                continue block20;
                            }
                            case 1: 
                            case 2: {
                                WD.setSmallOre(aWorld, aMinX + tX, tY, aMinZ + tZ, aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial);
                            }
                        }
                    }
                }
            }
            int i = 5 + aRandom.nextInt(3);
            block21: while (i-- > 0) {
                tX = 5 + aRandom.nextInt(6);
                tZ = 5 + aRandom.nextInt(6);
                int tW = WD.waterLevel(aWorld);
                for (int tY = tD1.length; tY < tW; ++tY) {
                    switch (aRandom.nextInt(7)) {
                        case 0: {
                            ++tX;
                            break;
                        }
                        case 1: {
                            --tX;
                            break;
                        }
                        case 2: {
                            ++tZ;
                            break;
                        }
                        case 3: {
                            --tZ;
                        }
                    }
                    if (tX <= 0 || tX >= 15 || tZ <= 0 || tZ >= 15) {
                        WD.setSmallOre(aWorld, aMinX + tX, tY, aMinZ + tZ, aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial);
                        continue block21;
                    }
                    if (aRandom.nextInt(3) == 0) continue;
                    WD.setSmallOre(aWorld, aMinX + tX, tY, aMinZ + tZ, aMaterial == ANY.Hexorium ? UT.Code.select(MT.HexoriumBlack, ANY.Hexorium.mToThis.toArray(CS.ZL_MATERIAL)) : aMaterial);
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            return false;
        }
    }
}

