/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.gui.ContainerClientDefault;
import gregapi.gui.ContainerCommonDefault;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public abstract class MultiTileEntitySafe
extends TileEntityBase09FacingSingle
implements IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness {
    public String mDungeonLootName = "";

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.dungeonloot")) {
            this.mDungeonLootName = aNBT.func_74779_i("gt.dungeonloot");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (UT.Code.stringValid(this.mDungeonLootName)) {
            aNBT.func_74778_a("gt.dungeonloot", this.mDungeonLootName);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (UT.Code.stringValid(this.mDungeonLootName)) {
            aList.add(LH.Chat.BLINKING_CYAN + "Contains Loot of " + LH.Chat.WHITE + LH.get("loot." + this.mDungeonLootName));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    protected void generateDungeonLoot() {
        if (this.isServerSide() && UT.Code.stringValid(this.mDungeonLootName)) {
            int j = this.func_70302_i_();
            for (int i = 0; i < j; ++i) {
                if (this.slotHas(i)) continue;
                this.slot(i, ChestGenHooks.getOneItem((String)this.mDungeonLootName, (Random)CS.RNGSUS));
            }
            this.mDungeonLootName = "";
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.generateDungeonLoot();
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean breakBlock() {
        this.generateDungeonLoot();
        return super.breakBlock();
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        if (this.showInCreative()) {
            if (CS.D1) {
                for (String tLoot : new String[]{"mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdLibrary", "strongholdCrossing", "villageBlacksmith", "bonusChest", "dungeonChest"}) {
                    aList.add(aBlock.mMultiTileEntityRegistry.getItem((int)aID, UT.NBT.makeString("gt.dungeonloot", tLoot)));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        super.onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ);
        aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, Blocks.field_150467_bQ.field_149762_H.func_150496_b(), (Blocks.field_150467_bQ.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150467_bQ.field_149762_H.func_150494_d() * 0.8f);
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return CS.ZL_INTEGER;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        this.setToAir();
    }

    @Override
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientDefault(aPlayer.field_71071_by, (ITileEntityInventoryGUI)this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonDefault(aPlayer.field_71071_by, this, aGUIID);
    }
}

