/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.RM;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityEnergy;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataConductor;
import gregapi.util.UT;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityWireElectric
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
gregapi.tileentity.energy.ITileEntityEnergy,
ITileEntityEnergyDataConductor,
ITileEntityProgress,
IMultiTileEntity.IMTE_GetDebugInfo,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock {
    public long mTransferredAmperes = 0L;
    public long mTransferredWattage = 0L;
    public long mWattageLast = 0L;
    public long mLoss = 1L;
    public long mAmperage = 1L;
    public long mVoltage = 32L;
    public byte mRenderType = 0;
    public byte mBurnCounter = 0;

    public static void addElectricWires(int aID, int aCreativeTabID, long aVoltage, long aAmperage, long aLossWire, long aLossCable, boolean aContactDamageWire, boolean aContactDamageCable, boolean aCable, MultiTileEntityRegistry aRegistry, MultiTileEntityBlock aBlock, Class<? extends TileEntity> aClass, OreDictMaterial aMat) {
        OreDictManager.INSTANCE.setTarget_(OP.wireGt01, aMat, aRegistry.add("1x " + aMat.getLocal() + " Wire", "Electric Wires", aID, aCreativeTabID, aClass, aMat.mToolQuality, 64, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[2]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 1L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt02, aMat, aRegistry.add("2x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 1, aCreativeTabID, aClass, aMat.mToolQuality, 32, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[3]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 2L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt03, aMat, aRegistry.add("3x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 2, aCreativeTabID, aClass, aMat.mToolQuality, 21, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[4]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 3L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt04, aMat, aRegistry.add("4x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 3, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[6]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 4L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt05, aMat, aRegistry.add("5x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 4, aCreativeTabID, aClass, aMat.mToolQuality, 12, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[7]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 5L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt06, aMat, aRegistry.add("6x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 5, aCreativeTabID, aClass, aMat.mToolQuality, 10, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[7]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 6L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt07, aMat, aRegistry.add("7x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 6, aCreativeTabID, aClass, aMat.mToolQuality, 9, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 7L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt08, aMat, aRegistry.add("8x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 7, aCreativeTabID, aClass, aMat.mToolQuality, 8, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 8L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt09, aMat, aRegistry.add("9x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 8, aCreativeTabID, aClass, aMat.mToolQuality, 7, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[9]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 9L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt10, aMat, aRegistry.add("10x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 9, aCreativeTabID, aClass, aMat.mToolQuality, 6, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[10]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 10L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt11, aMat, aRegistry.add("11x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 10, aCreativeTabID, aClass, aMat.mToolQuality, 5, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[11]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 11L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt12, aMat, aRegistry.add("12x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 11, aCreativeTabID, aClass, aMat.mToolQuality, 5, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[12]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 12L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt13, aMat, aRegistry.add("13x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 12, aCreativeTabID, aClass, aMat.mToolQuality, 4, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[13]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 13L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt14, aMat, aRegistry.add("14x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 13, aCreativeTabID, aClass, aMat.mToolQuality, 4, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[14]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 14L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt15, aMat, aRegistry.add("15x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 14, aCreativeTabID, aClass, aMat.mToolQuality, 4, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[15]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 15L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        OreDictManager.INSTANCE.setTarget_(OP.wireGt16, aMat, aRegistry.add("16x " + aMat.getLocal() + " Wire", "Electric Wires", aID + 15, aCreativeTabID, aClass, aMat.mToolQuality, 4, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 0, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 16L, "gt.contactdamage", aContactDamageWire, "gt.pipeloss", aLossWire), new Object[0]), true, false, true);
        if (aCable) {
            OreDictManager.INSTANCE.setTarget_(OP.cableGt01, aMat, aRegistry.add("1x " + aMat.getLocal() + " Cable", "Electric Wires", aID + 16, aCreativeTabID, aClass, aMat.mToolQuality, 64, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[4]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage, "gt.contactdamage", aContactDamageCable, "gt.pipeloss", aLossCable), new Object[0]), true, false, true);
            OreDictManager.INSTANCE.setTarget_(OP.cableGt02, aMat, aRegistry.add("2x " + aMat.getLocal() + " Cable", "Electric Wires", aID + 17, aCreativeTabID, aClass, aMat.mToolQuality, 32, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[6]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 2L, "gt.contactdamage", aContactDamageCable, "gt.pipeloss", aLossCable), new Object[0]), true, false, true);
            OreDictManager.INSTANCE.setTarget_(OP.cableGt04, aMat, aRegistry.add("4x " + aMat.getLocal() + " Cable", "Electric Wires", aID + 19, aCreativeTabID, aClass, aMat.mToolQuality, 16, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[8]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 4L, "gt.contactdamage", aContactDamageCable, "gt.pipeloss", aLossCable), new Object[0]), true, false, true);
            OreDictManager.INSTANCE.setTarget_(OP.cableGt08, aMat, aRegistry.add("8x " + aMat.getLocal() + " Cable", "Electric Wires", aID + 23, aCreativeTabID, aClass, aMat.mToolQuality, 8, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[12]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 8L, "gt.contactdamage", aContactDamageCable, "gt.pipeloss", aLossCable), new Object[0]), true, false, true);
            OreDictManager.INSTANCE.setTarget_(OP.cableGt12, aMat, aRegistry.add("12x " + aMat.getLocal() + " Cable", "Electric Wires", aID + 27, aCreativeTabID, aClass, aMat.mToolQuality, 4, aBlock, UT.NBT.make("gt.material", (Object)aMat, "gt.hardness", Float.valueOf(1.0f), "gt.resistance", Float.valueOf(2.0f), "gt.color", UT.Code.getRGBInt(aMat.fRGBaSolid), "gt.piperender", 1, "gt.diameter", Float.valueOf(CS.PX_P[16]), "gt.pipesize", aVoltage, "gt.pipebandwidth", aAmperage * 12L, "gt.contactdamage", aContactDamageCable, "gt.pipeloss", aLossCable), new Object[0]), true, false, true);
            for (OreDictMaterial tMat : ANY.Rubber.mToThis) {
                RM.Laminator.addRecipe2(true, 16L, 16L, OP.plate.mat(tMat, 1L), aRegistry.getItem(aID), aRegistry.getItem(aID + 16));
                RM.Laminator.addRecipe2(true, 16L, 16L, OP.plate.mat(tMat, 1L), aRegistry.getItem(aID + 1), aRegistry.getItem(aID + 16 + 1));
                RM.Laminator.addRecipe2(true, 16L, 32L, OP.plate.mat(tMat, 2L), aRegistry.getItem(aID + 3), aRegistry.getItem(aID + 16 + 3));
                RM.Laminator.addRecipe2(true, 16L, 48L, OP.plate.mat(tMat, 3L), aRegistry.getItem(aID + 7), aRegistry.getItem(aID + 16 + 7));
                RM.Laminator.addRecipe2(true, 16L, 64L, OP.plate.mat(tMat, 4L), aRegistry.getItem(aID + 11), aRegistry.getItem(aID + 16 + 11));
                RM.Laminator.addRecipe2(true, 16L, 16L, OP.foil.mat(tMat, 4L), aRegistry.getItem(aID), aRegistry.getItem(aID + 16));
                RM.Laminator.addRecipe2(true, 16L, 16L, OP.foil.mat(tMat, 4L), aRegistry.getItem(aID + 1), aRegistry.getItem(aID + 16 + 1));
                RM.Laminator.addRecipe2(true, 16L, 32L, OP.foil.mat(tMat, 8L), aRegistry.getItem(aID + 3), aRegistry.getItem(aID + 16 + 3));
                RM.Laminator.addRecipe2(true, 16L, 48L, OP.foil.mat(tMat, 12L), aRegistry.getItem(aID + 7), aRegistry.getItem(aID + 16 + 7));
                RM.Laminator.addRecipe2(true, 16L, 64L, OP.foil.mat(tMat, 16L), aRegistry.getItem(aID + 11), aRegistry.getItem(aID + 16 + 11));
            }
        }
    }

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.pipeloss")) {
            this.mLoss = Math.max(1L, aNBT.func_74763_f("gt.pipeloss"));
        }
        if (aNBT.func_74764_b("gt.pipesize")) {
            this.mVoltage = Math.max(1L, aNBT.func_74763_f("gt.pipesize"));
        }
        if (aNBT.func_74764_b("gt.pipebandwidth")) {
            this.mAmperage = Math.max(1L, aNBT.func_74763_f("gt.pipebandwidth"));
        }
        if (aNBT.func_74764_b("gt.piperender")) {
            this.mRenderType = aNBT.func_74771_c("gt.piperender");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.voltage") + this.mVoltage + " " + TD.Energy.EU.getLocalisedNameShort() + " (" + CS.VN[UT.Code.tierMin(this.mVoltage)] + ")");
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.amperage") + this.mAmperage);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.wire.stats.loss") + this.mLoss + " " + TD.Energy.EU.getLocalisedNameShort() + "/m");
        if (this.mContactDamage) {
            aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("electrometer") && this.isServerSide()) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mWattageLast + " EU/t");
            }
            return 1L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.mBurnCounter >= 16) {
                this.setToFire();
            } else {
                if (aTimer % 512L == 2L && this.mBurnCounter > 0) {
                    this.mBurnCounter = (byte)(this.mBurnCounter - 1);
                }
                this.mWattageLast = this.mTransferredWattage;
                this.mTransferredWattage = 0L;
                this.mTransferredAmperes = 0L;
                if (EnergyCompat.IC_ENERGY) {
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        long tEU;
                        TileEntity tEmitter;
                        if (!this.canAcceptEnergyFrom(tSide)) continue;
                        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                        if (tDelegator.mTileEntity instanceof ITileEntityEnergy) continue;
                        TileEntity tileEntity = tEmitter = tDelegator.mTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? (TileEntity)tDelegator.mTileEntity : EnergyNet.instance.getTileEntity(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ);
                        if (!(tEmitter instanceof IEnergySource) || !((IEnergySource)tEmitter).emitsEnergyTo((TileEntity)this, tDelegator.getForgeSideOfTileEntity()) || this.transferElectricity(tSide, tEU = (long)((IEnergySource)tEmitter).getOfferedEnergy(), 1L, -1L, new HashSetNoNulls<TileEntity>(false, this)) <= 0L) continue;
                        ((IEnergySource)tEmitter).drawEnergy((double)tEU);
                    }
                }
            }
        }
    }

    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, long aChannel, HashSetNoNulls<TileEntity> aAlreadyPassed) {
        if (this.mTimer < 1L || Math.abs(aVoltage) <= this.mLoss) {
            return 0L;
        }
        aVoltage = aVoltage > 0L ? (aVoltage -= this.mLoss) : (aVoltage += this.mLoss);
        long rUsedAmperes = 0L;
        for (byte tSide : CS.ALL_SIDES_VALID_BUT[aSide]) {
            if (!this.canEmitEnergyTo(tSide)) continue;
            if (aAmperage <= rUsedAmperes) break;
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
            if (!aAlreadyPassed.add((TileEntity)tDelegator.mTileEntity)) continue;
            if (tDelegator.mTileEntity instanceof MultiTileEntityWireElectric) {
                if (!((MultiTileEntityWireElectric)tDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.EU, tDelegator.mSideOfTileEntity, false)) continue;
                rUsedAmperes += ((MultiTileEntityWireElectric)tDelegator.mTileEntity).transferElectricity(tDelegator.mSideOfTileEntity, aVoltage, aAmperage - rUsedAmperes, aChannel, aAlreadyPassed);
                continue;
            }
            rUsedAmperes += ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.EU, aVoltage, aAmperage - rUsedAmperes, this, tDelegator);
        }
        return rUsedAmperes > 0L ? (this.addToEnergyTransferred(aVoltage, rUsedAmperes) ? rUsedAmperes : aAmperage) : 0L;
    }

    public boolean addToEnergyTransferred(long aVoltage, long aAmperage) {
        this.mTransferredAmperes += aAmperage;
        this.mTransferredWattage += Math.abs(aVoltage * aAmperage);
        if (Math.abs(aVoltage) > this.mVoltage || this.mTransferredAmperes > this.mAmperage) {
            if (this.mBurnCounter < 16) {
                this.mBurnCounter = (byte)(this.mBurnCounter + 1);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return EnergyCompat.canConnectElectricity(this, (TileEntity)aDelegator.mTileEntity, aDelegator.mSideOfTileEntity);
    }

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mContactDamage && !this.mFoamDried) {
            UT.Entities.applyElectricityDamage(aEntity, this.mWattageLast);
        }
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEnergyType == TD.Energy.EU;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.EU.AS_LIST;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, true) && this.canEmitEnergyTo(aSide);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false) && this.canAcceptEnergyFrom(aSide);
    }

    @Override
    public synchronized long doEnergyExtraction(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoExtract) {
        return 0L;
    }

    @Override
    public synchronized long doEnergyInjection(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        return aSize != 0L && this.isEnergyAcceptingFrom(aEnergyType, aSide, false) ? (aDoInject ? this.transferElectricity(aSide, aSize, aAmount, -1L, new HashSetNoNulls<TileEntity>(false, this)) : aAmount) : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mVoltage;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mVoltage;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mVoltage;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mVoltage;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean isEnergyConducting(TagData aEnergyType) {
        return aEnergyType == TD.Energy.EU;
    }

    @Override
    public long getEnergyMaxSize(TagData aEnergyType) {
        return aEnergyType == TD.Energy.EU ? this.mVoltage : 0L;
    }

    @Override
    public long getEnergyMaxPackets(TagData aEnergyType) {
        return aEnergyType == TD.Energy.EU ? this.mAmperage : 0L;
    }

    @Override
    public long getEnergyLossPerMeter(TagData aEnergyType) {
        return aEnergyType == TD.Energy.EU ? this.mLoss : 0L;
    }

    @Override
    public OreDictMaterial getEnergyConductorMaterial() {
        return this.mMaterial;
    }

    @Override
    public OreDictMaterial getEnergyConductorInsulation() {
        switch (this.mRenderType) {
            case 1: 
            case 2: {
                return ANY.Rubber;
            }
        }
        return MT.NULL;
    }

    public boolean canEmitEnergyTo(byte aSide) {
        return this.connected(aSide);
    }

    public boolean canAcceptEnergyFrom(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.mTransferredAmperes;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mAmperage;
    }

    @Override
    public ArrayList<String> getDebugInfo(int aScanLevel) {
        return aScanLevel > 0 ? new ArrayListNoNulls<String>(false, "Transferred Power: " + this.mWattageLast) : null;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return this.mRenderType == 1 || this.mRenderType == 2 ? BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.INSULATION_FULL, this.isPainted() ? this.mRGBa : UT.Code.getRGBInt(64L, 64L, 64L)) : BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), false, this.mRGBa);
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return this.mRenderType == 1 || this.mRenderType == 2 ? BlockTextureMulti.get(BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing), BlockTextureDefault.get((IIconContainer)(this.mRenderType == 2 ? Textures.BlockIcons.INSULATION_BUNDLED : (aDiameter < 0.37f ? Textures.BlockIcons.INSULATION_TINY : (aDiameter < 0.49f ? Textures.BlockIcons.INSULATION_SMALL : (aDiameter < 0.74f ? Textures.BlockIcons.INSULATION_MEDIUM : (aDiameter < 0.99f ? Textures.BlockIcons.INSULATION_LARGE : Textures.BlockIcons.INSULATION_HUGE))))), this.isPainted() ? this.mRGBa : UT.Code.getRGBInt(64L, 64L, 64L))) : BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing, this.mRGBa);
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.WIRE_ELECTRIC.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "cutter";
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.electric";
    }
}

