/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.tileentity.ITileEntityEnergy;
import gregapi.tileentity.connectors.MultiTileEntityWireElectric;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.tileentity.energy.ITileEntityEnergy;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityWireBundledElectric
extends MultiTileEntityWireElectric {
    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            this.mWattageLast = this.mTransferredWattage;
            this.mTransferredWattage = 0L;
            this.mTransferredAmperes = 0L;
            if (EnergyCompat.IC_ENERGY) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    long tEU;
                    TileEntity tEmitter;
                    if (!this.canAcceptEnergyFrom(tSide)) continue;
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (tDelegator.mTileEntity instanceof ITileEntityEnergy) continue;
                    TileEntity tileEntity = tEmitter = tDelegator.mTileEntity instanceof IEnergyTile || EnergyNet.instance == null ? (TileEntity)tDelegator.mTileEntity : EnergyNet.instance.getTileEntity(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ);
                    if (!(tEmitter instanceof IEnergySource) || !((IEnergySource)tEmitter).emitsEnergyTo((TileEntity)this, tDelegator.getForgeSideOfTileEntity()) || this.transferElectricity(tSide, tEU = (long)((IEnergySource)tEmitter).getOfferedEnergy(), 1L, -1L, new HashSetNoNulls<TileEntity>(false, this)) <= 0L) continue;
                    ((IEnergySource)tEmitter).drawEnergy((double)tEU);
                }
            }
        }
    }

    @Override
    public long transferElectricity(byte aSide, long aVoltage, long aAmperage, long aChannel, HashSetNoNulls<TileEntity> aAlreadyPassed) {
        long rUsedAmperes = 0L;
        if (this.mTimer < 1L) {
            return rUsedAmperes;
        }
        if (Math.abs(aVoltage) > this.mLoss) {
            aVoltage = aVoltage > 0L ? (aVoltage -= this.mLoss) : (aVoltage += this.mLoss);
            for (byte tSide : CS.ALL_SIDES_VALID_BUT[aSide]) {
                if (!this.canEmitEnergyTo(tSide)) continue;
                if (aAmperage > rUsedAmperes) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!aAlreadyPassed.add((TileEntity)tDelegator.mTileEntity)) continue;
                    if (tDelegator.mTileEntity instanceof MultiTileEntityWireElectric) {
                        if (!((MultiTileEntityWireElectric)tDelegator.mTileEntity).isEnergyAcceptingFrom(TD.Energy.EU, tDelegator.mSideOfTileEntity, false)) continue;
                        rUsedAmperes += ((MultiTileEntityWireElectric)tDelegator.mTileEntity).transferElectricity(tDelegator.mSideOfTileEntity, aVoltage, aAmperage - rUsedAmperes, aChannel, aAlreadyPassed);
                        continue;
                    }
                    rUsedAmperes += ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.EU, aVoltage, aAmperage - rUsedAmperes, this, tDelegator);
                    continue;
                }
                break;
            }
        } else {
            aVoltage = 0L;
        }
        return this.addToEnergyTransferred(aVoltage, rUsedAmperes) ? rUsedAmperes : aAmperage;
    }

    @Override
    public boolean addToEnergyTransferred(long aVoltage, long aAmperage) {
        this.mTransferredAmperes += aAmperage;
        this.mTransferredWattage += Math.abs(aVoltage * aAmperage);
        if (this.mTimer > 1L && (Math.abs(aVoltage) > this.mVoltage || this.mTransferredAmperes > this.mAmperage)) {
            this.setToFire();
            return false;
        }
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.bundled.electric";
    }
}

