/*
 * Decompiled with CFR 0.152.
 */
package gregapi.random;

import cpw.mods.fml.common.FMLCommonHandler;
import gregapi.data.CS;
import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityCanDelegate;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.IFluidHandler;

public class WorldAndCoords
implements IHasWorldAndCoords,
Comparable<WorldAndCoords> {
    public final int mX;
    public final int mY;
    public final int mZ;
    public final World mWorld;

    public WorldAndCoords(World aWorld, int aX, int aY, int aZ) {
        this.mWorld = aWorld;
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
    }

    public WorldAndCoords(World aWorld, ChunkCoordinates aCoords) {
        this.mWorld = aWorld;
        this.mX = aCoords.field_71574_a;
        this.mY = aCoords.field_71572_b;
        this.mZ = aCoords.field_71573_c;
    }

    public WorldAndCoords(TileEntity aTileEntity) {
        this.mWorld = aTileEntity.func_145831_w();
        this.mX = aTileEntity.field_145851_c;
        this.mY = aTileEntity.field_145848_d;
        this.mZ = aTileEntity.field_145849_e;
    }

    @Override
    public World getWorld() {
        return this.mWorld;
    }

    @Override
    public int getX() {
        return this.mX;
    }

    @Override
    public int getY() {
        return this.mY;
    }

    @Override
    public int getZ() {
        return this.mZ;
    }

    @Override
    public int getOffsetX(byte aSide) {
        return this.mX + CS.OFFX[aSide];
    }

    @Override
    public int getOffsetY(byte aSide) {
        return this.mY + CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZ(byte aSide) {
        return this.mZ + CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetX(byte aSide, int aMultiplier) {
        return this.mX + CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetY(byte aSide, int aMultiplier) {
        return this.mY + CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZ(byte aSide, int aMultiplier) {
        return this.mZ + CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetXN(byte aSide) {
        return this.mX - CS.OFFX[aSide];
    }

    @Override
    public int getOffsetYN(byte aSide) {
        return this.mY - CS.OFFY[aSide];
    }

    @Override
    public int getOffsetZN(byte aSide) {
        return this.mZ - CS.OFFZ[aSide];
    }

    @Override
    public int getOffsetXN(byte aSide, int aMultiplier) {
        return this.mX - CS.OFFX[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetYN(byte aSide, int aMultiplier) {
        return this.mY - CS.OFFY[aSide] * aMultiplier;
    }

    @Override
    public int getOffsetZN(byte aSide, int aMultiplier) {
        return this.mZ - CS.OFFZ[aSide] * aMultiplier;
    }

    @Override
    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates(this.mX, this.mY, this.mZ);
    }

    @Override
    public ChunkCoordinates getOffset(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetX(aSide, aMultiplier), this.getOffsetY(aSide, aMultiplier), this.getOffsetZ(aSide, aMultiplier));
    }

    @Override
    public ChunkCoordinates getOffsetN(byte aSide, int aMultiplier) {
        return new ChunkCoordinates(this.getOffsetXN(aSide, aMultiplier), this.getOffsetYN(aSide, aMultiplier), this.getOffsetZN(aSide, aMultiplier));
    }

    @Override
    public boolean isServerSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isServer() : !this.mWorld.field_72995_K;
    }

    @Override
    public boolean isClientSide() {
        return this.mWorld == null ? FMLCommonHandler.instance().getEffectiveSide().isClient() : this.mWorld.field_72995_K;
    }

    @Override
    public int rng(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    @Override
    public int getRandomNumber(int aRange) {
        return CS.RNGSUS.nextInt(aRange);
    }

    @Override
    public TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.mWorld == null ? null : this.mWorld.func_147438_o(aX, aY, aZ);
    }

    @Override
    public Block getBlock(int aX, int aY, int aZ) {
        return this.mWorld == null ? CS.NB : this.mWorld.func_147439_a(aX, aY, aZ);
    }

    @Override
    public byte getMetaData(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.func_72805_g(aX, aY, aZ));
    }

    @Override
    public byte getLightLevel(int aX, int aY, int aZ) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.func_72801_o(aX, aY, aZ) * 15L);
    }

    @Override
    public boolean getOpacity(int aX, int aY, int aZ) {
        return this.mWorld != null && this.mWorld.func_147439_a(aX, aY, aZ).func_149662_c();
    }

    @Override
    public boolean getSky(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_72937_j(aX, aY, aZ);
    }

    @Override
    public boolean getRain(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_72874_g(aX, aZ) <= aY;
    }

    @Override
    public boolean getAir(int aX, int aY, int aZ) {
        return this.mWorld == null || this.mWorld.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)this.mWorld, aX, aY, aZ);
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.getBiome(this.mX, this.mZ);
    }

    @Override
    public BiomeGenBase getBiome(int aX, int aZ) {
        return this.mWorld == null ? null : this.mWorld.func_72807_a(aX, aZ);
    }

    @Override
    public BiomeGenBase getBiome(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.func_72807_a(aCoords.field_71574_a, aCoords.field_71573_c);
    }

    @Override
    public TileEntity getTileEntity(ChunkCoordinates aCoords) {
        return this.mWorld == null ? null : this.mWorld.func_147438_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public Block getBlock(ChunkCoordinates aCoords) {
        return this.mWorld == null ? CS.NB : this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public byte getMetaData(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4(this.mWorld.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c));
    }

    @Override
    public byte getLightLevel(ChunkCoordinates aCoords) {
        return this.mWorld == null ? (byte)0 : UT.Code.bind4((long)this.mWorld.func_72801_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) * 15L);
    }

    @Override
    public boolean getOpacity(ChunkCoordinates aCoords) {
        return this.mWorld != null && this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).func_149662_c();
    }

    @Override
    public boolean getSky(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_72937_j(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public boolean getRain(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_72874_g(aCoords.field_71574_a, aCoords.field_71573_c) <= aCoords.field_71572_b;
    }

    @Override
    public boolean getAir(ChunkCoordinates aCoords) {
        return this.mWorld == null || this.mWorld.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c).isAir((IBlockAccess)this.mWorld, aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
    }

    @Override
    public Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public Block getBlockAtSide(byte aSide) {
        return this.getBlockAtSideAndDistance(aSide, 1);
    }

    @Override
    public Block getBlockAtSideAndDistance(byte aSide, int aDistance) {
        return this.getBlock(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getMetaDataOffset(int aX, int aY, int aZ) {
        return this.getMetaData(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public byte getMetaDataAtSide(byte aSide) {
        return this.getMetaDataAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getMetaDataAtSideAndDistance(byte aSide, int aDistance) {
        return this.getMetaData(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public byte getLightLevelAtSide(byte aSide) {
        return this.getLightLevelAtSideAndDistance(aSide, 1);
    }

    @Override
    public byte getLightLevelAtSideAndDistance(byte aSide, int aDistance) {
        return this.getLightLevel(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public boolean getOpacityAtSide(byte aSide) {
        return this.getOpacityAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getOpacityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getOpacity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getRainOffset(int aX, int aY, int aZ) {
        return this.getRain(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public boolean getRainAtSide(byte aSide) {
        return this.getRainAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getRainAtSideAndDistance(byte aSide, int aDistance) {
        return this.getRain(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public boolean getSkyAtSide(byte aSide) {
        return this.getSkyAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getSkyAtSideAndDistance(byte aSide, int aDistance) {
        return this.getSky(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public boolean getAirAtSide(byte aSide) {
        return this.getAirAtSideAndDistance(aSide, 1);
    }

    @Override
    public boolean getAirAtSideAndDistance(byte aSide, int aDistance) {
        return this.getAir(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.mX + aX, this.mY + aY, this.mZ + aZ);
    }

    @Override
    public TileEntity getTileEntityAtSideAndDistance(byte aSide, int aDistance) {
        return this.getTileEntity(this.getOffsetX(aSide, aDistance), this.getOffsetY(aSide, aDistance), this.getOffsetZ(aSide, aDistance));
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide) {
        return this.getAdjacentTileEntity(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide) {
        return this.getAdjacentInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide) {
        return this.getAdjacentSidedInventory(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide) {
        return this.getAdjacentTank(aSide, true, false);
    }

    @Override
    public DelegatorTileEntity<IInventory> getAdjacentInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IInventory>(tDelegator.mTileEntity instanceof IInventory ? (IInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<ISidedInventory> getAdjacentSidedInventory(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<ISidedInventory>(tDelegator.mTileEntity instanceof ISidedInventory ? (ISidedInventory)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getAdjacentTank(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide, aAllowDelegates, aNotConnectToDelegators);
        return new DelegatorTileEntity<IFluidHandler>(tDelegator.mTileEntity instanceof IFluidHandler ? (IFluidHandler)tDelegator.mTileEntity : null, tDelegator);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getAdjacentTileEntity(byte aSide, boolean aAllowDelegates, boolean aNotConnectToDelegators) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(aSide, 1);
        if (tTileEntity == null) {
            return new DelegatorTileEntity<Object>(null, this.mWorld, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPOS[aSide]);
        }
        if (aNotConnectToDelegators && tTileEntity instanceof ITileEntityCanDelegate && ((ITileEntityCanDelegate)tTileEntity).isExtender(aSide)) {
            return new DelegatorTileEntity<Object>(null, this.mWorld, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), CS.OPOS[aSide]);
        }
        if (aAllowDelegates && tTileEntity instanceof ITileEntityDelegating) {
            return ((ITileEntityDelegating)tTileEntity).getDelegateTileEntity(CS.OPOS[aSide]);
        }
        return new DelegatorTileEntity<TileEntity>(tTileEntity, tTileEntity.func_145831_w(), tTileEntity.field_145851_c, tTileEntity.field_145848_d, tTileEntity.field_145849_e, CS.OPOS[aSide]);
    }

    @Override
    public boolean hasRedstoneIncoming() {
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (this.getRedstoneIncoming(tSide) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte getRedstoneIncoming(byte aSide) {
        if (CS.SIDES_INVALID[aSide]) {
            byte rRedstone = 0;
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if ((rRedstone = (byte)Math.max(rRedstone, this.mWorld.func_72878_l(this.getOffsetX(tSide), this.getOffsetY(tSide), this.getOffsetZ(tSide), (int)tSide))) < 15) continue;
                return 15;
            }
            return rRedstone;
        }
        return UT.Code.bind4(this.mWorld.func_72878_l(this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)aSide));
    }

    @Override
    public byte getComparatorIncoming(byte aSide) {
        Block tBlock = this.getBlockAtSide(aSide);
        return tBlock.func_149740_M() ? UT.Code.bind4(tBlock.func_149736_g(this.mWorld, this.getOffsetX(aSide), this.getOffsetY(aSide), this.getOffsetZ(aSide), (int)CS.OPOS[aSide])) : this.getRedstoneIncoming(aSide);
    }

    public boolean equals(Object aObject) {
        return aObject instanceof WorldAndCoords && ((WorldAndCoords)aObject).mWorld == this.mWorld && ((WorldAndCoords)aObject).mX == this.mX && ((WorldAndCoords)aObject).mY == this.mY && ((WorldAndCoords)aObject).mZ == this.mZ;
    }

    public int hashCode() {
        return this.mX + this.mZ << 8 + this.mY << 16;
    }

    @Override
    public int compareTo(WorldAndCoords aObject) {
        return this.mY == aObject.mY ? (this.mZ == aObject.mZ ? this.mX - aObject.mX : this.mZ - aObject.mZ) : this.mY - aObject.mY;
    }

    public String toString() {
        return "Pos{x=" + this.mX + ", y=" + this.mY + ", z=" + this.mZ + '}';
    }
}

