/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.block.IBlockToolable;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Behavior_Tool
extends IBehavior.AbstractBehaviorDefault {
    public final String mToolName;
    public final String mSoundName;
    public final long mDamage;
    public final boolean mOnItemUseReturn;
    public final float mPitch;

    public Behavior_Tool(String aToolName) {
        this(aToolName, null, 0L, true, 1.0f);
    }

    public Behavior_Tool(String aToolName, boolean aOnItemUseReturn) {
        this(aToolName, null, 0L, aOnItemUseReturn, 1.0f);
    }

    public Behavior_Tool(String aToolName, long aDamage, boolean aOnItemUseReturn) {
        this(aToolName, null, aDamage, aOnItemUseReturn, 1.0f);
    }

    public Behavior_Tool(String aToolName, String aSoundName, long aDamage, boolean aOnItemUseReturn) {
        this(aToolName, aSoundName, aDamage, aOnItemUseReturn, 1.0f);
    }

    public Behavior_Tool(String aToolName, String aSoundName, long aDamage, boolean aOnItemUseReturn, boolean aRandomPitch) {
        this(aToolName, aSoundName, aDamage, aOnItemUseReturn, aRandomPitch ? CS.SFX.RANDOM_PITCH : 1.0f);
    }

    public Behavior_Tool(String aToolName, String aSoundName, long aDamage, boolean aOnItemUseReturn, float aPitch) {
        this.mToolName = aToolName;
        this.mSoundName = aSoundName;
        this.mDamage = aDamage;
        this.mOnItemUseReturn = aOnItemUseReturn;
        this.mPitch = aPitch;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
        long tDamage = IBlockToolable.Util.onToolClick(this.mToolName, Long.MAX_VALUE, (long)(aItem instanceof MultiItemTool ? ((MultiItemTool)aItem).getHarvestLevel(aStack, this.mToolName) : 1), (Entity)aPlayer, tChatReturn, (IInventory)(aPlayer == null ? null : aPlayer.field_71071_by), aPlayer != null && aPlayer.func_70093_af(), aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
        UT.Entities.sendchat((Object)aPlayer, tChatReturn, false);
        if (tDamage > 0L) {
            if (this.mDamage > 0L) {
                ((MultiItemTool)aItem).doDamage(aStack, UT.Code.units(tDamage, 10000L, this.mDamage, true), (EntityLivingBase)aPlayer, false);
            }
            if (this.mSoundName != null) {
                UT.Sounds.send(this.mSoundName, 1.0f, this.mPitch, aWorld, aX, aY, aZ);
            }
            return !aWorld.field_72995_K;
        }
        return false;
    }

    @Override
    public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return this.mOnItemUseReturn;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.tool.name." + this.mToolName, "Unknown") + "   " + LH.Chat.GRAY + LH.get("gt.lang.tool.tooltip." + this.mToolName, ""));
        return aList;
    }
}

