/*
 * Decompiled with CFR 0.152.
 */
package gregapi.fluid;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidGT
extends Fluid
implements Runnable {
    private final short[] mRGBa;
    public final IIconContainer mTexture;
    public final boolean mGas;
    public final int mTemperature;

    public FluidGT(String aName, String aTextureName, short[] aRGBa, long aTemperatureK, boolean aGas) {
        super(aName);
        this.mRGBa = aRGBa;
        this.mTexture = new Textures.BlockIcons.CustomIcon("fluids/" + aTextureName);
        this.mGas = aGas;
        this.setGaseous(this.mGas);
        this.mTemperature = UT.Code.bindInt(aTemperatureK);
        this.setTemperature(this.mTemperature);
        CS.GT.mAfterPostInit.add(this);
        CS.GT.mAfterServerStarted.add(this);
        CS.GAPI_POST.mAfterPostInit.add(this);
        CS.GAPI_POST.mAfterServerStarted.add(this);
    }

    public FluidGT(String aName, IIconContainer aTexture, short[] aRGBa, long aTemperatureK, boolean aGas) {
        super(aName);
        this.mRGBa = aRGBa;
        this.mTexture = aTexture;
        this.mGas = aGas;
        this.setGaseous(this.mGas);
        this.mTemperature = UT.Code.bindInt(aTemperatureK);
        this.setTemperature(this.mTemperature);
        CS.GT.mAfterPostInit.add(this);
        CS.GT.mAfterServerStarted.add(this);
        CS.GAPI_POST.mAfterPostInit.add(this);
        CS.GAPI_POST.mAfterServerStarted.add(this);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public String getLocalizedName(FluidStack stack) {
        return LH.get(this.getUnlocalizedName());
    }

    public String getLocalizedName() {
        return LH.get(this.getUnlocalizedName());
    }

    public int getTemperature(FluidStack aFluid) {
        return this.mTemperature;
    }

    public boolean isGaseous(FluidStack aFluid) {
        return this.mGas;
    }

    public int getColor(FluidStack aFluid) {
        return UT.Code.getRGBInt(this.mRGBa);
    }

    public IIcon getIcon(FluidStack aFluid) {
        return this.mTexture.getIcon(0);
    }

    public int getTemperature(World aWorld, int aX, int aY, int aZ) {
        return this.mTemperature;
    }

    public boolean isGaseous(World aWorld, int aX, int aY, int aZ) {
        return this.mGas;
    }

    public int getColor(World aWorld, int aX, int aY, int aZ) {
        return UT.Code.getRGBInt(this.mRGBa);
    }

    public IIcon getIcon(World aWorld, int aX, int aY, int aZ) {
        return this.mTexture.getIcon(0);
    }

    public int getColor() {
        return UT.Code.getRGBInt(this.mRGBa);
    }

    public IIcon getIcon() {
        return this.mTexture.getIcon(0);
    }

    public IIcon getStillIcon() {
        return this.mTexture.getIcon(0);
    }

    public IIcon getFlowingIcon() {
        return this.mTexture.getIcon(0);
    }

    @Override
    public void run() {
        this.setGaseous(this.mGas);
        this.setTemperature(this.mTemperature);
    }
}

