/*
 * Decompiled with CFR 0.152.
 */
package gregapi.config;

import gregapi.api.Abstract_Mod;
import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Config
implements Runnable {
    private boolean mUsesDefaultsInNames = true;
    public boolean mSaveOnEdit = true;
    public final Configuration mConfig;
    public static Configuration sConfigFileIDs;
    private static boolean sIDConfigNeedsSaving;

    public Config(String aFileName) {
        this(CS.DirectoriesGT.CONFIG_GT, aFileName);
    }

    public Config(String aDirPath, String aFileName) {
        this(new File(aDirPath), aFileName);
    }

    public Config(File aDirPath, String aFileName) {
        File tPathUppercase = new File(aDirPath, aFileName);
        File tPathLowercase = new File(aDirPath, aFileName.toLowerCase());
        File tPathUsed = tPathUppercase;
        try {
            if (aFileName.equals(aFileName.toLowerCase())) {
                if (tPathUsed.renameTo(tPathLowercase)) {
                    tPathUsed = tPathLowercase;
                }
            } else if (tPathUppercase.exists()) {
                if (tPathLowercase.exists() && !Files.isSameFile(tPathLowercase.toPath(), tPathUppercase.toPath())) {
                    tPathUsed = tPathLowercase;
                    tPathUppercase.delete();
                } else if (tPathUsed.renameTo(tPathLowercase)) {
                    tPathUsed = tPathLowercase;
                }
            } else {
                tPathUsed = tPathLowercase;
            }
        }
        catch (IOException e) {
            CS.ERR.println("IO EXCEPTION WHEN ACCESSING CONFIG: " + tPathLowercase);
        }
        catch (SecurityException e) {
            CS.ERR.println("SECURITY EXCEPTION WHEN ACCESSING CONFIG: " + tPathLowercase);
        }
        catch (Throwable e) {
            CS.ERR.println("RANDOM EXCEPTION WHEN ACCESSING CONFIG: " + tPathLowercase);
            e.printStackTrace(CS.ERR);
        }
        this.mConfig = new Configuration(tPathUsed);
        this.mConfig.load();
        this.mConfig.save();
        Abstract_Mod.sConfigs.add(this);
    }

    @Deprecated
    public Config(File aConfig) {
        this(new Configuration(aConfig));
    }

    @Deprecated
    public Config(Configuration aConfig) {
        this.mConfig = aConfig;
        this.mConfig.load();
        this.mConfig.save();
        Abstract_Mod.sConfigs.add(this);
    }

    public Config setUseDefaultInNames(boolean aUsesDefaultsInNames) {
        this.mUsesDefaultsInNames = aUsesDefaultsInNames;
        return this;
    }

    public Config setSaveOnEdit(boolean aSaveOnEdit) {
        this.mSaveOnEdit = aSaveOnEdit;
        return this;
    }

    public boolean get(Object aCategory, ItemStack aStack, boolean aDefault) {
        return this.get(aCategory, ST.configName(aStack), aDefault);
    }

    public boolean get(Object aCategory, String aName, boolean aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        boolean rResult = tProperty.getBoolean(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && this.mSaveOnEdit && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public int get(Object aCategory, ItemStack aStack, long aDefault) {
        return this.get(aCategory, ST.configName(aStack), aDefault);
    }

    public int get(Object aCategory, String aName, long aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return UT.Code.bindInt(aDefault);
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + UT.Code.bindInt(aDefault) : "")).replaceAll("\\|", "_"), UT.Code.bindInt(aDefault));
        int rResult = tProperty.getInt(UT.Code.bindInt(aDefault));
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && this.mSaveOnEdit && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public String get(Object aCategory, ItemStack aStack, String aDefault) {
        return this.get(aCategory, ST.configName(aStack), aDefault);
    }

    public String get(Object aCategory, String aName, String aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        String rResult = tProperty.getString();
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && this.mSaveOnEdit && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public OreDictMaterial get(Object aCategory, String aName, OreDictMaterial aDefault) {
        if (aDefault == null) {
            aDefault = MT.NULL;
        }
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault.mNameInternal : "")).replaceAll("\\|", "_"), aDefault.mNameInternal);
        OreDictMaterial rResult = OreDictMaterial.get(tProperty.getString());
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && this.mSaveOnEdit && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public double get(Object aCategory, ItemStack aStack, double aDefault) {
        return this.get(aCategory, ST.configName(aStack), aDefault);
    }

    public double get(Object aCategory, String aName, double aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = this.mConfig.get(aCategory.toString().replaceAll("\\|", "_"), (aName + (this.mUsesDefaultsInNames ? "_" + aDefault : "")).replaceAll("\\|", "_"), aDefault);
        double rResult = tProperty.getDouble(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && this.mSaveOnEdit && !tProperty.wasRead()) {
            this.mConfig.save();
        }
        return rResult;
    }

    public String toString() {
        return "Config File: " + this.mConfig.getConfigFile().getAbsolutePath();
    }

    @Override
    public void run() {
        this.mConfig.save();
        if (sIDConfigNeedsSaving) {
            sConfigFileIDs.save();
            sIDConfigNeedsSaving = false;
        }
    }

    public static int addIDConfig(Object aCategory, String aName, int aDefault) {
        if (UT.Code.stringInvalid(aName)) {
            return aDefault;
        }
        Property tProperty = sConfigFileIDs.get(aCategory.toString().replaceAll("\\|", "."), aName.replaceAll("\\|", "."), aDefault);
        int rResult = tProperty.getInt(aDefault);
        if (Abstract_Mod.sFinalized >= Abstract_Mod.sModCountUsingGTAPI && !tProperty.wasRead()) {
            sConfigFileIDs.save();
        } else {
            sIDConfigNeedsSaving = true;
        }
        return rResult;
    }

    static {
        sIDConfigNeedsSaving = false;
    }
}

