/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.misc;

import gregapi.block.IBlockBase;
import gregapi.block.IBlockToolable;
import gregapi.block.ItemBlockBase;
import gregapi.block.ToolCompat;
import gregapi.compat.galacticraft.IBlockSealable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.IEntitySelector;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityMinecartCommandBlock;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBaseRail
extends BlockRailBase
implements IBlockBase,
IBlockSealable,
IBlockToolable {
    public final String mNameInternal;
    public final float mSpeed;
    public final float mExplosionResistance;
    public final IIconContainer mIconPrimary;
    public final IIconContainer mIconSecondary;
    public final int mHarvestLevel;
    public final boolean mPowerRail;
    public final boolean mDetectorRail;

    public BlockBaseRail(Class<? extends ItemBlockBase> aItemClass, String aNameInternal, String aLocalName, boolean aPowerRail, boolean aDetectorRail, float aSpeed, float aExplosionResistance, int aHarvestLevel, IIconContainer aIconPrimary, IIconContainer aIconSecondary) {
        super(aPowerRail || aDetectorRail);
        this.mNameInternal = aNameInternal;
        this.func_149663_c(this.mNameInternal);
        this.func_149647_a(CreativeTabs.field_78029_e);
        ST.register((Block)this, this.mNameInternal, aItemClass);
        LH.add(this.mNameInternal, aLocalName);
        this.mExplosionResistance = aExplosionResistance;
        this.mHarvestLevel = aHarvestLevel;
        this.mSpeed = aSpeed;
        this.mIconSecondary = aIconSecondary;
        this.mIconPrimary = aIconPrimary;
        this.mDetectorRail = aDetectorRail;
        this.mPowerRail = aPowerRail;
        if (aPowerRail) {
            CS.REDSTONE_SINKS.add((Block)this);
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make((Block)this, 1L, 32767L));
        }
    }

    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.railspeed") + LH.Chat.GREEN + Math.min(MD.RC.mLoaded ? 3.0f : 10.0f, this.mSpeed / 0.4f) + "x");
    }

    public final String func_149739_a() {
        return this.mNameInternal;
    }

    @Override
    public String name(byte aMeta) {
        return this.mNameInternal;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)this.mNameInternal);
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150448_aq.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return this.mExplosionResistance;
    }

    public float func_149638_a(Entity aEntity) {
        return this.mExplosionResistance;
    }

    public String getHarvestTool(int aMeta) {
        return "crowbar";
    }

    public int getHarvestLevel(int aMeta) {
        return this.mHarvestLevel;
    }

    public boolean func_149700_E() {
        return this.canSilkHarvest((byte)0);
    }

    public boolean canSilkHarvest(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        return this.canSilkHarvest(UT.Code.bind4(aMeta));
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return false;
    }

    public int func_149692_a(int aMeta) {
        return 0;
    }

    public int func_149745_a(Random par1Random) {
        return 1;
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return 0;
    }

    public int func_149717_k() {
        return 0;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this);
    }

    public Item func_149694_d(World aWorld, int aX, int aY, int aZ) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149651_a(IIconRegister aIconRegister) {
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.canCreatureSpawn(WD.meta(aWorld, aX, aY, aZ));
    }

    public void func_149666_a(Item aItem, CreativeTabs par2CreativeTabs, List aList) {
        aList.add(ST.make(aItem, 1L, 0L));
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        return ((this.mPowerRail || this.mDetectorRail ? (aMeta & 8) != 0 : aMeta >= 6) ? this.mIconSecondary : this.mIconPrimary).getIcon(0);
    }

    public boolean isSealed(World aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return false;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public byte maxMeta() {
        return 1;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return this.mExplosionResistance;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return 64;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isFlammable(byte aMeta) {
        return this.getFlammability(aMeta) > 0;
    }

    @Override
    public boolean isFireSource(byte aMeta) {
        return false;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return aStack;
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        if (!aWorld.field_72995_K) {
            if (aTool.equals("softhammer") && this.mPowerRail) {
                aWorld.field_72995_K = true;
                boolean tResult = aWorld.func_147465_d(aX, aY, aZ, (Block)this, WD.meta((IBlockAccess)aWorld, aX, aY, aZ) ^ 8, 0);
                aWorld.field_72995_K = false;
                return tResult ? 10000L : 0L;
            }
            if (aTool.equals("crowbar")) {
                byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
                aWorld.field_72995_K = true;
                boolean tResult = aWorld.func_147465_d(aX, aY, aZ, (Block)this, this.func_150050_e() ? (aMeta + 1) % 10 : aMeta / 8 * 8 + (aMeta % 8 + 1) % 6, 0);
                aWorld.field_72995_K = false;
                return tResult ? 2000L : 0L;
            }
        }
        return ToolCompat.onToolClick((Block)this, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
    }

    protected boolean func_150058_a(World aWorld, int aX, int aY, int aZ, int p_150058_5_, boolean p_150058_6_, int p_150058_7_) {
        if (p_150058_7_ >= 8) {
            return false;
        }
        int j1 = p_150058_5_ & 7;
        boolean flag1 = true;
        switch (j1) {
            case 0: {
                if (p_150058_6_) {
                    ++aZ;
                    break;
                }
                --aZ;
                break;
            }
            case 1: {
                if (p_150058_6_) {
                    --aX;
                    break;
                }
                ++aX;
                break;
            }
            case 2: {
                if (p_150058_6_) {
                    --aX;
                } else {
                    ++aX;
                    ++aY;
                    flag1 = false;
                }
                j1 = 1;
                break;
            }
            case 3: {
                if (p_150058_6_) {
                    --aX;
                    ++aY;
                    flag1 = false;
                } else {
                    ++aX;
                }
                j1 = 1;
                break;
            }
            case 4: {
                if (p_150058_6_) {
                    ++aZ;
                } else {
                    --aZ;
                    ++aY;
                    flag1 = false;
                }
                j1 = 0;
                break;
            }
            case 5: {
                if (p_150058_6_) {
                    ++aZ;
                    ++aY;
                    flag1 = false;
                } else {
                    --aZ;
                }
                j1 = 0;
            }
        }
        return this.func_150057_a(aWorld, aX, aY, aZ, p_150058_6_, p_150058_7_, j1) || flag1 && this.func_150057_a(aWorld, aX, aY - 1, aZ, p_150058_6_, p_150058_7_, j1);
    }

    protected boolean func_150057_a(World aWorld, int aX, int aY, int aZ, boolean p_150057_5_, int p_150057_6_, int p_150057_7_) {
        if (aWorld.func_147439_a(aX, aY, aZ) == this) {
            byte j1 = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
            int k1 = j1 & 7;
            if (p_150057_7_ == 1 && (k1 == 0 || k1 == 4 || k1 == 5)) {
                return false;
            }
            if (p_150057_7_ == 0 && (k1 == 1 || k1 == 2 || k1 == 3)) {
                return false;
            }
            if ((j1 & 8) != 0) {
                if (aWorld.func_72864_z(aX, aY, aZ)) {
                    return true;
                }
                return this.func_150058_a(aWorld, aX, aY, aZ, j1, p_150057_5_, p_150057_6_ + 1);
            }
        }
        return false;
    }

    protected void func_150048_a(World aWorld, int aX, int aY, int aZ, int aMeta, int aData, Block aBlock) {
        if (this.mPowerRail) {
            boolean flag = aWorld.func_72864_z(aX, aY, aZ);
            flag = flag || this.func_150058_a(aWorld, aX, aY, aZ, aMeta, true, 0) || this.func_150058_a(aWorld, aX, aY, aZ, aMeta, false, 0);
            boolean flag1 = false;
            if (flag && (aMeta & 8) == 0) {
                aWorld.func_72921_c(aX, aY, aZ, aData | 8, 3);
                flag1 = true;
            } else if (!flag && (aMeta & 8) != 0) {
                aWorld.func_72921_c(aX, aY, aZ, aData, 3);
                flag1 = true;
            }
            if (flag1) {
                aWorld.func_147459_d(aX, aY - 1, aZ, (Block)this);
                if (aData == 2 || aData == 3 || aData == 4 || aData == 5) {
                    aWorld.func_147459_d(aX, aY + 1, aZ, (Block)this);
                }
            }
        }
    }

    public int func_149738_a(World aWorld) {
        return 20;
    }

    public boolean func_149744_f() {
        return this.mDetectorRail;
    }

    public void func_149670_a(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        byte l;
        if (this.mDetectorRail && !aWorld.field_72995_K && ((l = WD.meta((IBlockAccess)aWorld, aX, aY, aZ)) & 8) == 0) {
            this.func_150054_a(aWorld, aX, aY, aZ, l);
        }
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        byte l;
        if (this.mDetectorRail && !aWorld.field_72995_K && ((l = WD.meta((IBlockAccess)aWorld, aX, aY, aZ)) & 8) != 0) {
            this.func_150054_a(aWorld, aX, aY, aZ, l);
        }
    }

    public int func_149709_b(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.mDetectorRail ? ((WD.meta(aWorld, aX, aY, aZ) & 8) != 0 ? 15 : 0) : 0;
    }

    public int func_149748_c(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.mDetectorRail ? ((WD.meta(aWorld, aX, aY, aZ) & 8) == 0 ? 0 : (aSide == 1 ? 15 : 0)) : 0;
    }

    private void func_150054_a(World aWorld, int aX, int aY, int aZ, int aMetaData) {
        boolean flag = (aMetaData & 8) != 0;
        boolean flag1 = false;
        List list = aWorld.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)aY, (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875)));
        if (!list.isEmpty()) {
            flag1 = true;
        }
        if (flag1 && !flag) {
            aWorld.func_72921_c(aX, aY, aZ, aMetaData | 8, 3);
            aWorld.func_147459_d(aX, aY, aZ, (Block)this);
            aWorld.func_147459_d(aX, aY - 1, aZ, (Block)this);
            aWorld.func_147458_c(aX, aY, aZ, aX, aY, aZ);
        }
        if (!flag1 && flag) {
            aWorld.func_72921_c(aX, aY, aZ, aMetaData & 7, 3);
            aWorld.func_147459_d(aX, aY, aZ, (Block)this);
            aWorld.func_147459_d(aX, aY - 1, aZ, (Block)this);
            aWorld.func_147458_c(aX, aY, aZ, aX, aY, aZ);
        }
        if (flag1) {
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, this.func_149738_a(aWorld));
        }
        aWorld.func_147453_f(aX, aY, aZ, (Block)this);
    }

    public void func_149726_b(World p_149726_1_, int p_149726_2_, int p_149726_3_, int p_149726_4_) {
        super.func_149726_b(p_149726_1_, p_149726_2_, p_149726_3_, p_149726_4_);
        if (this.mDetectorRail) {
            this.func_150054_a(p_149726_1_, p_149726_2_, p_149726_3_, p_149726_4_, p_149726_1_.func_72805_g(p_149726_2_, p_149726_3_, p_149726_4_));
        }
    }

    public boolean func_149740_M() {
        return this.mDetectorRail;
    }

    public int func_149736_g(World aWorld, int aX, int aY, int aZ, int aSide) {
        if (this.mDetectorRail && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 8) > 0) {
            List list = aWorld.func_72872_a(EntityMinecartCommandBlock.class, AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)aY, (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875)));
            if (list.size() > 0) {
                return ((EntityMinecartCommandBlock)list.get(0)).func_145822_e().func_145760_g();
            }
            List list1 = aWorld.func_82733_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)aY, (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875)), IEntitySelector.field_96566_b);
            if (list1.size() > 0) {
                return Container.func_94526_b((IInventory)((IInventory)list1.get(0)));
            }
        }
        return 0;
    }

    public float getRailMaxSpeed(World aWorld, EntityMinecart aCart, int aX, int aY, int aZ) {
        switch (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) {
            case 0: {
                if (WD.block((IBlockAccess)aWorld, aX, aY, aZ + 1) instanceof BlockBaseRail && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ + 1) & 7) == 0 && WD.block((IBlockAccess)aWorld, aX, aY, aZ - 1) instanceof BlockBaseRail && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ - 1) & 7) == 0) {
                    return aWorld.func_72873_a(aX, aY, aZ, 17) ? this.mSpeed : Math.min(this.mSpeed, 1.0f);
                }
            }
            case 1: {
                if (!(WD.block((IBlockAccess)aWorld, aX + 1, aY, aZ) instanceof BlockBaseRail) || (WD.meta((IBlockAccess)aWorld, aX + 1, aY, aZ) & 7) != 1 || !(WD.block((IBlockAccess)aWorld, aX - 1, aY, aZ) instanceof BlockBaseRail) || (WD.meta((IBlockAccess)aWorld, aX - 1, aY, aZ) & 7) != 1) break;
                return aWorld.func_72873_a(aX, aY, aZ, 17) ? this.mSpeed : Math.min(this.mSpeed, 1.0f);
            }
        }
        return Math.min(this.mSpeed, 0.4f);
    }

    public void onMinecartPass(World aWorld, EntityMinecart aCart, int aX, int aY, int aZ) {
        if (this.mPowerRail) {
            byte tRailMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
            double tMotion = Math.sqrt(aCart.field_70159_w * aCart.field_70159_w + aCart.field_70179_y * aCart.field_70179_y);
            if ((tRailMeta & 8) != 0) {
                if (tMotion > 0.01) {
                    aCart.field_70159_w *= 2.0;
                    aCart.field_70179_y *= 2.0;
                } else if ((tRailMeta = (byte)(tRailMeta & 7)) == 1) {
                    if (aWorld.func_147439_a(aX - 1, aY, aZ).isNormalCube((IBlockAccess)aWorld, aX - 1, aY, aZ)) {
                        aCart.field_70159_w = 0.02;
                    } else if (aWorld.func_147439_a(aX + 1, aY, aZ).isNormalCube((IBlockAccess)aWorld, aX + 1, aY, aZ)) {
                        aCart.field_70159_w = -0.02;
                    }
                } else if (tRailMeta == 0) {
                    if (aWorld.func_147439_a(aX, aY, aZ - 1).isNormalCube((IBlockAccess)aWorld, aX, aY, aZ - 1)) {
                        aCart.field_70179_y = 0.02;
                    } else if (aWorld.func_147439_a(aX, aY, aZ + 1).isNormalCube((IBlockAccess)aWorld, aX, aY, aZ + 1)) {
                        aCart.field_70179_y = -0.02;
                    }
                }
            } else if (tMotion < 0.03) {
                aCart.field_70159_w = 0.0;
                aCart.field_70181_x = 0.0;
                aCart.field_70179_y = 0.0;
            } else {
                aCart.field_70159_w /= 2.0;
                aCart.field_70181_x = 0.0;
                aCart.field_70179_y /= 2.0;
            }
        }
    }

    @Override
    public boolean onItemUseFirst(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aStack.field_77994_a == 0) {
            return false;
        }
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (tBlock == Blocks.field_150431_aC && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (tBlock != Blocks.field_150395_bd && tBlock != Blocks.field_150329_H && tBlock != Blocks.field_150330_I && !tBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aX += CS.OFFX[aSide];
            aY += CS.OFFY[aSide];
            aZ += CS.OFFZ[aSide];
        }
        if (!aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack) || aY == 255 && this.func_149688_o().func_76220_a() || !aWorld.func_147472_a((Block)this, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack)) {
            return false;
        }
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, CS.SIDES_AXIS_X[UT.Code.getHorizontalForPlayerPlacing((Entity)aPlayer)] ? 1 : 0)) {
            aWorld.func_72908_a((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.field_149762_H.func_150496_b(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
            --aStack.field_77994_a;
        }
        return true;
    }
}

