/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.tree;

import gregapi.block.tree.BlockBaseSapling;
import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenTreeCinnamon
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenTreeCinnamon(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_CINNAMON.contains(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        if (!CS.BlocksGT.plantableTrees.contains(aContact)) {
            return false;
        }
        if (!WD.easyRep(aWorld, aX, aY + 1, aZ)) {
            return false;
        }
        return ((BlockBaseSapling)CS.BlocksGT.Saplings_AB).grow(aWorld, aX, aY + 1, aZ, (byte)5, aRandom);
    }
}

