/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.tree;

import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.util.ST;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOnSurface;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenLogMossy
extends WorldgenOnSurface {
    @SafeVarargs
    public WorldgenLogMossy(String aName, boolean aDefault, int aAmount, int aProbability, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aAmount, aProbability, aLists);
    }

    @Override
    public int canGenerate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return 0;
        }
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_PLAINS.contains(tName) && !CS.BIOMES_WOODS.contains(tName) && !CS.BIOMES_SWAMP.contains(tName)) continue;
            return this.mAmount;
        }
        return 0;
    }

    @Override
    public boolean tryPlaceStuff(World aWorld, int aX, int aY, int aZ, Random aRandom, Block aContact) {
        if (!CS.BlocksGT.plantableTrees.contains(aContact) && aContact != Blocks.field_150354_m) {
            return false;
        }
        if (!WD.air(aWorld, aX, aY + 1, aZ)) {
            return false;
        }
        switch (aRandom.nextInt(3)) {
            case 0: {
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX, aY - 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Y[2], 2L);
                }
                WD.set(aWorld, aX, aY, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Y[2], 2L);
                WD.set(aWorld, aX, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Y[2], 2L);
                WD.set(aWorld, aX, aY + 2, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Y[2], 2L);
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX, aY + 3, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Y[2], 2L);
                }
                return true;
            }
            case 1: {
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX - 2, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_X[2], 2L);
                }
                WD.set(aWorld, aX - 1, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_X[2], 2L);
                WD.set(aWorld, aX, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_X[2], 2L);
                WD.set(aWorld, aX + 1, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_X[2], 2L);
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX + 2, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_X[2], 2L);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX - 1, aY + 2, aZ, aRandom);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX, aY + 2, aZ, aRandom);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX + 1, aY + 2, aZ, aRandom);
                }
                return true;
            }
            case 2: {
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX, aY + 1, aZ - 2, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Z[2], 2L);
                }
                WD.set(aWorld, aX, aY + 1, aZ - 1, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Z[2], 2L);
                WD.set(aWorld, aX, aY + 1, aZ, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Z[2], 2L);
                WD.set(aWorld, aX, aY + 1, aZ + 1, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Z[2], 2L);
                if (aRandom.nextBoolean()) {
                    WD.set(aWorld, aX, aY + 1, aZ + 2, (Block)CS.BlocksGT.Log1, (long)CS.PILLARS_Z[2], 2L);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX, aY + 2, aZ - 1, aRandom);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX, aY + 2, aZ, aRandom);
                }
                if (aRandom.nextBoolean()) {
                    this.setMushroom(aWorld, aX, aY + 2, aZ + 1, aRandom);
                }
                return true;
            }
        }
        return false;
    }

    public boolean setMushroom(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (!WD.air(aWorld, aX, aY, aZ)) {
            return false;
        }
        switch (aRandom.nextInt(MD.HaC.mLoaded ? 3 : 2)) {
            case 0: {
                return WD.set(aWorld, aX, aY, aZ, (Block)Blocks.field_150337_Q, 0L, 2L);
            }
            case 1: {
                return WD.set(aWorld, aX, aY, aZ, (Block)Blocks.field_150338_P, 0L, 2L);
            }
            case 2: {
                return WD.set(aWorld, aX, aY, aZ, ST.block(MD.HaC, "mushroomgarden"), 0L, 2L);
            }
        }
        return false;
    }
}

